/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.utils;

import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CredentialsValue;
import com.alibaba.ans.shaded.org.apache.commons.codec.binary.Base64;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SpasUtil {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static CredentialsValue credentialsValue;

    public static String sign(String data, String key) throws Exception {
        try {
            byte[] signature = SpasUtil.sign(data.getBytes(UTF8), key.getBytes(UTF8), SigningAlgorithm.HmacSHA1);
            return new String(Base64.encodeBase64(signature));
        }
        catch (Exception e) {
            throw new Exception("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws Exception {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new Exception("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialsValue init() {
        FileInputStream propertiesIS;
        String propertyPath = System.getProperty("spas.identity");
        if (propertyPath == null) {
            return new CredentialsValue();
        }
        try {
            propertiesIS = new FileInputStream(propertyPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(propertiesIS);
        }
        catch (IOException e) {
            CredentialsValue credentialsValue = new CredentialsValue();
            return credentialsValue;
        }
        finally {
            try {
                ((InputStream)propertiesIS).close();
            }
            catch (IOException e) {
                return new CredentialsValue();
            }
        }
        String accessKey = null;
        String secretKey = null;
        if (properties.containsKey("accessKey")) {
            accessKey = properties.getProperty("accessKey");
        }
        if (properties.containsKey("secretKey")) {
            secretKey = properties.getProperty("secretKey");
        }
        if (accessKey == null || accessKey.trim().isEmpty() || secretKey == null || secretKey.trim().isEmpty()) {
            return new CredentialsValue();
        }
        return new CredentialsValue(accessKey, secretKey);
    }

    static {
        if (credentialsValue == null) {
            credentialsValue = SpasUtil.init();
        }
    }

    public static enum SigningAlgorithm {
        HmacSHA1;

    }
}

