/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.util;

import com.alibaba.citrus.dev.handler.util.ConfigurationFile;
import com.alibaba.citrus.dev.handler.util.DomUtil;
import com.alibaba.citrus.dev.handler.util.Element;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFileReader {
    private final ConfigurationFile[] configurationFiles;
    private final String baseURL;
    private final ResourceLoader loader;

    public ConfigurationFileReader(ResourceLoader loader, String[] configLocations) throws IOException {
        this.loader = Assert.assertNotNull(loader);
        LinkedList<NamedResource> resources = CollectionUtil.createLinkedList();
        for (String configLocation : configLocations) {
            if (loader instanceof ResourcePatternResolver) {
                Resource[] results = ((ResourcePatternResolver)loader).getResources(configLocation);
                if (ArrayUtil.isEmptyArray(results)) continue;
                for (Resource res : results) {
                    resources.add(new NamedResource(configLocation, res));
                }
                continue;
            }
            Resource res = loader.getResource(configLocation);
            if (res == null) continue;
            resources.add(new NamedResource(configLocation, res));
        }
        URL base = null;
        try {
            base = URI.create(loader.getResource("WEB-INF/web.xml").getURL().toURI() + "/../..").normalize().toURL();
        }
        catch (URISyntaxException e) {
            Assert.unexpectedException(e);
        }
        this.baseURL = StringUtil.trimEnd(base.toExternalForm(), "/");
        LinkedList<ConfigurationFile> configurationFiles = CollectionUtil.createLinkedList();
        HashSet<String> parsedNames = CollectionUtil.createHashSet();
        for (NamedResource namedResource : resources) {
            ConfigurationFile configurationFile = this.parseConfigurationFile(namedResource, parsedNames);
            if (configurationFile == null) continue;
            configurationFiles.add(configurationFile);
        }
        this.configurationFiles = configurationFiles.toArray(new ConfigurationFile[configurationFiles.size()]);
    }

    private ConfigurationFile parseConfigurationFile(final NamedResource namedResource, final Set<String> parsedNames) {
        Element rootElement;
        URL url;
        try {
            url = namedResource.resource.getURL();
        }
        catch (IOException e) {
            Assert.unexpectedException(e);
            return null;
        }
        String name = url.toExternalForm();
        if (name.startsWith(this.baseURL)) {
            name = name.substring(this.baseURL.length());
        }
        if (parsedNames.contains(name)) {
            return null;
        }
        parsedNames.add(name);
        final LinkedList<ConfigurationFile> importedConfigurationFiles = CollectionUtil.createLinkedList();
        try {
            rootElement = DomUtil.readDocument(name, url, new DomUtil.ElementFilter(){

                public org.dom4j.Element filter(org.dom4j.Element e) throws Exception {
                    Attribute attr = e.attribute(new QName("schemaLocation", new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance")));
                    if (attr != null) {
                        e.remove(attr);
                    }
                    if ("http://www.springframework.org/schema/beans".equals(e.getNamespaceURI()) && "import".equals(e.getName())) {
                        Resource importedResource;
                        ConfigurationFile importedConfigurationFile;
                        String importedResourceName = StringUtil.trimToNull(e.attributeValue("resource"));
                        if (importedResourceName != null && (importedConfigurationFile = ConfigurationFileReader.this.parseConfigurationFile(new NamedResource(importedResourceName, importedResource = importedResourceName.contains(":") ? ConfigurationFileReader.this.loader.getResource(importedResourceName) : namedResource.resource.createRelative(importedResourceName)), parsedNames)) != null) {
                            importedConfigurationFiles.add(importedConfigurationFile);
                        }
                        return null;
                    }
                    return e;
                }
            });
        }
        catch (Exception e) {
            rootElement = new Element("read-error").setText(ExceptionUtil.getStackTrace(ExceptionUtil.getRootCause(e)));
        }
        return new ConfigurationFile(namedResource.name, url, importedConfigurationFiles.toArray(new ConfigurationFile[importedConfigurationFiles.size()]), rootElement);
    }

    public ConfigurationFile[] toConfigurationFiles() {
        return this.configurationFiles;
    }

    private static class NamedResource {
        private final String name;
        private final Resource resource;

        public NamedResource(String name, Resource resource) {
            this.name = name;
            this.resource = resource;
        }
    }
}

