/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.configuration;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.service.form.impl.configuration.AbstractConfig;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldConfigImpl
extends AbstractConfig<FieldConfig>
implements FieldConfig {
    private GroupConfig groupConfig;
    private String name;
    private String key;
    private String displayName;
    private String[] defaultValues;
    private Boolean trimming;
    private String propertyName;
    private List<Validator> validators;
    private List<Validator> validatorList;

    @Override
    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public void setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtil.trimToNull(name);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = StringUtil.trimToNull(key);
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.getName() : this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = StringUtil.trimToNull(displayName);
    }

    @Override
    public boolean isTrimming() {
        if (this.trimming == null) {
            return this.groupConfig == null ? true : this.getGroupConfig().isTrimmingByDefault();
        }
        return this.trimming;
    }

    public void setTrimming(boolean trimming) {
        this.trimming = trimming;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName == null ? this.getName() : this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = StringUtil.trimToNull(propertyName);
    }

    @Override
    public String getDefaultValue() {
        if (!ArrayUtil.isEmptyArray(this.defaultValues)) {
            return this.defaultValues[0];
        }
        return null;
    }

    @Override
    public String[] getDefaultValues() {
        if (!ArrayUtil.isEmptyArray(this.defaultValues)) {
            return (String[])this.defaultValues.clone();
        }
        return BasicConstant.EMPTY_STRING_ARRAY;
    }

    public void setDefaultValues(String[] defaultValues) {
        if (!ArrayUtil.isEmptyArray(defaultValues)) {
            this.defaultValues = (String[])defaultValues.clone();
        }
    }

    @Override
    public List<Validator> getValidators() {
        if (this.validatorList == null) {
            return Collections.emptyList();
        }
        return this.validatorList;
    }

    public void setValidators(List<Validator> validators) {
        if (validators != null) {
            this.initValidatorList();
            this.validators.addAll(validators);
        }
    }

    private void initValidatorList() {
        this.validators = CollectionUtil.createArrayList();
        this.validatorList = Collections.unmodifiableList(this.validators);
    }

    void mergeWith(FieldConfigImpl src) {
        if (this.name == null) {
            this.setName(src.name);
        }
        if (this.displayName == null) {
            this.setDisplayName(src.displayName);
        }
        if (ArrayUtil.isEmptyArray(this.defaultValues)) {
            this.setDefaultValues(src.defaultValues);
        }
        if (this.trimming == null) {
            this.trimming = src.trimming;
        }
        if (this.propertyName == null) {
            this.setPropertyName(src.propertyName);
        }
        if (this.validators == null) {
            this.initValidatorList();
        }
        for (Validator validator : src.getValidators()) {
            this.validators.add(validator.clone());
        }
    }

    @Override
    public String toString() {
        String groupName = this.groupConfig == null ? null : this.groupConfig.getName();
        return "FieldConfig[group: " + groupName + ", name: " + this.getName() + ", validators: " + this.getValidators().size() + "]";
    }
}

