/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mappingrule.impl.rule;

import com.alibaba.citrus.service.mappingrule.impl.rule.FallbackIterator;
import com.alibaba.citrus.service.mappingrule.support.AbstractTemplateMappingRule;
import com.alibaba.citrus.service.mappingrule.support.AbstractTemplateMappingRuleDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class FallbackTemplateMappingRule
extends AbstractTemplateMappingRule {
    public static final String DEFAULT_NAME = "default";
    public static final boolean DEFAULT_MATCH_LAST_NAME = false;
    private boolean matchLastName;

    public void setMatchLastName(boolean matchLastName) {
        this.matchLastName = matchLastName;
    }

    protected void initMappingRule() throws Exception {
        Assert.assertNotNull(this.getTemplateService(), "templateService", new Object[0]);
        Assert.assertNotNull(this.getTemplatePrefix(), "templatePrefix", new Object[0]);
    }

    public String doMapping(String name) {
        FallbackTemplateIterator iter = new FallbackTemplateIterator(name, this.getTemplatePrefix(), this.matchLastName);
        String firstTemplateName = iter.getNext();
        while (iter.hasNext()) {
            String fullTemplateName = iter.next();
            if (!this.getTemplateService().exists(fullTemplateName)) continue;
            return fullTemplateName;
        }
        return firstTemplateName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractTemplateMappingRuleDefinitionParser<FallbackTemplateMappingRule> {
        @Override
        protected void doParseTemplateMappingRule(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "matchLastName");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FallbackTemplateIterator
    extends FallbackIterator {
        private String templatePrefix;
        private String firstExt = "";

        public FallbackTemplateIterator(String name, String templatePrefix, boolean matchLastName) {
            super(name, FallbackTemplateMappingRule.DEFAULT_NAME, null, matchLastName);
            int extIndex;
            String n;
            List<String> names = this.getNames();
            if (names != null && !names.isEmpty() && !StringUtil.isEmpty(n = names.get(names.size() - 1)) && (extIndex = n.lastIndexOf(".")) != -1) {
                this.firstExt = n.substring(extIndex + 1, n.length());
            }
            this.templatePrefix = StringUtil.trimToNull(templatePrefix);
            this.init();
        }

        @Override
        protected void invalidName(String name) {
            FallbackTemplateMappingRule.throwInvalidNameException(name);
        }

        @Override
        protected String normalizeLastName(String lastName) {
            return lastName;
        }

        @Override
        protected String generateFullName(List<String> names) {
            String n;
            int extIndex;
            String fullName = StringUtil.join(names, "/");
            if (this.templatePrefix != null) {
                fullName = this.templatePrefix + "/" + fullName;
            }
            if ((extIndex = (n = names.get(names.size() - 1)).lastIndexOf(".")) == -1 && !StringUtil.isEmpty(this.firstExt)) {
                fullName = fullName + "." + this.firstExt;
            }
            return fullName;
        }
    }
}

