/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.condition;

import com.alibaba.citrus.service.pipeline.PipelineStates;
import com.alibaba.citrus.service.pipeline.support.AbstractConditionDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.pipeline.condition.AbstractTurbineCondition;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class TargetExtensionCondition
extends AbstractTurbineCondition {
    private final Set<String> extensions = CollectionUtil.createHashSet();

    public void setExtension(String exts) {
        this.extensions.clear();
        if (exts == null) {
            this.extensions.add(null);
        } else {
            String[] extArray;
            for (String ext : extArray = StringUtil.split(exts, ", ")) {
                this.extensions.add(FileUtil.normalizeExtension(ext));
            }
        }
    }

    public boolean isSatisfied(PipelineStates states) {
        String ext = FileUtil.getExtension(this.getRunData().getTarget(), "null", true);
        if (this.extensions.contains(ext)) {
            this.log.debug("Target extension matched: {}", (Object)ext);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractConditionDefinitionParser<TargetExtensionCondition> {
        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "extension");
        }
    }
}

