/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Utils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareForTurbineValve
extends AbstractValve {
    @Autowired
    private HttpServletRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request, true);
        boolean contextSaved = false;
        try {
            pipelineContext.setAttribute("rundata", rundata);
            for (Map.Entry<String, Object> entry : Utils.getUtils().entrySet()) {
                pipelineContext.setAttribute(entry.getKey(), entry.getValue());
            }
            pipelineContext.invokeNext();
            TurbineUtil.cleanupTurbineRunData(this.request, !contextSaved);
        }
        catch (Throwable e) {
            try {
                TurbineUtil.saveTurbineRunDataContext(rundata);
                contextSaved = true;
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                TurbineUtil.cleanupTurbineRunData(this.request, !contextSaved);
            }
            catch (Throwable throwable) {
                TurbineUtil.cleanupTurbineRunData(this.request, !contextSaved);
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<PrepareForTurbineValve> {
    }
}

