/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.io;

import com.alibaba.citrus.util.io.ByteArray;
import com.alibaba.citrus.util.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        int bufferSize = 8192;
        byte[] buffer = new byte[bufferSize];
        try {
            int amount;
            while ((amount = in.read(buffer)) >= 0) {
                out.write(buffer, 0, amount);
            }
            out.flush();
        }
        finally {
            if (closeIn) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io(Reader in, Writer out, boolean closeIn, boolean closeOut) throws IOException {
        int bufferSize = 4096;
        char[] buffer = new char[bufferSize];
        try {
            int amount;
            while ((amount = in.read(buffer)) >= 0) {
                out.write(buffer, 0, amount);
            }
            out.flush();
        }
        finally {
            if (closeIn) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String readText(InputStream in, String charset, boolean closeIn) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return StreamUtil.readText(reader, closeIn);
    }

    public static String readText(Reader in, boolean closeIn) throws IOException {
        StringWriter out = new StringWriter();
        StreamUtil.io(in, out, closeIn, true);
        return out.toString();
    }

    public static ByteArray readBytes(InputStream in, boolean closeIn) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtil.io(in, out, closeIn, true);
        return out.toByteArray();
    }

    public static void writeText(CharSequence chars, OutputStream out, String charset, boolean closeOut) throws IOException {
        OutputStreamWriter writer = charset == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, charset);
        StreamUtil.writeText(chars, writer, closeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText(CharSequence chars, Writer out, boolean closeOut) throws IOException {
        try {
            out.write(chars.toString());
            out.flush();
        }
        finally {
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeBytes(byte[] bytes, OutputStream out, boolean closeOut) throws IOException {
        StreamUtil.writeBytes(new ByteArray(bytes), out, closeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(ByteArray bytes, OutputStream out, boolean closeOut) throws IOException {
        try {
            out.write(bytes.getRawBytes(), bytes.getOffset(), bytes.getLength());
            out.flush();
        }
        finally {
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

