/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl.visitor;

import com.alibaba.citrus.dev.handler.impl.ExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.AbstractFallbackVisitor;
import com.alibaba.citrus.service.uribroker.URIBrokerService;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrisVisitor
extends AbstractFallbackVisitor<ExplorerHandler.ExplorerVisitor> {
    private final URIBrokerService uris;
    private URIBroker uri;
    private boolean exposed;
    private String name;

    public UrisVisitor(RequestHandlerContext context, ExplorerHandler.ExplorerVisitor v, URIBrokerService uris) {
        super(context, v);
        this.uris = uris;
    }

    public void visitService(Template serviceNotAvailableTemplate, Template serviceTemplate) {
        if (this.uris == null) {
            serviceNotAvailableTemplate.accept(this);
        } else {
            serviceTemplate.accept(this);
        }
    }

    public void visitUri(Template uriTemplate) {
        final HashSet<String> exposedNames = CollectionUtil.createHashSet(this.uris.getExposedNames());
        ArrayList<String> names = CollectionUtil.createArrayList(this.uris.getNames());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int t2;
                int t1 = exposedNames.contains(o1) ? 0 : 1;
                int n = t2 = exposedNames.contains(o2) ? 0 : 1;
                if (t1 != t2) {
                    return t1 - t2;
                }
                return o1.compareTo(o2);
            }
        });
        for (String name : names) {
            this.uri = this.uris.getURIBroker(name);
            this.exposed = exposedNames.contains(name);
            this.name = name;
            uriTemplate.accept(this);
        }
    }

    public void visitUriName(Template exposedTemplate, Template hiddenTemplate) {
        if (this.exposed) {
            exposedTemplate.accept(this);
        } else {
            hiddenTemplate.accept(this);
        }
    }

    public void visitName() {
        ((PrintWriter)this.out()).print(this.name);
    }

    public void visitValueTypePackage() {
        ((PrintWriter)this.out()).print(this.uri.getClass().getPackage().getName() + ".");
    }

    public void visitValueTypeName() {
        ((PrintWriter)this.out()).print(ClassUtil.getSimpleClassName(this.uri.getClass(), false));
    }

    public void visitValue() {
        ((PrintWriter)this.out()).print(this.uri.toString());
    }

    public void visitHidden(Template hiddenTemplate) {
        if (!this.exposed) {
            hiddenTemplate.accept(this);
        }
    }
}

