/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.logconfig;

import com.alibaba.citrus.logconfig.LogConfigurator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConfiguratorListener
implements ServletContextListener {
    private static final String LOG_CONFIGURATION = "logConfiguration";
    private static final String LOG_SYSTEM = "logSystem";
    private static final String LOG_PREFIX = "log";
    private LogConfigurator[] logConfigurators;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        Map<String, String> params = this.getLogInitParams(servletContext);
        String[] logSystems = this.getLogSystems(params);
        for (LogConfigurator logConfigurator : this.logConfigurators = LogConfigurator.getConfigurators(logSystems)) {
            URL logConfigurationResource;
            String logSystem = logConfigurator.getLogSystem();
            String logConfiguration = this.getLogConfiguration(params, logSystem);
            servletContext.log(String.format("Initializing %s system", logSystem));
            try {
                logConfigurationResource = servletContext.getResource(logConfiguration);
            }
            catch (MalformedURLException e) {
                logConfigurationResource = null;
            }
            if (logConfigurationResource == null) {
                servletContext.log(String.format("Could not find %s configuration file \"%s\" in webapp context.  Using default configurations.", logSystem, logConfiguration));
                logConfigurator.configureDefault();
                continue;
            }
            Map<String, String> props = logConfigurator.getDefaultProperties();
            this.initProperties(props);
            props.putAll(params);
            logConfigurator.configure(logConfigurationResource, props);
        }
    }

    protected void initProperties(Map<String, String> props) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.logConfigurators != null && this.logConfigurators.length > 0) {
            ServletContext servletContext = event.getServletContext();
            servletContext.log("Shutting down log system");
            for (LogConfigurator logConfigurator : this.logConfigurators) {
                logConfigurator.shutdown();
            }
        }
    }

    private String getLogConfiguration(Map<String, String> params, String logSystem) {
        String logConfiguration = params.remove(LOG_CONFIGURATION);
        if (logConfiguration == null) {
            logConfiguration = "/WEB-INF/" + logSystem + ".xml";
        }
        return logConfiguration;
    }

    private String[] getLogSystems(Map<String, String> params) {
        String logSystem = params.remove(LOG_SYSTEM);
        if (logSystem == null) {
            return new String[0];
        }
        return logSystem.split("(,|\\s)+");
    }

    private Map<String, String> getLogInitParams(ServletContext servletContext) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration i = servletContext.getInitParameterNames();
        while (i.hasMoreElements()) {
            String value;
            String name = (String)i.nextElement();
            if (name == null || !name.startsWith(LOG_PREFIX) || (value = LogConfigurator.trimToNull(servletContext.getInitParameter(name))) == null) continue;
            params.put(name, value);
        }
        return params;
    }
}

