/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.builder.MailBuilderException;
import com.alibaba.citrus.service.mail.builder.content.AbstractContent;
import com.alibaba.citrus.service.mail.builder.content.TemplateContent;
import com.alibaba.citrus.service.mail.support.ResourceDataSource;
import com.alibaba.citrus.service.mail.util.MailUtil;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.SystemUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTemplateContent
extends TemplateContent
implements ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    private Map<String, String> inlineResourceMap = CollectionUtil.createHashMap();
    private Map<String, InlineResource> inlineResources = CollectionUtil.createHashMap();

    public HTMLTemplateContent() {
    }

    public HTMLTemplateContent(String templateName) {
        this.setTemplate(templateName);
    }

    public HTMLTemplateContent(String templateName, String contentType) {
        this.setTemplate(templateName);
        this.setContentType(contentType);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setInlineResources(Map<String, String> resourceMap) {
        if (resourceMap != null) {
            this.inlineResourceMap.clear();
            for (Map.Entry<String, String> entry : resourceMap.entrySet()) {
                this.addInlineResource(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addInlineResource(String id, String prefix) {
        id = Assert.assertNotNull(StringUtil.trimToNull(id), "The ID of inline resource was not specified", new Object[0]);
        prefix = Assert.assertNotNull(StringUtil.trimToNull(prefix), "The prefix of inline resource was not specified", new Object[0]);
        Assert.assertTrue(!this.inlineResourceMap.containsKey(id), "Duplicated ID \"%s\" of inline resource", id);
        this.inlineResourceMap.put(id, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Part mailPart) throws MessagingException {
        this.inlineResources.clear();
        String text = this.renderTemplate();
        try {
            if (this.inlineResources.isEmpty()) {
                this.renderHTMLContent(mailPart, text);
            } else {
                MimeMultipart multipartRelated = new MimeMultipart("related");
                MimeBodyPart bodyPart = new MimeBodyPart();
                this.renderHTMLContent((Part)bodyPart, text);
                multipartRelated.addBodyPart((BodyPart)bodyPart);
                HashSet<String> fileNames = CollectionUtil.createHashSet();
                for (InlineResource inlineResource : this.inlineResources.values()) {
                    this.renderInlineResource((Multipart)multipartRelated, inlineResource, fileNames);
                }
                mailPart.setContent((Multipart)multipartRelated);
            }
        }
        finally {
            this.inlineResources.clear();
        }
    }

    private void renderHTMLContent(Part mailPart, String text) throws MessagingException {
        String contentType = this.getContentType();
        ContentType contentTypeObject = MailUtil.getContentType(contentType, this.getMailBuilder().getCharacterEncoding());
        mailPart.setContent((Object)text, contentTypeObject.toString());
        mailPart.setHeader("Content-Transfer-Encoding", "8bit");
    }

    private void renderInlineResource(Multipart multipart, InlineResource inlineResource, Set<String> fileNames) throws MessagingException {
        Object ds;
        Assert.assertNotNull(this.resourceLoader, "no resourceLoader", new Object[0]);
        String resourceName = inlineResource.getResourceName();
        Resource resource = this.resourceLoader.getResource(resourceName);
        if (!resource.exists()) {
            throw new MailBuilderException("Could not find resource \"" + resourceName + "\"");
        }
        try {
            ds = new URLDataSource(resource.getURL());
        }
        catch (IOException e) {
            ds = new ResourceDataSource(resource);
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDataHandler(new DataHandler((DataSource)ds));
        bodyPart.setHeader("Content-ID", "<" + inlineResource.getContentId() + ">");
        bodyPart.setFileName(inlineResource.getUniqueFilename(fileNames));
        bodyPart.setDisposition("inline");
        multipart.addBodyPart((BodyPart)bodyPart);
    }

    @Override
    protected void populateTemplateContext(TemplateContext templateContext) {
        for (Map.Entry<String, String> entry : this.inlineResourceMap.entrySet()) {
            String key = entry.getKey();
            String prefix = entry.getValue();
            templateContext.put(key, new InlineResourceHelper(prefix));
        }
    }

    @Override
    protected void copyTo(AbstractContent copy) {
        super.copyTo(copy);
        HTMLTemplateContent copyContent = (HTMLTemplateContent)copy;
        copyContent.resourceLoader = this.resourceLoader;
        copyContent.inlineResourceMap.clear();
        copyContent.inlineResourceMap.putAll(this.inlineResourceMap);
        copyContent.inlineResources.clear();
    }

    @Override
    protected HTMLTemplateContent newInstance() {
        return new HTMLTemplateContent();
    }

    @Override
    protected String getDefaultContentType() {
        return "text/html";
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        super.toString(mb);
        mb.append("inlineResources", this.inlineResourceMap);
    }

    public class InlineResourceHelper {
        private String prefix;

        public InlineResourceHelper(String prefix) {
            this.prefix = FileUtil.normalizeAbsolutePath(prefix + "/");
        }

        public String getURI(String path) {
            String resourceName = FileUtil.normalizeAbsolutePath(this.prefix + path);
            InlineResource inlineResource = (InlineResource)HTMLTemplateContent.this.inlineResources.get(resourceName);
            if (inlineResource == null) {
                inlineResource = new InlineResource(resourceName);
                HTMLTemplateContent.this.inlineResources.put(resourceName, inlineResource);
            }
            return "cid:" + inlineResource.getContentId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InlineResource {
        private static MessageFormat formatter = new MessageFormat("{0,time,yyyyMMdd.HHmmss}.{1}@{2}");
        private static int count = 0;
        private static String hostname = SystemUtil.getHostInfo().getName();
        private String resourceName;
        private String contentId;
        private String filename;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InlineResource(String resourceName) {
            this.resourceName = resourceName;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                count = (count + 1) % 0x200000;
                this.contentId = formatter.format(new Object[]{new Date(), String.valueOf(count), hostname});
            }
            this.filename = InlineResource.getFileName(resourceName);
        }

        private static String getFileName(String name) {
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return name.substring(name.lastIndexOf("/") + 1);
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getContentId() {
            return this.contentId;
        }

        public String getUniqueFilename(Set<String> fileNames) {
            String name = this.filename;
            int dotIndex = this.filename.lastIndexOf(".");
            int i = 1;
            while (fileNames.contains(name)) {
                name = dotIndex >= 0 ? this.filename.substring(0, dotIndex) + i + this.filename.substring(dotIndex) : this.filename + i;
                ++i;
            }
            fileNames.add(name);
            return name;
        }
    }
}

