/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pull.support;

import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.StaticFunctionDelegatorBuilder;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixinTool
implements ToolFactory,
ResourceLoaderAware {
    private ClassLoader classLoader;
    private Class<?>[] mixinClasses;
    private MethodInfo[] mixinMethods;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.classLoader = resourceLoader.getClassLoader();
    }

    public void setMixinClasses(Class<?>[] mixinClasses) {
        this.mixinClasses = mixinClasses;
    }

    public void setMixinMethods(MethodInfo[] mixinMethods) {
        this.mixinMethods = mixinMethods;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Object createTool() throws Exception {
        StaticFunctionDelegatorBuilder builder = new StaticFunctionDelegatorBuilder(this.classLoader);
        if (this.mixinClasses != null) {
            for (Class<?> mixinClass : this.mixinClasses) {
                builder.addClass(mixinClass);
            }
        }
        if (this.mixinMethods != null) {
            for (MethodInfo methodInfo : this.mixinMethods) {
                for (Method method : methodInfo.containingClass.getMethods()) {
                    String methodName = method.getName();
                    if (!methodName.equals(methodInfo.methodName)) continue;
                    builder.addMethod(method, methodInfo.rename);
                }
            }
        }
        return builder.toObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MethodInfo {
        private Class<?> containingClass;
        private String methodName;
        private String rename;

        public MethodInfo(Class<?> containingClass, String methodName, String rename) {
            this.containingClass = containingClass;
            this.methodName = methodName;
            this.rename = rename;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<MixinTool> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            List<Object> classes = SpringExtUtil.createManagedList(element, parserContext);
            List<Object> methods = SpringExtUtil.createManagedList(element, parserContext);
            for (Element classElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("class")))) {
                String className = Assert.assertNotNull(StringUtil.trimToNull(classElement.getAttribute("name")), "mixin class name", new Object[0]);
                List<Element> methodElements = DomUtil.subElements(classElement, DomUtil.and(DomUtil.sameNs(classElement), DomUtil.name("method")));
                if (methodElements.isEmpty()) {
                    classes.add(className);
                    continue;
                }
                for (Element methodElement : methodElements) {
                    BeanDefinitionBuilder methodBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInfo.class);
                    methodBuilder.addConstructorArgValue((Object)className);
                    methodBuilder.addConstructorArgValue((Object)Assert.assertNotNull(StringUtil.trimToNull(methodElement.getAttribute("name")), "mixin method name", new Object[0]));
                    methodBuilder.addConstructorArgValue((Object)StringUtil.trimToNull(methodElement.getAttribute("renameTo")));
                    methods.add(methodBuilder.getBeanDefinition());
                }
            }
            builder.addPropertyValue("mixinClasses", classes);
            builder.addPropertyValue("mixinMethods", methods);
        }
    }
}

