/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.parser.impl;

import com.alibaba.citrus.service.configuration.support.PropertyEditorRegistrarsSupport;
import com.alibaba.citrus.service.requestcontext.parser.impl.ParserRequestContextFactoryImpl;
import com.alibaba.citrus.service.upload.UploadService;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRequestContextFactoryDefinitionParser
extends AbstractSingleBeanDefinitionParser<ParserRequestContextFactoryImpl>
implements ContributionAware {
    private ConfigurationPoint parserFiltersConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.parserFiltersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/parser/filters", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("propertyEditorRegistrars", PropertyEditorRegistrarsSupport.parseRegistrars(element, parserContext, builder));
        Element filtersElement = DomUtil.theOnlySubElement(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("filters")));
        if (filtersElement != null) {
            this.parseFilters(filtersElement, parserContext, builder);
        }
        SpringExtUtil.attributesToProperties(element, builder, "converterQuiet", "caseFolding", "autoUpload", "unescapeParameters", "useServletEngineParser", "useBodyEncodingForURI", "URIEncoding", "trimming", "htmlFieldSuffix");
        String uploadServiceName = StringUtil.trimToNull(element.getAttribute("uploadServiceRef"));
        if (uploadServiceName != null) {
            builder.addPropertyReference("uploadService", uploadServiceName);
        } else {
            SpringExtUtil.addPropertyRef(builder, "uploadService", "uploadService", UploadService.class, false);
        }
    }

    private void parseFilters(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> filters = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            filters.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.parserFiltersConfigurationPoint, parserContext, builder));
        }
        builder.addPropertyValue("parameterParserFilters", filters);
    }
}

