/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.idgen.random.impl;

import com.alibaba.citrus.service.requestcontext.session.SessionIDGenerator;
import com.alibaba.citrus.springext.support.BeanSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class RandomIDGenerator
extends BeanSupport
implements SessionIDGenerator {
    private Integer length;
    private Random rnd;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    protected void init() {
        this.length = ObjectUtil.defaultIfNull(this.length, SESSION_ID_LENGTH_DEFAULT);
        try {
            this.rnd = new SecureRandom();
        }
        catch (Throwable e) {
            this.rnd = new Random();
        }
    }

    public String generateSessionID() {
        this.assertInitialized();
        byte[] bytes = new byte[(this.length + 3) / 4 * 3];
        this.rnd.nextBytes(bytes);
        byte[] b64Encoded = Base64.encodeBase64((byte[])bytes);
        StringBuilder buf = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            char ch = (char)b64Encoded[i];
            switch (ch) {
                case '/': {
                    ch = '$';
                    break;
                }
                case '+': {
                    ch = '-';
                    break;
                }
                case '=': {
                    Assert.unreachableCode();
                }
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public String toString() {
        return new ToStringBuilder().append("RandomSessionIDGenerator[length=").append(this.length).append("]").toString();
    }
}

