/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringParser {
    private final String charset;
    private final StringBuilder queryStringBuffer;
    private String equalSign = "=";
    private String andSign = "&";

    public QueryStringParser() {
        this(null, null);
    }

    public QueryStringParser(String charset) {
        this(charset, null);
    }

    public QueryStringParser(String charset, String defaultCharset) {
        defaultCharset = ObjectUtil.defaultIfNull(StringUtil.trimToNull(defaultCharset), LocaleUtil.getContext().getCharset().name());
        this.charset = ObjectUtil.defaultIfNull(StringUtil.trimToNull(charset), defaultCharset);
        this.queryStringBuffer = new StringBuilder();
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public String getEqualSign() {
        return this.equalSign;
    }

    public String getAndSign() {
        return this.andSign;
    }

    public QueryStringParser setEqualSign(String equalSign) {
        this.equalSign = ObjectUtil.defaultIfNull(equalSign, "=");
        return this;
    }

    public QueryStringParser setAndSign(String andSign) {
        this.andSign = ObjectUtil.defaultIfNull(andSign, "&");
        return null;
    }

    public QueryStringParser append(String key, String value) {
        try {
            key = StringEscapeUtil.escapeURL(ObjectUtil.defaultIfNull(key, ""), this.charset);
            value = StringEscapeUtil.escapeURL(ObjectUtil.defaultIfNull(value, ""), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("invalid charset: " + this.charset, e);
        }
        if (this.queryStringBuffer.length() > 0) {
            this.queryStringBuffer.append(this.andSign);
        }
        this.queryStringBuffer.append(key).append(this.equalSign).append(value);
        return this;
    }

    public QueryStringParser append(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.append(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String toQueryString() {
        String queryString = this.queryStringBuffer.toString();
        this.queryStringBuffer.setLength(0);
        return queryString.length() == 0 ? null : queryString;
    }

    public void parse(String queryString) {
        if ((queryString = StringUtil.trimToNull(queryString)) == null) {
            return;
        }
        int startIndex = 0;
        int ampIndex = queryString.indexOf(this.andSign);
        while (ampIndex >= 0) {
            this.addKeyValue(queryString.substring(startIndex, ampIndex));
            startIndex = ampIndex + 1;
            ampIndex = queryString.indexOf(this.andSign, startIndex);
        }
        this.addKeyValue(queryString.substring(startIndex));
    }

    protected void add(String key, String value) {
        Assert.unsupportedOperation("You should extend class " + this.getClass().getSimpleName() + " and override method add(String, String)", new Object[0]);
    }

    private void addKeyValue(String keyValue) {
        String value;
        String key;
        int index = keyValue.indexOf(this.equalSign);
        if (index < 0) {
            key = keyValue;
            value = null;
        } else {
            key = keyValue.substring(0, index).trim();
            value = keyValue.substring(index + 1).trim();
        }
        if (!StringUtil.isEmpty(key)) {
            key = this.decode(key);
            value = this.decode(value);
            this.add(key, ObjectUtil.defaultIfNull(value, ""));
        }
    }

    private String decode(String str) {
        try {
            return StringEscapeUtil.unescapeURL(str, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }
}

