/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.support;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ByteArrayResource
implements Resource {
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public ByteArrayResource(byte[] bytes) {
        this(Assert.assertNotNull(bytes, "bytes", new Object[0]), 0, bytes.length);
    }

    public ByteArrayResource(byte[] bytes, int offset, int length) {
        this.bytes = Assert.assertNotNull(bytes, "bytes", new Object[0]);
        if (offset < 0 || offset + length > bytes.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = offset;
        this.length = length;
    }

    public URL getURL() {
        return null;
    }

    public File getFile() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes, this.offset, this.length);
    }

    public boolean exists() {
        return this.bytes != null;
    }

    public long lastModified() {
        return 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + ByteArrayResource.hashCode(this.bytes, this.offset, this.length);
        return result;
    }

    private static int hashCode(byte[] bytes, int offset, int length) {
        int result = 1;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            result = 31 * result + bytes[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayResource other = (ByteArrayResource)obj;
        if (this.length != other.length) {
            return false;
        }
        int i = this.offset;
        int j = other.offset;
        int end = this.offset + this.length;
        while (i < end) {
            if (this.bytes[i] != other.bytes[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.appendArray(this.bytes, this.offset, 128);
        return buf.toString();
    }
}

