/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.service.velocity.VelocityConfiguration;
import com.alibaba.citrus.service.velocity.VelocityPlugin;
import com.alibaba.citrus.service.velocity.impl.CloneableEventCartridge;
import com.alibaba.citrus.service.velocity.impl.CustomizedUberspectImpl;
import com.alibaba.citrus.service.velocity.impl.PreloadedResourceLoader;
import com.alibaba.citrus.service.velocity.impl.Slf4jLogChute;
import com.alibaba.citrus.service.velocity.impl.SpringResourceLoaderAdapter;
import com.alibaba.citrus.service.velocity.support.RenderableHandler;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.event.EventHandler;
import org.slf4j.Logger;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityConfigurationImpl
implements VelocityConfiguration {
    private final Logger log;
    private final ExtendedProperties properties = new ExtendedProperties();
    private final Map<String, Resource> preloadedResources = CollectionUtil.createHashMap();
    private final CloneableEventCartridge eventCartridge = new CloneableEventCartridge();
    private Object[] plugins;
    private ResourceLoader loader;
    private boolean productionMode = true;
    private String path;
    private boolean cacheEnabled = true;
    private int modificationCheckInterval = 2;
    private boolean strictReference = true;
    private String charset;
    private String[] macros;

    public VelocityConfigurationImpl(Logger log) {
        this.log = Assert.assertNotNull(log, "log", new Object[0]);
    }

    @Override
    public ExtendedProperties getProperties() {
        return this.properties;
    }

    public CloneableEventCartridge getEventCartridge() {
        return this.eventCartridge;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.loader;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean isProductionMode() {
        return this.productionMode;
    }

    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    public void setPath(String path) {
        this.path = StringUtil.trimToNull(path);
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setModificationCheckInterval(int modificationCheckInterval) {
        this.modificationCheckInterval = modificationCheckInterval;
    }

    public void setStrictReference(boolean strictReference) {
        this.strictReference = strictReference;
    }

    public void setTemplateEncoding(String charset) {
        this.charset = StringUtil.trimToNull(charset);
    }

    public void setGlobalMacros(String[] macros) {
        this.macros = macros;
    }

    public void setPlugins(Object[] plugins) {
        this.plugins = plugins;
    }

    public void setAdvancedProperties(Map<String, Object> configuration) {
        this.properties.clear();
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            this.properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void init() throws Exception {
        Assert.assertNotNull(this.loader, "resourceLoader", new Object[0]);
        this.removeReservedProperties();
        this.initPlugins();
        this.initLogger();
        this.initMacros();
        this.initResourceLoader();
        this.initEventHandlers();
        this.initMiscs();
    }

    private void addHandler(EventHandler handler) {
        Assert.assertTrue(this.eventCartridge.addEventHandler(handler), "Unknown event handler type: %s", handler.getClass());
    }

    private void removeReservedProperties() {
        HashSet<String> keysToRemove = CollectionUtil.createHashSet();
        keysToRemove.add("resource.loader");
        Iterator i = this.properties.getKeys();
        while (i.hasNext()) {
            Object key2 = i.next();
            if (!(key2 instanceof String) || !((String)key2).contains("resource.loader")) continue;
            keysToRemove.add((String)key2);
        }
        keysToRemove.add("runtime.log");
        keysToRemove.add("runtime.log.logsystem");
        keysToRemove.add("runtime.log.logsystem.class");
        keysToRemove.add("velocimacro.library");
        i = this.properties.getKeys();
        while (i.hasNext()) {
            Object key = i.next();
            if (!(key instanceof String) || !((String)key).startsWith("eventhandler.") || !((String)key).endsWith(".class")) continue;
            keysToRemove.add((String)key);
        }
        keysToRemove.add("input.encoding");
        keysToRemove.add("velocimacro.library.autoreload");
        keysToRemove.add("runtime.references.strict");
        for (Object key : keysToRemove) {
            if (!this.properties.containsKey(key)) continue;
            this.log.warn("Removed reserved property: {} = {}", key, this.properties.get(key));
            this.properties.clearProperty(key);
        }
    }

    private void initPlugins() throws Exception {
        if (this.plugins != null) {
            for (Object plugin : this.plugins) {
                if (!(plugin instanceof VelocityPlugin)) continue;
                ((VelocityPlugin)plugin).init(this);
            }
        }
    }

    private void initResourceLoader() {
        this.path = ObjectUtil.defaultIfNull(this.path, "/templates");
        if (this.productionMode) {
            this.cacheEnabled = true;
        }
        this.properties.setProperty("resource.loader", (Object)"spring");
        String prefix = "spring.resource.loader.";
        this.properties.setProperty(prefix + "description", (Object)"Spring Resource Loader Adapter");
        this.properties.setProperty(prefix + "class", (Object)SpringResourceLoaderAdapter.class.getName());
        this.properties.setProperty(prefix + "path", (Object)this.path);
        this.properties.setProperty(prefix + "cache", (Object)String.valueOf(this.cacheEnabled));
        this.properties.setProperty(prefix + "modificationCheckInterval", (Object)String.valueOf(this.modificationCheckInterval));
        prefix = "preloaded.resource.loader.";
        this.properties.setProperty(prefix + "description", (Object)"Preloaded Resource Loader");
        this.properties.setProperty(prefix + "class", (Object)PreloadedResourceLoader.class.getName());
        this.properties.setProperty(prefix + "cache", (Object)String.valueOf(this.cacheEnabled));
        this.properties.setProperty(prefix + "modificationCheckInterval", (Object)String.valueOf(this.modificationCheckInterval));
        this.properties.setProperty(prefix + "resources", this.preloadedResources);
        if (!this.preloadedResources.isEmpty()) {
            this.properties.addProperty("resource.loader", (Object)"preloaded");
        }
    }

    private void initLogger() {
        this.properties.setProperty("runtime.log.logsystem", (Object)new Slf4jLogChute(this.log));
    }

    private void initMacros() throws Exception {
        Object resolver = this.loader instanceof ResourcePatternResolver ? (ResourcePatternResolver)this.loader : new PathMatchingResourcePatternResolver(this.loader);
        if (this.macros != null) {
            for (String macro : this.macros) {
                this.resolveMacro((ResourcePatternResolver)resolver, macro);
            }
        }
        this.resolveMacro((ResourcePatternResolver)resolver, "VM_global_library.vm");
        if (this.plugins != null) {
            for (Object plugin : this.plugins) {
                if (!(plugin instanceof VelocityPlugin)) continue;
                this.addMacroResources(null, ((VelocityPlugin)plugin).getMacros());
            }
        }
        if (!this.properties.containsKey((Object)"velocimacro.library")) {
            this.properties.setProperty("velocimacro.library", (Object)"");
        }
    }

    private void resolveMacro(ResourcePatternResolver resolver, String macro) {
        Resource[] resources;
        String path = FileUtil.normalizeAbsolutePath(this.path + "/");
        String pattern = FileUtil.normalizeAbsolutePath(path + macro);
        try {
            resources = resolver.getResources(pattern);
        }
        catch (IOException e) {
            resources = null;
        }
        this.addMacroResources(path, resources);
    }

    private void addMacroResources(String path, Resource[] resources) {
        if (resources != null) {
            HashSet macros = CollectionUtil.createHashSet(this.properties.getVector("velocimacro.library"));
            for (Resource resource : resources) {
                String resourceName;
                if (!resource.exists()) continue;
                String templateName = null;
                if (path != null && resource instanceof ContextResource && (resourceName = ((ContextResource)resource).getPathWithinContext()).startsWith(path)) {
                    templateName = resourceName.substring(path.length());
                }
                if (templateName == null) {
                    templateName = this.getTemplateNameOfPreloadedResource(resource);
                }
                if (macros.contains(templateName)) continue;
                this.properties.addProperty("velocimacro.library", (Object)templateName);
                macros.add(templateName);
            }
        }
    }

    private String getTemplateNameOfPreloadedResource(Resource resource) {
        URL url;
        try {
            url = resource.getURL();
        }
        catch (IOException e) {
            url = null;
        }
        String templateNameBase = url != null ? "globalVMs/" + StringUtils.getFilename((String)url.getPath()) : "globalVMs/globalVM.vm";
        String templateName = templateNameBase;
        int i = 1;
        while (this.preloadedResources.containsKey(templateName) && !resource.equals(this.preloadedResources.get(templateName))) {
            templateName = templateNameBase + i;
            ++i;
        }
        this.preloadedResources.put(templateName, resource);
        return templateName;
    }

    private void initEventHandlers() {
        boolean hasRenderableHandler = false;
        if (!ArrayUtil.isEmptyArray(this.plugins)) {
            for (Object plugin : this.plugins) {
                if (!(plugin instanceof RenderableHandler)) continue;
                hasRenderableHandler = true;
                break;
            }
        }
        if (!hasRenderableHandler) {
            this.addHandler((EventHandler)new RenderableHandler());
        }
        if (!ArrayUtil.isEmptyArray(this.plugins)) {
            for (Object plugin : this.plugins) {
                if (!(plugin instanceof EventHandler)) continue;
                this.addHandler((EventHandler)plugin);
            }
        }
    }

    private void initMiscs() {
        if (this.charset == null) {
            this.charset = "UTF-8";
        }
        this.setDefaultProperty("resource.manager.logwhenfound", "false");
        this.setDefaultProperty("input.encoding", this.charset);
        this.setDefaultProperty("output.encoding", "UTF-8");
        this.setDefaultProperty("parser.pool.size", "50");
        this.setDefaultProperty("runtime.introspector.uberspect", CustomizedUberspectImpl.class.getName());
        this.setDefaultProperty("velocimacro.arguments.strict", "true");
        this.setDefaultProperty("velocimacro.permissions.allow.inline.local.scope", "true");
        this.setDefaultProperty("directive.set.null.allowed", "true");
        if (this.productionMode) {
            this.properties.setProperty("velocimacro.library.autoreload", (Object)"false");
        } else {
            this.properties.setProperty("velocimacro.library.autoreload", (Object)"true");
        }
        this.properties.setProperty("runtime.references.strict", (Object)String.valueOf(this.strictReference));
    }

    private void setDefaultProperty(String key, Object value) {
        if (!this.properties.containsKey((Object)key)) {
            this.properties.setProperty(key, value);
        }
    }

    public String toString() {
        return new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true).appendAll((Map<?, ?>)this.properties).toString();
    }
}

