/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.util;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.ProxyTargetFactory;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringExtUtil {
    private static final Logger log = LoggerFactory.getLogger(SpringExtUtil.class);
    private static final DefaultInterceptor defaultInterceptor = new DefaultInterceptor();
    private static final ProxiedFilter proxiedFilter = new ProxiedFilter();

    public static <T> T getBeanOfType(BeanFactory beanFactory, Class<T> type) {
        if (beanFactory == null || !(beanFactory instanceof ListableBeanFactory)) {
            return null;
        }
        ListableBeanFactory listable = (ListableBeanFactory)beanFactory;
        Map beans = listable.getBeansOfType(type);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        return (T)beans.values().iterator().next();
    }

    public static <T> T autowireAndInitialize(T existingBean, ApplicationContext context, int autowireMode, String beanName) {
        context.getAutowireCapableBeanFactory().autowireBeanProperties(existingBean, autowireMode, false);
        context.getAutowireCapableBeanFactory().initializeBean(existingBean, beanName);
        return existingBean;
    }

    public static ConfigurationPoint getSiblingConfigurationPoint(String configurationPointName, Contribution contrib) {
        Assert.assertNotNull(contrib, "contribution", new Object[0]);
        return SpringExtUtil.getSiblingConfigurationPoint(configurationPointName, contrib.getConfigurationPoint());
    }

    public static ConfigurationPoint getSiblingConfigurationPoint(String configurationPointName, ConfigurationPoint cp) {
        Assert.assertNotNull(configurationPointName, "configurationPointName", new Object[0]);
        Assert.assertNotNull(cp, "configurationPoint", new Object[0]);
        ConfigurationPoint siblingCp = cp.getConfigurationPoints().getConfigurationPointByName(configurationPointName);
        Assert.assertNotNull(siblingCp, "could not find configuration point of name: %s", configurationPointName);
        return siblingCp;
    }

    public static List<Object> createManagedList(Element element, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.getReaderContext().extractSource((Object)element));
        return list;
    }

    public static Map<Object, Object> createManagedMap(Element element, ParserContext parserContext) {
        ManagedMap map = new ManagedMap();
        map.setSource(parserContext.getReaderContext().extractSource((Object)element));
        return map;
    }

    public static Set<Object> createManagedSet(Element element, ParserContext parserContext) {
        ManagedSet set = new ManagedSet();
        set.setSource(parserContext.getReaderContext().extractSource((Object)element));
        return set;
    }

    public static void subElementsToProperties(Element element, BeanDefinitionBuilder builder) {
        SpringExtUtil.subElementsToProperties(element, null, builder, null);
    }

    public static void subElementsToProperties(Element element, BeanDefinitionBuilder builder, DomUtil.ElementSelector selector) {
        SpringExtUtil.subElementsToProperties(element, null, builder, selector);
    }

    public static void subElementsToProperties(Element element, String propertyPrefix, BeanDefinitionBuilder builder, DomUtil.ElementSelector selector) {
        for (Element subElement : DomUtil.subElements(element, selector)) {
            SpringExtUtil.elementToProperty(subElement, propertyPrefix, builder);
        }
    }

    public static void elementToProperty(Element element, BeanDefinitionBuilder builder) {
        SpringExtUtil.elementToProperty(element, null, builder);
    }

    public static void elementToProperty(Element element, String propertyPrefix, BeanDefinitionBuilder builder) {
        String propName = element.getLocalName();
        if (!StringUtil.isEmpty(propertyPrefix)) {
            propName = propertyPrefix + propName;
        }
        builder.addPropertyValue(propName, (Object)StringUtil.trimToNull(element.getTextContent()));
    }

    public static void attributesToProperties(Element element, BeanDefinitionBuilder builder, String ... attrNames) {
        SpringExtUtil.attributesToProperties(element, null, builder, attrNames);
    }

    public static void attributesToProperties(Element element, String propertyPrefix, BeanDefinitionBuilder builder, String ... attrNames) {
        NamedNodeMap attrs = element.getAttributes();
        HashSet attrNameSet = ArrayUtil.isEmptyArray(attrNames) ? null : CollectionUtil.createHashSet(attrNames);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attrNameSet != null && !attrNameSet.contains(attr.getNodeName())) continue;
            SpringExtUtil.attributeToProperty(attr, propertyPrefix, builder);
        }
    }

    public static void attributeToProperty(Attr attr, String propertyPrefix, BeanDefinitionBuilder builder) {
        String propName = attr.getNodeName();
        if (!StringUtil.isEmpty(propertyPrefix)) {
            propName = propertyPrefix + propName;
        }
        builder.addPropertyValue(propName, (Object)StringUtil.trimToNull(attr.getNodeValue()));
    }

    public static void parseBeanDefinitionAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        parserContext.getDelegate().parseBeanDefinitionAttributes(element, null, null, builder.getRawBeanDefinition());
    }

    public static BeanDefinitionHolder parseConfigurationPointBean(Element element, ConfigurationPoint cp, ParserContext parserContext, BeanDefinitionBuilder containingBeanBuilder) {
        Assert.assertNotNull(cp, "configurationPoint", new Object[0]);
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        boolean isInnerBean = containingBeanBuilder != null;
        AbstractBeanDefinition containingBean = isInnerBean ? containingBeanBuilder.getRawBeanDefinition() : null;
        DomUtil.ElementSelector customSelector = DomUtil.ns(cp.getNamespaceUri());
        if (customSelector.accept(element)) {
            AbstractBeanDefinition bean = (AbstractBeanDefinition)delegate.parseCustomElement(element, (BeanDefinition)containingBean);
            String beanName = StringUtil.trimToNull(element.getAttribute("id"));
            if (beanName == null) {
                beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)bean, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)isInnerBean);
            }
            return new BeanDefinitionHolder((BeanDefinition)bean, beanName);
        }
        return null;
    }

    public static Object parseBean(Element element, ParserContext parserContext, BeanDefinitionBuilder containingBeanBuilder) {
        return SpringExtUtil.parseBean(element, parserContext, (BeanDefinition)(containingBeanBuilder == null ? null : containingBeanBuilder.getRawBeanDefinition()));
    }

    public static Object parseBean(Element element, ParserContext parserContext, BeanDefinition containingBean) {
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        String refName = StringUtil.trimToNull(element.getAttribute("ref"));
        if (refName != null) {
            NamedBeanReference ref = new NamedBeanReference(refName, element.getAttribute("id"));
            ref.setSource(parserContext.extractSource((Object)element));
            return ref;
        }
        BeanDefinitionHolder beanHolder = delegate.parseBeanDefinitionElement(element, containingBean);
        if (beanHolder != null) {
            beanHolder = delegate.decorateBeanDefinitionIfRequired(element, beanHolder, containingBean);
        }
        return beanHolder;
    }

    public static String getBeanName(Object bean) {
        if (bean instanceof BeanDefinitionHolder) {
            return ((BeanDefinitionHolder)bean).getBeanName();
        }
        if (bean instanceof NamedBeanReference) {
            return ((NamedBeanReference)((Object)bean)).getId();
        }
        if (bean instanceof BeanReference) {
            return ((BeanReference)bean).getBeanName();
        }
        return null;
    }

    public static String generateBeanName(String baseName, BeanDefinitionRegistry registry) {
        return SpringExtUtil.generateBeanName(baseName, registry, null, false);
    }

    public static String generateBeanName(String baseName, BeanDefinitionRegistry registry, BeanDefinition definition, boolean isInnerBean) {
        String name;
        baseName = Assert.assertNotNull(StringUtil.trimToNull(baseName), "baseName", new Object[0]);
        if (isInnerBean) {
            name = baseName + "#" + ObjectUtils.getIdentityHexString((Object)definition);
        } else {
            name = baseName;
            int i = 0;
            while (registry.containsBeanDefinition(name)) {
                name = baseName + "#" + i;
                ++i;
            }
        }
        return name;
    }

    public static void addConstructorArg(BeanDefinitionBuilder builder, boolean required, Class<?> argType) {
        builder.addConstructorArgValue((Object)SpringExtUtil.createConstructorArg(builder.getRawBeanDefinition().getBeanClass(), required, argType));
    }

    public static void addConstructorArg(BeanDefinitionBuilder builder, boolean required, int argIndex, Class<?> ... argTypes) {
        builder.addConstructorArgValue((Object)SpringExtUtil.createConstructorArg(builder.getRawBeanDefinition().getBeanClass(), required, argIndex, argTypes));
    }

    public static BeanDefinition createConstructorArg(Class<?> beanType, boolean required, Class<?> argType) {
        return SpringExtUtil.createConstructorArg(beanType, required, 0, argType);
    }

    public static BeanDefinition createConstructorArg(Class<?> beanType, boolean required, int argIndex, Class<?> ... argTypes) {
        Constructor<?> constructor;
        Assert.assertNotNull(beanType, "beanType", new Object[0]);
        argTypes = ObjectUtil.defaultIfNull(argTypes, BasicConstant.EMPTY_CLASS_ARRAY);
        if (ArrayUtil.isEmptyArray(argTypes)) {
            Constructor<?>[] constructors = beanType.getConstructors();
            Assert.assertTrue(constructors.length == 1, "%d constructors found, please specify argTypes", constructors.length);
            constructor = constructors[0];
            argTypes = constructor.getParameterTypes();
        } else {
            try {
                constructor = beanType.getConstructor(argTypes);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find constructor", e);
            }
        }
        Assert.assertTrue(argIndex >= 0 && argIndex < argTypes.length, "argIndex is out of bound: %d", argIndex);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ConstructorArg.class);
        builder.addConstructorArgValue(constructor);
        builder.addConstructorArgValue(argTypes[argIndex]);
        builder.addConstructorArgValue((Object)argIndex);
        builder.addConstructorArgValue((Object)required);
        return builder.getBeanDefinition();
    }

    public static void addPropertyRef(BeanDefinitionBuilder builder, String propertyName, String beanName, Class<?> beanType, boolean required) {
        if (required) {
            builder.addPropertyReference(propertyName, beanName);
        } else {
            builder.addPropertyValue(propertyName, (Object)SpringExtUtil.createOptionalPropertyRef(beanName, beanType));
        }
    }

    public static BeanDefinition createOptionalPropertyRef(String beanName, Class<?> beanType) {
        beanName = Assert.assertNotNull(StringUtil.trimToNull(beanName), "beanName", new Object[0]);
        Assert.assertNotNull(beanType, "beanType", new Object[0]);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(OptionalPropertyRef.class);
        builder.addConstructorArgValue((Object)beanName);
        builder.addConstructorArgValue(beanType);
        return builder.getBeanDefinition();
    }

    public static <T> T createProxy(Class<T> intfs, ProxyTargetFactory factory) {
        return SpringExtUtil.createProxy(intfs, null, factory);
    }

    public static <T> T createProxy(Class<T> intfs, ClassLoader classLoader, ProxyTargetFactory factory) {
        Assert.assertNotNull(intfs, "no interface", new Object[0]);
        Assert.assertNotNull(factory, "no ProxyTargetFactory", new Object[0]);
        try {
            intfs.getMethod("getObject", new Class[0]);
            throw new IllegalArgumentException("Method name conflict: interface " + intfs.getName() + ".getObject()");
        }
        catch (NoSuchMethodException ignored) {
            Enhancer generator = new Enhancer();
            generator.setClassLoader(classLoader);
            generator.setSuperclass(AbstractProxy.class);
            generator.setInterfaces(new Class[]{intfs});
            generator.setCallbacks(new Callback[]{defaultInterceptor, new ProxiedInterceptor(factory)});
            generator.setCallbackFilter((CallbackFilter)proxiedFilter);
            generator.setNamingPolicy((NamingPolicy)new ProxiedNamingPolicy(intfs));
            return intfs.cast(generator.create(new Class[]{Class.class, ProxyTargetFactory.class}, new Object[]{intfs, factory}));
        }
    }

    public static <T> T assertProxy(T object) {
        if (object != null) {
            Assert.assertTrue(object instanceof ProxyTargetFactory, "expects a proxy delegating to a real object, but got an object of type %s", object.getClass().getName());
        }
        return object;
    }

    public static <T> T getProxyTarget(T object) {
        if (object instanceof ProxyTargetFactory) {
            try {
                return (T)((ProxyTargetFactory)object).getObject();
            }
            catch (Exception e) {
                log.warn("Could not get proxied object from ProxyTargetFactory: {} {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                return null;
            }
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProxiedNamingPolicy
    extends DefaultNamingPolicy {
        private final Class<?> intfs;

        private ProxiedNamingPolicy(Class<?> intfs) {
            this.intfs = intfs;
        }

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            if (AbstractProxy.class.getName().equals(prefix)) {
                prefix = this.intfs.getName();
            }
            return super.getClassName(prefix, source, key, names);
        }
    }

    private static final class ProxiedFilter
    implements CallbackFilter {
        private ProxiedFilter() {
        }

        public int accept(Method method) {
            if (ReflectionUtils.isEqualsMethod((Method)method) || ReflectionUtils.isHashCodeMethod((Method)method) || ReflectionUtils.isToStringMethod((Method)method) || this.isProxyTargetFactoryMethod(method)) {
                return 0;
            }
            return 1;
        }

        private boolean isProxyTargetFactoryMethod(Method method) {
            return method != null && method.getName().equals("getObject") && method.getParameterTypes().length == 0;
        }
    }

    private static final class ProxiedInterceptor
    implements MethodInterceptor {
        private final ProxyTargetFactory factory;

        private ProxiedInterceptor(ProxyTargetFactory factory) {
            this.factory = factory;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return proxy.invoke(this.factory.getObject(), args);
        }
    }

    private static final class DefaultInterceptor
    implements MethodInterceptor {
        private DefaultInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return proxy.invokeSuper(obj, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbstractProxy
    implements ProxyTargetFactory {
        private final Class<?> intfs;
        private final ProxyTargetFactory factory;

        public AbstractProxy(Class<?> intfs, ProxyTargetFactory factory) {
            this.intfs = Assert.assertNotNull(intfs);
            this.factory = Assert.assertNotNull(factory, "ProxyTargetFactory", new Object[0]);
        }

        @Override
        public Object getObject() {
            return this.factory.getObject();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.factory == null ? 0 : this.factory.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractProxy other = (AbstractProxy)obj;
            return !(this.factory == null ? other.factory != null : !this.factory.equals(other.factory));
        }

        public String toString() {
            try {
                return this.factory.getObject().toString();
            }
            catch (Exception e) {
                return String.format("%s[%s: %s]", this.intfs.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            }
        }
    }

    private static class NamedBeanReference
    extends RuntimeBeanReference {
        private final String id;

        public NamedBeanReference(String beanName, String id) {
            this(beanName, id, false);
        }

        public NamedBeanReference(String beanName, String id, boolean toParent) {
            super(beanName, toParent);
            this.id = StringUtil.trimToNull(id);
        }

        public String getId() {
            return this.id == null ? this.getBeanName() : this.id;
        }

        public String toString() {
            return '<' + (this.id == null ? "" : this.id + "=") + this.getBeanName() + '>';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptionalPropertyRef
    implements FactoryBean,
    BeanFactoryAware {
        private final String beanName;
        private final Class<?> beanType;
        private BeanFactory context;

        public OptionalPropertyRef(String beanName, Class<?> beanType) {
            this.beanName = beanName;
            this.beanType = beanType;
        }

        public void setBeanFactory(BeanFactory context) throws BeansException {
            this.context = context;
        }

        public Class<?> getObjectType() {
            return this.beanType;
        }

        public boolean isSingleton() {
            return false;
        }

        public Object getObject() {
            Object object = null;
            if (this.context != null) {
                try {
                    object = this.context.getBean(this.beanName);
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorArg
    implements FactoryBean,
    BeanFactoryAware {
        private final Constructor<?> constructor;
        private final Class<?> argType;
        private final int argIndex;
        private final boolean required;
        private ConfigurableListableBeanFactory context;

        public ConstructorArg(Constructor<?> constructor, Class<?> argType, int argIndex, boolean required) {
            this.constructor = constructor;
            this.argType = argType;
            this.argIndex = argIndex;
            this.required = required;
        }

        public void setBeanFactory(BeanFactory context) throws BeansException {
            Object factory = context instanceof ApplicationContext ? ((ApplicationContext)context).getAutowireCapableBeanFactory() : context;
            if (factory instanceof ConfigurableListableBeanFactory) {
                this.context = (ConfigurableListableBeanFactory)factory;
            }
        }

        public Class<?> getObjectType() {
            return this.argType;
        }

        public boolean isSingleton() {
            return false;
        }

        public Object getObject() {
            if (this.required && this.context == null) {
                throw new IllegalArgumentException("could not get object of " + this.argType.getName() + ": no Application Context");
            }
            Object object = null;
            if (this.context != null) {
                DependencyDescriptor dd = new DependencyDescriptor(new MethodParameter(this.constructor, this.argIndex), this.required);
                object = this.context.resolveDependency(dd, null);
            }
            return object;
        }
    }
}

