/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.auth.impl;

import com.alibaba.citrus.turbine.auth.impl.AuthActionPattern;
import com.alibaba.citrus.turbine.auth.impl.AuthPattern;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthGrant {
    public static final String MATCH_EVERYTHING = "*";
    public static final String ANONYMOUS_USER = "anonymous";
    private String[] users;
    private String[] roles;
    private Set<AuthPattern> allowedActions = CollectionUtil.createLinkedHashSet();
    private Set<AuthPattern> deniedActions = CollectionUtil.createLinkedHashSet();

    public String[] getUsers() {
        return this.users;
    }

    public void setUsers(String[] users) {
        this.users = this.trim(users, MATCH_EVERYTHING, ANONYMOUS_USER);
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = this.trim(roles, MATCH_EVERYTHING);
    }

    private String[] trim(String[] array, String ... canonicals) {
        LinkedList<String> list = CollectionUtil.createLinkedList();
        if (!ArrayUtil.isEmptyArray(array)) {
            for (String item : array) {
                int i;
                if ((item = StringUtil.trimToNull(item)) == null) continue;
                if (canonicals != null && (i = ArrayUtil.arrayIndexOf((Object[])canonicals, item)) >= 0) {
                    item = canonicals[i];
                }
                list.add(item);
            }
        }
        if (!list.isEmpty()) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public boolean isUserMatched(String userName) {
        if (!ArrayUtil.isEmptyArray(this.users)) {
            for (String grantUser : this.users) {
                if (!(grantUser == ANONYMOUS_USER ? userName == null : (grantUser == MATCH_EVERYTHING ? userName != null : grantUser.equals(userName)))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areRolesMatched(String[] roleNames) {
        if (!ArrayUtil.isEmptyArray(this.roles)) {
            for (String grantRole : this.roles) {
                if (grantRole == MATCH_EVERYTHING) {
                    boolean emptyRoleNames = true;
                    if (!ArrayUtil.isEmptyArray(roleNames)) {
                        for (String roleName : roleNames) {
                            if (roleName == null) continue;
                            emptyRoleNames = false;
                            break;
                        }
                    }
                    if (emptyRoleNames) continue;
                    return true;
                }
                if (!ArrayUtil.arrayContains((Object[])roleNames, grantRole)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<AuthPattern> getAllowedActions() {
        return this.allowedActions;
    }

    public boolean isActionAllowed(String action) {
        return this.matches(this.allowedActions, action);
    }

    public void setAllow(String ... allow) {
        this.setActions(this.allowedActions, allow);
    }

    public Set<AuthPattern> getDeniedActions() {
        return this.deniedActions;
    }

    public boolean isActionDenied(String action) {
        return this.matches(this.deniedActions, action);
    }

    public void setDeny(String ... deny) {
        this.setActions(this.deniedActions, deny);
    }

    private void setActions(Set<AuthPattern> actionSet, String[] actions) {
        actionSet.clear();
        for (String action : ObjectUtil.defaultIfNull(actions, BasicConstant.EMPTY_STRING_ARRAY)) {
            actionSet.add(new AuthActionPattern(action));
        }
    }

    private boolean matches(Set<AuthPattern> actionSet, String action) {
        for (AuthPattern pattern : actionSet) {
            if (!pattern.matcher(action).find()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        if (!ArrayUtil.isEmptyArray(this.users)) {
            mb.append("users", new ToStringBuilder.CollectionBuilder().appendAll(this.users).setOneLine(true));
        }
        if (!ArrayUtil.isEmptyArray(this.roles)) {
            mb.append("roles", new ToStringBuilder.CollectionBuilder().appendAll(this.roles).setOneLine(true));
        }
        if (!this.allowedActions.isEmpty()) {
            mb.append("allow", new ToStringBuilder.CollectionBuilder().appendAll(this.allowedActions).setOneLine(true));
        }
        if (!this.deniedActions.isEmpty()) {
            mb.append("deny", new ToStringBuilder.CollectionBuilder().appendAll(this.deniedActions).setOneLine(true));
        }
        return new ToStringBuilder().append("Grant").append(mb).toString();
    }
}

