/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.collection;

import com.alibaba.citrus.util.collection.DefaultMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry<K, V>[] table;
    protected transient int size;
    protected int threshold;
    protected final float loadFactor;
    protected volatile transient int modCount;
    private transient Set<K> keySet = null;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private transient Collection<V> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public DefaultHashMap() {
        this(16, 0.75f);
    }

    public DefaultHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DefaultHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.onInit();
    }

    public DefaultHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        return entry != null;
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            Object oldValue = entry.getValue();
            entry.setValue(value);
            entry.onAccess();
            return oldValue;
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.resize(this.table.length * 2);
        }
        this.addEntry(key, value);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> entry = this.removeEntryForKey(key);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public void clear() {
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V>[] tab;
        Entry<K, V>[] arr$ = tab = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry<K, V> element;
            Entry<K, V> entry = element = arr$[i$];
            while (entry != null) {
                if (DefaultHashMap.eq(value, entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        int numBuckets = is.readInt();
        this.table = new Entry[numBuckets];
        this.onInit();
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = is.readObject();
            Object value = is.readObject();
            this.putForCreate(key, value);
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeInt(this.table.length);
        os.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            os.writeObject(entry.getKey());
            os.writeObject(entry.getValue());
        }
    }

    @Override
    public Object clone() {
        DefaultHashMap result = null;
        try {
            result = (DefaultHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.onInit();
        result.putAllForCreate(this);
        return result;
    }

    protected void onInit() {
    }

    protected Entry<K, V> getEntry(Object key) {
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        Entry<K, V> entry = this.table[i];
        while (entry != null) {
            if (entry.hash == hash && DefaultHashMap.eq(key, entry.getKey())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void addEntry(K key, V value) {
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        this.table[i] = new Entry<K, V>(hash, key, value, this.table[i]);
        ++this.size;
    }

    private void putForCreate(K key, V value) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            entry.setValue(value);
        } else {
            this.addEntry(key, value);
        }
    }

    private void putAllForCreate(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    protected Entry<K, V> removeEntryForKey(Object key) {
        Entry<K, V> prev;
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        Entry<K, V> entry = prev = this.table[i];
        while (entry != null) {
            Entry next = entry.next;
            if (entry.hash == hash && DefaultHashMap.eq(key, entry.getKey())) {
                ++this.modCount;
                --this.size;
                if (prev == entry) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                entry.onRemove();
                return entry;
            }
            prev = entry;
            entry = next;
        }
        return entry;
    }

    protected Entry<K, V> removeEntry(Object o) {
        Entry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.onRemove();
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    protected Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    protected Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    protected Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    protected static int hash(Object obj) {
        int h = obj == null ? 0 : obj.hashCode();
        return h - (h << 7);
    }

    protected static boolean eq(Object x, Object y) {
        return x == null ? y == null : x == y || x.equals(y);
    }

    protected static int indexFor(int hash, int length) {
        return hash & length - 1;
    }

    protected void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    protected void transfer(Entry<K, V>[] newTable) {
        Entry<K, V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<K, V> entry = src[j];
            if (entry == null) continue;
            src[j] = null;
            do {
                next = entry.next;
                int i = DefaultHashMap.indexFor(entry.hash, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
            } while ((entry = next) != null);
        }
    }

    protected int getCapacity() {
        return this.table.length;
    }

    protected float getLoadFactor() {
        return this.loadFactor;
    }

    protected int getThreshold() {
        return this.threshold;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return DefaultHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Entry candidate = DefaultHashMap.this.getEntry(entry.getKey());
            return DefaultHashMap.eq(candidate, entry);
        }

        @Override
        public boolean remove(Object o) {
            return DefaultHashMap.this.removeEntry(o) != null;
        }

        @Override
        public int size() {
            return DefaultHashMap.this.size;
        }

        @Override
        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return DefaultHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return DefaultHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return DefaultHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return DefaultHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return DefaultHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return DefaultHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return DefaultHashMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        private Entry<K, V> current;
        private Entry<K, V> next;
        private int expectedModCount;
        private int index;

        protected HashIterator() {
            this.expectedModCount = DefaultHashMap.this.modCount;
            Entry<K, V>[] t = DefaultHashMap.this.table;
            int i = t.length;
            Entry n = null;
            if (DefaultHashMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            Object k = this.current.getKey();
            this.current = null;
            DefaultHashMap.this.removeEntryForKey(k);
            this.expectedModCount = DefaultHashMap.this.modCount;
        }

        protected Entry<K, V> nextEntry() {
            this.checkForComodification();
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry n = entry.next;
            Entry<K, V>[] t = DefaultHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = entry;
            return this.current;
        }

        private void checkForComodification() {
            if (DefaultHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<K, V>
    extends DefaultMapEntry<K, V> {
        protected final int hash;
        protected Entry<K, V> next;

        protected Entry(int h, K k, V v, Entry<K, V> n) {
            super(k, v);
            this.next = n;
            this.hash = h;
        }

        protected void onAccess() {
        }

        protected void onRemove() {
        }
    }
}

