/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.i18n;

import com.alibaba.citrus.util.ClassLoaderUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleInfo;
import com.alibaba.citrus.util.io.StreamUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleUtil {
    private static final LocaleInfo systemLocaleInfo;
    private static LocaleInfo defaultLocalInfo;
    private static final ThreadLocal<LocaleInfo> contextLocaleInfoHolder;
    private static Logger log;
    private static Notifier[] notifiers;

    public static boolean isLocaleSupported(Locale locale) {
        return locale != null && AvailableLocalesLoader.locales.AVAILABLE_LANGUAGES.contains(locale.getLanguage()) && AvailableLocalesLoader.locales.AVAILABLE_COUNTRIES.contains(locale.getCountry());
    }

    public static boolean isCharsetSupported(String charset) {
        return charset != null && Charset.isSupported(charset);
    }

    public static Locale parseLocale(String localeString) {
        if ((localeString = StringUtil.trimToNull(localeString)) == null) {
            return null;
        }
        String language = "";
        String country = "";
        String variant = "";
        int start = 0;
        int index = localeString.indexOf("_");
        if (index >= 0) {
            language = localeString.substring(start, index).trim();
            start = index + 1;
            if ((index = localeString.indexOf("_", start)) >= 0) {
                country = localeString.substring(start, index).trim();
                variant = localeString.substring(index + 1).trim();
            } else {
                country = localeString.substring(start).trim();
            }
        } else {
            language = localeString.substring(start).trim();
        }
        return new Locale(language, country, variant);
    }

    public static String getCanonicalCharset(String charset) {
        return Charset.forName(charset).name();
    }

    public static List<String> calculateBundleNames(String baseName, Locale locale) {
        return LocaleUtil.calculateBundleNames(baseName, locale, false);
    }

    public static List<String> calculateBundleNames(String baseName, Locale locale, boolean noext) {
        int extIndex;
        baseName = StringUtil.trimToEmpty(baseName);
        if (locale == null) {
            locale = new Locale("");
        }
        String ext = "";
        int extLength = 0;
        if (!noext && (extIndex = baseName.lastIndexOf(".")) != -1) {
            ext = baseName.substring(extIndex, baseName.length());
            extLength = ext.length();
            baseName = baseName.substring(0, extIndex);
            if (extLength == 1) {
                ext = "";
                extLength = 0;
            }
        }
        LinkedList<String> result = CollectionUtil.createLinkedList();
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        StringBuilder buffer = new StringBuilder(baseName);
        buffer.append(ext);
        result.addFirst(buffer.toString());
        buffer.setLength(buffer.length() - extLength);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        if (buffer.length() > 0) {
            buffer.append('_');
        }
        buffer.append(language);
        if (languageLength > 0) {
            buffer.append(ext);
            result.addFirst(buffer.toString());
            buffer.setLength(buffer.length() - extLength);
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        buffer.append('_').append(country);
        if (countryLength > 0) {
            buffer.append(ext);
            result.addFirst(buffer.toString());
            buffer.setLength(buffer.length() - extLength);
        }
        if (variantLength == 0) {
            return result;
        }
        buffer.append('_').append(variant);
        buffer.append(ext);
        result.addFirst(buffer.toString());
        buffer.setLength(buffer.length() - extLength);
        return result;
    }

    public static LocaleInfo getSystem() {
        return systemLocaleInfo;
    }

    public static LocaleInfo getDefault() {
        return defaultLocalInfo == null ? systemLocaleInfo : defaultLocalInfo;
    }

    public static LocaleInfo setDefault(Locale locale) {
        LocaleInfo old = LocaleUtil.getDefault();
        LocaleUtil.setDefaultAndNotify(new LocaleInfo(locale, null, systemLocaleInfo));
        return old;
    }

    public static LocaleInfo setDefault(Locale locale, String charset) throws UnsupportedCharsetException {
        LocaleInfo old = LocaleUtil.getDefault();
        LocaleUtil.setDefaultAndNotify(new LocaleInfo(locale, charset, systemLocaleInfo));
        return old;
    }

    public static LocaleInfo setDefault(LocaleInfo localeInfo) throws UnsupportedCharsetException {
        if (localeInfo == null) {
            return LocaleUtil.setDefault(null, null);
        }
        LocaleInfo old = LocaleUtil.getDefault();
        LocaleUtil.setDefaultAndNotify(localeInfo);
        return old;
    }

    private static void setDefaultAndNotify(LocaleInfo localeInfo) throws UnsupportedCharsetException {
        defaultLocalInfo = localeInfo.assertCharsetSupported();
        for (Notifier notifier : notifiers) {
            notifier.defaultChanged(localeInfo);
        }
    }

    public static void resetDefault() {
        defaultLocalInfo = systemLocaleInfo;
        for (Notifier notifier : notifiers) {
            notifier.defaultReset();
        }
    }

    public static LocaleInfo getContext() {
        LocaleInfo contextLocaleInfo = contextLocaleInfoHolder.get();
        return contextLocaleInfo == null ? LocaleUtil.getDefault() : contextLocaleInfo;
    }

    public static LocaleInfo setContext(Locale locale) {
        LocaleInfo old = LocaleUtil.getContext();
        LocaleUtil.setContextAndNotify(new LocaleInfo(locale, null, defaultLocalInfo));
        return old;
    }

    public static LocaleInfo setContext(Locale locale, String charset) throws UnsupportedCharsetException {
        LocaleInfo old = LocaleUtil.getContext();
        LocaleUtil.setContextAndNotify(new LocaleInfo(locale, charset, defaultLocalInfo));
        return old;
    }

    public static LocaleInfo setContext(LocaleInfo localeInfo) throws UnsupportedCharsetException {
        if (localeInfo == null) {
            return LocaleUtil.setContext(null, null);
        }
        LocaleInfo old = LocaleUtil.getContext();
        LocaleUtil.setContextAndNotify(localeInfo);
        return old;
    }

    private static void setContextAndNotify(LocaleInfo localeInfo) throws UnsupportedCharsetException {
        contextLocaleInfoHolder.set(localeInfo.assertCharsetSupported());
        for (Notifier notifier : notifiers) {
            notifier.contextChanged(localeInfo);
        }
    }

    public static void resetContext() {
        contextLocaleInfoHolder.remove();
        for (Notifier notifier : notifiers) {
            notifier.contextReset();
        }
    }

    private static Notifier[] getNotifiers() {
        try {
            URL[] files = ClassLoaderUtil.getResources("META-INF/services/localeNotifiers", ClassLoaderUtil.class);
            LinkedList<Notifier> list = CollectionUtil.createLinkedList();
            for (URL file : files) {
                for (String className : StringUtil.split(StreamUtil.readText(file.openStream(), "UTF-8", true), "\r\n ")) {
                    list.add((Notifier)Notifier.class.cast(ClassLoaderUtil.newInstance(className, ClassLoaderUtil.class)));
                }
            }
            return list.toArray(new Notifier[list.size()]);
        }
        catch (Exception e) {
            log.warn("Failure in LocaleUtil.getNotifiers()", (Throwable)e);
            return new Notifier[0];
        }
    }

    static {
        defaultLocalInfo = systemLocaleInfo = new LocaleInfo();
        contextLocaleInfoHolder = new ThreadLocal();
        log = LoggerFactory.getLogger(LocaleUtil.class);
        notifiers = LocaleUtil.getNotifiers();
    }

    private static class AvailableLocales {
        private final Set<String> AVAILABLE_LANGUAGES = CollectionUtil.createHashSet();
        private final Set<String> AVAILABLE_COUNTRIES = CollectionUtil.createHashSet();

        private AvailableLocales() {
            Locale[] availableLocales;
            for (Locale locale : availableLocales = Locale.getAvailableLocales()) {
                this.AVAILABLE_LANGUAGES.add(locale.getLanguage());
                this.AVAILABLE_COUNTRIES.add(locale.getCountry());
            }
        }
    }

    private static class AvailableLocalesLoader {
        private static final AvailableLocales locales = new AvailableLocales();

        private AvailableLocalesLoader() {
        }
    }

    public static interface Notifier
    extends EventListener {
        public void defaultChanged(LocaleInfo var1);

        public void defaultReset();

        public void contextChanged(LocaleInfo var1);

        public void contextReset();
    }
}

