/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.internal.DynamicClassBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceImplementorBuilder
extends DynamicClassBuilder {
    private static final String OVERRIDER_SET_PROXY_OBJECT_METHOD_NAME = "setThisProxy";
    private Class<?> superclass;
    private List<Class<?>> interfaces = CollectionUtil.createLinkedList();
    private Object baseObject;
    private Object overrider;
    private String overriderSetProxyObjectMethodName;
    private Map<Signature, FastMethod> overridedMethods;
    private FastMethod overriderSetProxyObjectMethod;
    private Enhancer generator;

    public InterfaceImplementorBuilder() {
        this(null);
    }

    public InterfaceImplementorBuilder(ClassLoader cl) {
        super(cl);
    }

    public InterfaceImplementorBuilder setSuperclass(Class<?> superclass) {
        this.superclass = superclass;
        return this;
    }

    public InterfaceImplementorBuilder addInterface(Class<?> ... interfaceClasses) {
        if (interfaceClasses != null) {
            for (Class<?> interfaceClass : interfaceClasses) {
                this.interfaces.add(interfaceClass);
            }
        }
        return this;
    }

    public InterfaceImplementorBuilder setBaseObject(Object baseObject) {
        this.baseObject = baseObject;
        return this;
    }

    public InterfaceImplementorBuilder setOverrider(Object overrider) {
        this.overrider = overrider;
        return this;
    }

    public InterfaceImplementorBuilder setOverriderSetProxyObjectMethodName(String methodName) {
        this.overriderSetProxyObjectMethodName = methodName;
        return this;
    }

    private void init() {
        if (this.superclass == null) {
            this.superclass = Object.class;
        }
        Assert.assertTrue(!this.interfaces.isEmpty(), "no interface specified", new Object[0]);
        if (this.baseObject != null) {
            for (Class<?> interfaceClass : this.interfaces) {
                Assert.assertTrue(interfaceClass.isInstance(this.baseObject), "%s is not of %s", this.baseObject, interfaceClass);
            }
        }
        this.overrider = Assert.assertNotNull(this.overrider, "no overrider specified", new Object[0]);
        this.overridedMethods = CollectionUtil.createHashMap();
        Map<String, List<Method>> overriderMethods = this.getMethodMap(this.overrider.getClass());
        FastClass overriderFastClass = FastClass.create((ClassLoader)this.getClassLoader(), this.overrider.getClass());
        for (Class<?> interfaceClass : this.interfaces) {
            for (Method interfaceMethod : interfaceClass.getMethods()) {
                Signature sig = this.getSignature(interfaceMethod, null);
                Method overriderMethod = this.getCompatibleOverrideMethod(overriderMethods, interfaceMethod);
                if (overriderMethod == null) continue;
                this.log.trace("Overrided method: {}", (Object)ClassUtil.getSimpleMethodSignature(interfaceMethod, true));
                this.overridedMethods.put(sig, overriderFastClass.getMethod(overriderMethod));
            }
        }
        Method overriderSetProxyObjectMethod = this.getOverriderSetProxyObjectMethod(overriderMethods);
        if (overriderSetProxyObjectMethod != null) {
            this.overriderSetProxyObjectMethod = overriderFastClass.getMethod(overriderSetProxyObjectMethod);
        }
    }

    private Map<String, List<Method>> getMethodMap(Class<?> clazz) {
        HashMap<String, List<Method>> methods = CollectionUtil.createHashMap();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            LinkedList methodList = (LinkedList)methods.get(methodName);
            if (methodList == null) {
                methodList = CollectionUtil.createLinkedList();
                methods.put(methodName, methodList);
            }
            methodList.add(method);
        }
        return methods;
    }

    private Method getCompatibleOverrideMethod(Map<String, List<Method>> overriderMethods, Method interfaceMethod) {
        List<Method> methods = overriderMethods.get(interfaceMethod.getName());
        if (methods != null) {
            for (Method overriderMethod : methods) {
                if (overriderMethod.getParameterTypes().length != interfaceMethod.getParameterTypes().length) continue;
                boolean compatible = true;
                for (int i = 0; i < overriderMethod.getParameterTypes().length; ++i) {
                    if (overriderMethod.getParameterTypes()[i].isAssignableFrom(interfaceMethod.getParameterTypes()[i])) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                return overriderMethod;
            }
        }
        return null;
    }

    private Method getOverriderSetProxyObjectMethod(Map<String, List<Method>> overriderMethods) {
        List<Method> methods;
        String methodName = this.overriderSetProxyObjectMethodName;
        if (methodName == null) {
            methodName = OVERRIDER_SET_PROXY_OBJECT_METHOD_NAME;
        }
        if ((methods = overriderMethods.get(methodName)) != null) {
            for (Method overriderMethod : methods) {
                if (overriderMethod.getParameterTypes().length != 1) continue;
                boolean compatible = true;
                Class<?> paramType = overriderMethod.getParameterTypes()[0];
                for (Class<?> interfaceClass : this.interfaces) {
                    if (paramType.isAssignableFrom(interfaceClass)) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                return overriderMethod;
            }
        }
        return null;
    }

    public Object toObject() {
        if (this.generator == null) {
            this.init();
            this.generator = new Enhancer();
            this.generator.setClassLoader(this.getClassLoader());
            this.generator.setSuperclass(this.superclass);
            this.generator.setInterfaces(this.interfaces.toArray(new Class[this.interfaces.size()]));
            this.generator.setCallbacks(new Callback[]{new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    return proxy.invokeSuper(obj, args);
                }
            }, new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (InterfaceImplementorBuilder.this.baseObject == null || !method.getDeclaringClass().isAssignableFrom(InterfaceImplementorBuilder.this.baseObject.getClass())) {
                        if (method.getDeclaringClass().isAssignableFrom(InterfaceImplementorBuilder.this.superclass)) {
                            return proxy.invokeSuper(obj, args);
                        }
                        throw new UnsupportedOperationException(ClassUtil.getSimpleMethodSignature(method, true));
                    }
                    return proxy.invoke(InterfaceImplementorBuilder.this.baseObject, args);
                }
            }, new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    FastMethod overridedMethod = (FastMethod)InterfaceImplementorBuilder.this.overridedMethods.get(InterfaceImplementorBuilder.this.getSignature(method, null));
                    try {
                        return overridedMethod.invoke(InterfaceImplementorBuilder.this.overrider, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            }});
            this.generator.setCallbackFilter(new CallbackFilter(){

                public int accept(Method method) {
                    if (InterfaceImplementorBuilder.this.isEqualsMethod(method) || InterfaceImplementorBuilder.this.isHashCodeMethod(method) || InterfaceImplementorBuilder.this.isToStringMethod(method)) {
                        return 0;
                    }
                    if (InterfaceImplementorBuilder.this.overridedMethods.containsKey(InterfaceImplementorBuilder.this.getSignature(method, null))) {
                        return 2;
                    }
                    return 1;
                }
            });
        }
        Object proxy = this.generator.create();
        if (this.overriderSetProxyObjectMethod != null) {
            try {
                this.overriderSetProxyObjectMethod.invoke(this.overrider, new Object[]{proxy});
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to call " + ClassUtil.getSimpleMethodSignature(this.overriderSetProxyObjectMethod.getJavaMethod(), true), e.getTargetException());
            }
        }
        return proxy;
    }
}

