/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.context;

import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.regex.PathNameWildcardCompiler;
import com.alibaba.citrus.webx.WebxComponent;
import com.alibaba.citrus.webx.WebxComponents;
import com.alibaba.citrus.webx.WebxConstant;
import com.alibaba.citrus.webx.WebxController;
import com.alibaba.citrus.webx.WebxRootController;
import com.alibaba.citrus.webx.config.WebxConfiguration;
import com.alibaba.citrus.webx.config.impl.WebxConfigurationImpl;
import com.alibaba.citrus.webx.context.WebxComponentContext;
import com.alibaba.citrus.webx.context.WebxComponentsContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SourceFilteringListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebxComponentsLoader
extends ContextLoader {
    private static final Logger log = LoggerFactory.getLogger(WebxComponentsLoader.class);
    private String webxConfigurationName;
    private ServletContext servletContext;
    private WebApplicationContext componentsContext;
    private WebxComponentsImpl components;

    public String getWebxConfigurationName() {
        return this.webxConfigurationName == null ? "webxConfiguration" : this.webxConfigurationName;
    }

    public void setWebxConfigurationName(String webxConfigurationName) {
        this.webxConfigurationName = StringUtil.trimToNull(webxConfigurationName);
    }

    public String getComponentContextAttributeName(String componentName) {
        return WebxConstant.COMPONENT_CONTEXT_PREFIX + componentName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public WebxComponents getWebxComponents() {
        return this.components;
    }

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws IllegalStateException, BeansException {
        this.servletContext = servletContext;
        this.init();
        return super.initWebApplicationContext(servletContext);
    }

    protected void init() {
        this.setWebxConfigurationName(this.servletContext.getInitParameter("webxConfigurationName"));
    }

    protected final Class<?> determineContextClass(ServletContext servletContext) throws ApplicationContextException {
        String contextClassName = servletContext.getInitParameter("contextClass");
        if (contextClassName != null) {
            try {
                return ClassUtils.forName((String)contextClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)ex);
            }
        }
        return this.getDefaultContextClass();
    }

    protected Class<? extends WebxComponentsContext> getDefaultContextClass() {
        return WebxComponentsContext.class;
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext componentsContext) {
        this.componentsContext = componentsContext;
        if (componentsContext instanceof WebxComponentsContext) {
            ((WebxComponentsContext)componentsContext).setLoader(this);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(WebxComponentsCreator.class);
        builder.addConstructorArgValue((Object)this);
        AbstractBeanDefinition componentsCreator = builder.getBeanDefinition();
        componentsCreator.setAutowireCandidate(false);
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        String name = SpringExtUtil.generateBeanName(WebxComponentsCreator.class.getName(), registry);
        registry.registerBeanDefinition(name, (BeanDefinition)componentsCreator);
    }

    public void finishRefresh() {
        this.components.getWebxRootController().onFinishedProcessContext();
        for (WebxComponent component : this.components) {
            this.logInBothServletAndLoggingSystem("Initializing Spring sub WebApplicationContext: " + component.getName());
            WebxComponentContext wcc = (WebxComponentContext)component.getApplicationContext();
            WebxController controller = component.getWebxController();
            wcc.refresh();
            controller.onFinishedProcessContext();
        }
        this.logInBothServletAndLoggingSystem("WebxComponents: initialization completed");
    }

    private void logInBothServletAndLoggingSystem(String msg) {
        this.servletContext.log(msg);
        log.info(msg);
    }

    private WebxComponentsImpl createComponents(WebxConfiguration parentConfiguration, ConfigurableListableBeanFactory beanFactory) {
        WebxConfiguration.ComponentsConfig componentsConfig = this.getComponentsConfig(parentConfiguration);
        Map<String, String> componentNamesAndLocations = this.findComponents(componentsConfig, this.getServletContext());
        Map<String, WebxConfiguration.ComponentConfig> specifiedComponents = componentsConfig.getComponents();
        TreeSet<String> componentNames = CollectionUtil.createTreeSet();
        componentNames.addAll(componentNamesAndLocations.keySet());
        componentNames.addAll(specifiedComponents.keySet());
        WebxRootController rootController = componentsConfig.getRootController();
        if (rootController == null) {
            rootController = (WebxRootController)BeanUtils.instantiateClass(componentsConfig.getRootControllerClass());
        }
        WebxComponentsImpl components = new WebxComponentsImpl(this.componentsContext, componentsConfig.getDefaultComponent(), rootController, parentConfiguration);
        beanFactory.registerResolvableDependency(WebxComponents.class, (Object)components);
        for (String componentName : componentNames) {
            WebxConfiguration.ComponentConfig componentConfig = specifiedComponents.get(componentName);
            String componentPath = null;
            WebxController controller = null;
            if (componentConfig != null) {
                componentPath = componentConfig.getPath();
                controller = componentConfig.getController();
            }
            if (controller == null) {
                controller = (WebxController)BeanUtils.instantiateClass(componentsConfig.getDefaultControllerClass());
            }
            WebxComponentImpl component = new WebxComponentImpl(components, componentName, componentPath, componentName.equals(componentsConfig.getDefaultComponent()), controller, this.getWebxConfigurationName());
            components.addComponent(component);
            this.prepareComponent(component, componentNamesAndLocations.get(componentName));
        }
        return components;
    }

    private void prepareComponent(WebxComponentImpl component, String componentLocation) {
        String componentName = component.getName();
        WebxComponentContext wcc = new WebxComponentContext(component);
        wcc.setServletContext(this.getServletContext());
        wcc.setNamespace(componentName);
        wcc.addApplicationListener((ApplicationListener)new SourceFilteringListener((Object)wcc, (ApplicationListener)component));
        if (componentLocation != null) {
            wcc.setConfigLocation(componentLocation);
        }
        component.setApplicationContext((WebApplicationContext)wcc);
        String attrName = this.getComponentContextAttributeName(componentName);
        this.getServletContext().setAttribute(attrName, (Object)wcc);
        log.debug("Published WebApplicationContext of component {} as ServletContext attribute with name [{}]", (Object)componentName, (Object)attrName);
    }

    private Map<String, String> findComponents(WebxConfiguration.ComponentsConfig componentsConfig, ServletContext servletContext) {
        String locationPattern = componentsConfig.getComponentConfigurationLocationPattern();
        String[] prefixAndPattern = this.checkComponentConfigurationLocationPattern(locationPattern);
        String prefix = prefixAndPattern[0];
        String pathPattern = prefixAndPattern[1];
        TreeMap<String, String> componentNamesAndLocations = CollectionUtil.createTreeMap();
        if (componentsConfig.isAutoDiscoverComponents().booleanValue()) {
            try {
                ServletContextResourcePatternResolver resolver = new ServletContextResourcePatternResolver(servletContext);
                Resource[] componentConfigurations = resolver.getResources(locationPattern);
                Pattern pattern = PathNameWildcardCompiler.compilePathName(pathPattern);
                if (componentConfigurations != null) {
                    for (Resource resource : componentConfigurations) {
                        String path = resource.getURL().getPath();
                        Matcher matcher = pattern.matcher(path);
                        Assert.assertTrue(matcher.find(), "unknown component configuration file: %s", path);
                        String componentName = StringUtil.trimToNull(matcher.group(1));
                        if (componentName == null) continue;
                        componentNamesAndLocations.put(componentName, prefix + pathPattern.replace("*", componentName));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return componentNamesAndLocations;
    }

    private String[] checkComponentConfigurationLocationPattern(String componentConfigurationLocationPattern) {
        if (componentConfigurationLocationPattern != null) {
            int index;
            boolean classpath = componentConfigurationLocationPattern.startsWith("classpath*:");
            String pathPattern = componentConfigurationLocationPattern;
            if (classpath) {
                pathPattern = componentConfigurationLocationPattern.substring("classpath*:".length()).trim();
            }
            if ((index = pathPattern.indexOf("*")) >= 0 && (index = pathPattern.indexOf("*", index + 1)) < 0) {
                if (pathPattern.startsWith("/")) {
                    pathPattern = pathPattern.substring(1);
                }
                return new String[]{classpath ? "classpath:" : "", pathPattern};
            }
        }
        throw new IllegalArgumentException("Invalid componentConfigurationLocationPattern: " + componentConfigurationLocationPattern);
    }

    private WebxConfiguration.ComponentsConfig getComponentsConfig(WebxConfiguration parentConfiguration) {
        WebxConfiguration.ComponentsConfig componentsConfig = Assert.assertNotNull(parentConfiguration, "parentConfiguration", new Object[0]).getComponentsConfig();
        if (componentsConfig == null) {
            componentsConfig = new WebxConfigurationImpl.ComponentsConfigImpl();
        }
        return componentsConfig;
    }

    private WebxConfiguration getParentConfiguration() {
        try {
            return (WebxConfiguration)this.componentsContext.getBean(this.getWebxConfigurationName());
        }
        catch (BeansException e) {
            WebxConfigurationImpl parentConfiguration = new WebxConfigurationImpl();
            parentConfiguration.setApplicationContext((ApplicationContext)this.componentsContext);
            try {
                parentConfiguration.afterPropertiesSet();
            }
            catch (RuntimeException ee) {
                throw ee;
            }
            catch (Exception ee) {
                throw new RuntimeException(ee);
            }
            return parentConfiguration;
        }
    }

    private static class WebxComponentImpl
    implements WebxComponent,
    ApplicationListener {
        private final WebxComponents components;
        private final String name;
        private final String componentPath;
        private final WebxController controller;
        private final String webxConfigurationName;
        private WebApplicationContext context;

        public WebxComponentImpl(WebxComponents components, String name, String path, boolean defaultComponent, WebxController controller, String webxConfigurationName) {
            this.components = Assert.assertNotNull(components, "components", new Object[0]);
            this.name = Assert.assertNotNull(name, "componentName", new Object[0]);
            this.controller = Assert.assertNotNull(controller, "controller", new Object[0]);
            this.webxConfigurationName = Assert.assertNotNull(webxConfigurationName, "webxConfigurationName", new Object[0]);
            path = StringUtil.trimToNull(FileUtil.normalizeAbsolutePath(path, true));
            if (defaultComponent) {
                Assert.assertTrue(path == null, "default component \"%s\" should not have component path \"%s\"", name, path);
                this.componentPath = "";
            } else {
                this.componentPath = path != null ? path : "/" + name;
            }
            controller.init(this);
        }

        public WebxComponents getWebxComponents() {
            return this.components;
        }

        public String getName() {
            return this.name;
        }

        public String getComponentPath() {
            return this.componentPath;
        }

        public WebxController getWebxController() {
            return this.controller;
        }

        public WebxConfiguration getWebxConfiguration() {
            return (WebxConfiguration)this.context.getBean(this.webxConfigurationName);
        }

        public WebApplicationContext getApplicationContext() {
            return this.context;
        }

        private void setApplicationContext(WebApplicationContext context) {
            this.context = context;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ContextRefreshedEvent) {
                SpringExtUtil.autowireAndInitialize(this.controller, (ApplicationContext)this.getApplicationContext(), 4, "webxController." + this.getName());
                this.controller.onRefreshContext();
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("name", this.name);
            mb.append("path", this.componentPath);
            mb.append("controller", this.controller);
            mb.append("context", this.context);
            return new ToStringBuilder().append("WebxComponent").append(mb).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebxComponentsImpl
    implements WebxComponents,
    ApplicationListener {
        private final WebxConfiguration parentConfiguration;
        private final WebApplicationContext parentContext;
        private final Map<String, WebxComponent> components;
        private final RootComponent rootComponent;
        private final String defaultComponentName;
        private final WebxRootController rootController;

        public WebxComponentsImpl(WebApplicationContext parentContext, String defaultComponentName, WebxRootController rootController, WebxConfiguration parentConfiguration) {
            this.parentConfiguration = Assert.assertNotNull(parentConfiguration, "no parent webx-configuration", new Object[0]);
            this.parentContext = parentContext;
            this.components = CollectionUtil.createHashMap();
            this.rootComponent = new RootComponent();
            this.defaultComponentName = defaultComponentName;
            this.rootController = Assert.assertNotNull(rootController, "no rootController", new Object[0]);
            rootController.init(this);
        }

        @Override
        public WebxConfiguration getParentWebxConfiguration() {
            return this.parentConfiguration;
        }

        private void addComponent(WebxComponent component) {
            this.components.put(component.getName(), component);
        }

        @Override
        public WebxComponent getComponent(String componentName) {
            if (componentName == null) {
                return this.rootComponent;
            }
            return this.components.get(componentName);
        }

        @Override
        public String[] getComponentNames() {
            Object[] names = this.components.keySet().toArray(new String[this.components.size()]);
            Arrays.sort(names);
            return names;
        }

        @Override
        public WebxComponent getDefaultComponent() {
            return this.defaultComponentName == null ? null : this.components.get(this.defaultComponentName);
        }

        @Override
        public Iterator<WebxComponent> iterator() {
            return this.components.values().iterator();
        }

        @Override
        public WebxComponent findMatchedComponent(String path) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            WebxComponent defaultComponent = this.getDefaultComponent();
            WebxComponent matched = null;
            for (WebxComponent component : this) {
                String componentPath;
                if (component == defaultComponent || !path.startsWith(componentPath = component.getComponentPath()) || path.length() != componentPath.length() && path.charAt(componentPath.length()) != '/') continue;
                matched = component;
                break;
            }
            if (matched == null) {
                matched = defaultComponent;
            }
            return matched;
        }

        @Override
        public WebxRootController getWebxRootController() {
            return this.rootController;
        }

        @Override
        public WebApplicationContext getParentApplicationContext() {
            return this.parentContext;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ContextRefreshedEvent) {
                SpringExtUtil.autowireAndInitialize(this.rootController, (ApplicationContext)this.getParentApplicationContext(), 4, "webxRootController");
                this.rootController.onRefreshContext();
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("parentContext", this.parentContext);
            mb.append("defaultComponentName", this.defaultComponentName);
            mb.append("components", this.components);
            mb.append("rootController", this.rootController);
            return new ToStringBuilder().append("WebxComponents").append(mb).toString();
        }

        private class RootComponent
        implements WebxComponent {
            private RootComponent() {
            }

            public WebxComponents getWebxComponents() {
                return WebxComponentsImpl.this;
            }

            public String getName() {
                return null;
            }

            public String getComponentPath() {
                return "";
            }

            public WebxConfiguration getWebxConfiguration() {
                return WebxComponentsImpl.this.getParentWebxConfiguration();
            }

            public WebxController getWebxController() {
                Assert.unsupportedOperation("RootComponent.getWebxController()", new Object[0]);
                return null;
            }

            public WebApplicationContext getApplicationContext() {
                return WebxComponentsImpl.this.getParentApplicationContext();
            }

            public String toString() {
                return WebxComponentsImpl.this.toString();
            }
        }
    }

    public static class WebxComponentsCreator
    implements BeanFactoryPostProcessor,
    Ordered {
        private final WebxComponentsLoader loader;

        public WebxComponentsCreator(WebxComponentsLoader loader) {
            this.loader = Assert.assertNotNull(loader, "WebxComponentsLoader", new Object[0]);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            if (this.loader.components == null) {
                WebxComponentsImpl components = this.loader.createComponents(this.loader.getParentConfiguration(), beanFactory);
                AbstractApplicationContext wcc = (AbstractApplicationContext)components.getParentApplicationContext();
                wcc.addApplicationListener((ApplicationListener)new SourceFilteringListener((Object)wcc, (ApplicationListener)components));
                this.loader.components = components;
            }
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }
}

