package com.alibaba.fastjson2.util;

/**
 * @Date 2024/5/24 18:16
 * @Created by wangyc
 */
class ED {
    public final short e10;
    public final byte adl;
    public final long bv;
    public final boolean b;
    public final int o5;
    public final int d4;
    public final int d3;
    public final int d2;

    ED(long[] data) {
        this.e10 = (short) data[0];
        this.adl = (byte) data[1];
        this.bv = data[2];
        this.d4 = (int) data[3];
        this.b = bv != 0;
        this.o5 = adl + 2 - e10;
        this.d3 = this.d4 / 10;
        this.d2 = this.d3 / 10;
    }

    static ED[] E5_D_A = new ED[1127];
    static ED[] E2_D_A = new ED[972];

    static {
        long[][] e5datas = {{15, 15, 0, 1000}, {15, 16, 0, 5000}, {15, 16, 0, 2500}, {14, 15, 0x1c6bf52633ffffL, 1250}, {14, 16, 0, 6250}, {14, 16, 0, 3125}, {13, 15, 0x16bcc41e8fffffL, 1562}, {13, 16, 0, 7812}, {13, 16, 0, 3906}, {12, 15, 0x12309ce53fffffL, 1953}, {12, 16, 0, 9765}, {12, 16, 0, 4882}, {12, 16, 0, 2441}, {11, 15, 0x1d1a94a1ffffffL, 1220}, {11, 16, 0, 6103}, {11, 16, 0, 3051}, {10, 15, 0x174876e7ffffffL, 1525}, {10, 16, 0, 7629}, {10, 16, 0, 3814}, {9, 15, 0x12a05f1fffffffL, 1907}, {9, 16, 0, 9536}, {9, 16, 0, 4768}, {9, 16, 0, 2384}, {8, 15, 0x1dcd64ffffffffL, 1192}, {8, 16, 0, 5960}, {8, 16, 0, 2980}, {7, 15, 0x17d783ffffffffL, 1490}, {7, 16, 0, 7450}, {7, 16, 0, 3725}, {6, 15, 0x1312cfffffffffL, 1862}, {6, 16, 0, 9313}, {6, 16, 0, 4656}, {6, 16, 0, 2328}, {5, 15, 0x1e847fffffffffL, 1164}, {5, 16, 0, 5820}, {5, 16, 0, 2910}, {4, 15, 0x1869ffffffffffL, 1455}, {4, 16, 0, 7275}, {4, 16, 0, 3637}, {3, 15, 0x1387ffffffffffL, 1818}, {3, 16, 0, 9094}, {3, 16, 0, 4547}, {3, 16, 0, 2273}, {2, 15, 0x1f3fffffffffffL, 1136}, {2, 16, 0, 5684}, {2, 16, 0, 2842}, {1, 15, 0x18ffffffffffffL, 1421}, {1, 16, 0, 7105}, {1, 16, 0, 3552}, {0, 15, 0x13ffffffffffffL, 1776}, {0, 16, 0, 8881}, {0, 16, 0, 4440}, {0, 16, 0, 2220}, {-1, 15, 0, 1110}, {-1, 16, 0, 5551}, {-1, 16, 0, 2775}, {-2, 15, 0x19999999999999L, 1387}, {-2, 16, 0, 6938}, {-2, 16, 0, 3469}, {-3, 15, 0x147ae147ae147aL, 1734}, {-3, 16, 0, 8673}, {-3, 16, 0, 4336}, {-4, 15, 0x10624dd2f1a9fbL, 2168}, {-4, 15, 0, 1084}, {-4, 16, 0, 5421}, {-4, 16, 0, 2710}, {-5, 15, 0x1a36e2eb1c432cL, 1355}, {-5, 16, 0, 6776}, {-5, 16, 0, 3388}, {-6, 15, 0x14f8b588e368f0L, 1694}, {-6, 16, 0, 8470}, {-6, 16, 0, 4235}, {-7, 15, 0x10c6f7a0b5ed8dL, 2117}, {-7, 15, 0, 1058}, {-7, 16, 0, 5293}, {-7, 16, 0, 2646}, {-8, 15, 0x1ad7f29abcaf48L, 1323}, {-8, 16, 0, 6617}, {-8, 16, 0, 3308}, {-9, 15, 0x15798ee2308c39L, 1654}, {-9, 16, 0, 8271}, {-9, 16, 0, 4135}, {-10, 15, 0x112e0be826d694L, 2067}, {-10, 15, 0, 1033}, {-10, 16, 0, 5169}, {-10, 16, 0, 2584}, {-11, 15, 0x1b7cdfd9d7bdbaL, 1292}, {-11, 16, 0, 6462}, {-11, 16, 0, 3231}, {-12, 15, 0x15fd7fe1796495L, 1615}, {-12, 16, 0, 8077}, {-12, 16, 0, 4038}, {-13, 15, 0x119799812dea11L, 2019}, {-13, 15, 0, 1009}, {-13, 16, 0, 5048}, {-13, 16, 0, 2524}, {-14, 15, 0x1c25c268497681L, 1262}, {-14, 16, 0, 6310}, {-14, 16, 0, 3155}, {-15, 15, 0x16849b86a12b9bL, 1577}, {-15, 16, 0, 7888}, {-15, 16, 0, 3944}, {-16, 15, 0x1203af9ee75615L, 1972}, {-16, 16, 0, 9860}, {-16, 16, 0, 4930}, {-16, 16, 0, 2465}, {-17, 15, 0x1cd2b297d889bcL, 1232}, {-17, 16, 0, 6162}, {-17, 16, 0, 3081}, {-18, 15, 0x170ef54646d496L, 1540}, {-18, 16, 0, 7703}, {-18, 16, 0, 3851}, {-19, 15, 0x12725dd1d243abL, 1925}, {-19, 16, 0, 9629}, {-19, 16, 0, 4814}, {-19, 16, 0, 2407}, {-20, 15, 0x1d83c94fb6d2acL, 1203}, {-20, 16, 0, 6018}, {-20, 16, 0, 3009}, {-21, 15, 0x179ca10c924223L, 1504}, {-21, 16, 0, 7523}, {-21, 16, 0, 3761}, {-22, 15, 0x12e3b40a0e9b4fL, 1880}, {-22, 16, 0, 9403}, {-22, 16, 0, 4701}, {-22, 16, 0, 2350}, {-23, 15, 0x1e392010175ee5L, 1175}, {-23, 16, 0, 5877}, {-23, 16, 0, 2938}, {-24, 15, 0x182db34012b251L, 1469}, {-24, 16, 0, 7346}, {-24, 16, 0, 3673}, {-25, 15, 0x1357c299a88ea7L, 1836}, {-25, 16, 0, 9183}, {-25, 16, 0, 4591}, {-25, 16, 0, 2295}, {-26, 15, 0x1ef2d0f5da7dd8L, 1147}, {-26, 16, 0, 5739}, {-26, 16, 0, 2869}, {-27, 15, 0x18c240c4aecb13L, 1434}, {-27, 16, 0, 7174}, {-27, 16, 0, 3587}, {-28, 15, 0x13ce9a36f23c0fL, 1793}, {-28, 16, 0, 8968}, {-28, 16, 0, 4484}, {-28, 16, 0, 2242}, {-29, 15, 0x1fb0f6be506019L, 1121}, {-29, 16, 0, 5605}, {-29, 16, 0, 2802}, {-30, 15, 0x195a5efea6b347L, 1401}, {-30, 16, 0, 7006}, {-30, 16, 0, 3503}, {-31, 15, 0x14484bfeebc29fL, 1751}, {-31, 16, 0, 8758}, {-31, 16, 0, 4379}, {-32, 15, 0x1039d66589687fL, 2189}, {-32, 15, 0, 1094}, {-32, 16, 0, 5473}, {-32, 16, 0, 2736}, {-33, 15, 0x19f623d5a8a732L, 1368}, {-33, 16, 0, 6842}, {-33, 16, 0, 3421}, {-34, 15, 0x14c4e977ba1f5bL, 1710}, {-34, 16, 0, 8552}, {-34, 16, 0, 4276}, {-35, 15, 0x109d8792fb4c49L, 2138}, {-35, 15, 0, 1069}, {-35, 16, 0, 5345}, {-35, 16, 0, 2672}, {-36, 15, 0x1a95a5b7f87a0eL, 1336}, {-36, 16, 0, 6681}, {-36, 16, 0, 3340}, {-37, 15, 0x154484932d2e72L, 1670}, {-37, 16, 0, 8352}, {-37, 16, 0, 4176}, {-38, 15, 0x11039d428a8b8eL, 2088}, {-38, 15, 0, 1044}, {-38, 16, 0, 5220}, {-38, 16, 0, 2610}, {-39, 15, 0x1b38fb9daa78e4L, 1305}, {-39, 16, 0, 6525}, {-39, 16, 0, 3262}, {-40, 15, 0x15c72fb1552d83L, 1631}, {-40, 16, 0, 8156}, {-40, 16, 0, 4078}, {-41, 15, 0x116c262777579cL, 2039}, {-41, 15, 0, 1019}, {-41, 16, 0, 5097}, {-41, 16, 0, 2548}, {-42, 15, 0x1be03d0bf225c6L, 1274}, {-42, 16, 0, 6372}, {-42, 16, 0, 3186}, {-43, 15, 0x164cfda3281e38L, 1593}, {-43, 16, 0, 7965}, {-43, 16, 0, 3982}, {-44, 15, 0x11d7314f534b60L, 1991}, {-44, 16, 0, 9956}, {-44, 16, 0, 4978}, {-44, 16, 0, 2489}, {-45, 15, 0x1c8b8218854567L, 1244}, {-45, 16, 0, 6223}, {-45, 16, 0, 3111}, {-46, 15, 0x16d601ad376ab9L, 1555}, {-46, 16, 0, 7778}, {-46, 16, 0, 3889}, {-47, 15, 0x1244ce242c5560L, 1944}, {-47, 16, 0, 9723}, {-47, 16, 0, 4861}, {-47, 16, 0, 2430}, {-48, 15, 0x1d3ae36d13bbceL, 1215}, {-48, 16, 0, 6077}, {-48, 16, 0, 3038}, {-49, 15, 0x17624f8a762fd8L, 1519}, {-49, 16, 0, 7596}, {-49, 16, 0, 3798}, {-50, 15, 0x12b50c6ec4f313L, 1899}, {-50, 16, 0, 9495}, {-50, 16, 0, 4747}, {-50, 16, 0, 2373}, {-51, 15, 0x1dee7a4ad4b81eL, 1186}, {-51, 16, 0, 5934}, {-51, 16, 0, 2967}, {-52, 15, 0x17f1fb6f10934bL, 1483}, {-52, 16, 0, 7418}, {-52, 16, 0, 3709}, {-53, 15, 0x1327fc58da0f6fL, 1854}, {-53, 16, 0, 9273}, {-53, 16, 0, 4636}, {-53, 16, 0, 2318}, {-54, 15, 0x1ea6608e29b24cL, 1159}, {-54, 16, 0, 5795}, {-54, 16, 0, 2897}, {-55, 15, 0x18851a0b548ea3L, 1448}, {-55, 16, 0, 7244}, {-55, 16, 0, 3622}, {-56, 15, 0x139dae6f76d883L, 1811}, {-56, 16, 0, 9055}, {-56, 16, 0, 4527}, {-56, 16, 0, 2263}, {-57, 15, 0x1f62b0b257c0d1L, 1131}, {-57, 16, 0, 5659}, {-57, 16, 0, 2829}, {-58, 15, 0x191bc08eac9a41L, 1414}, {-58, 16, 0, 7074}, {-58, 16, 0, 3537}, {-59, 15, 0x141633a556e1cdL, 1768}, {-59, 16, 0, 8843}, {-59, 16, 0, 4421}, {-60, 15, 0x1011c2eaabe7d7L, 2210}, {-60, 15, 0, 1105}, {-60, 16, 0, 5527}, {-60, 16, 0, 2763}, {-61, 15, 0x19b604aaaca626L, 1381}, {-61, 16, 0, 6908}, {-61, 16, 0, 3454}, {-62, 15, 0x14919d5556eb51L, 1727}, {-62, 16, 0, 8636}, {-62, 16, 0, 4318}, {-63, 15, 0x10747ddddf22a7L, 2159}, {-63, 15, 0, 1079}, {-63, 16, 0, 5397}, {-63, 16, 0, 2698}, {-64, 15, 0x1a53fc9631d10cL, 1349}, {-64, 16, 0, 6747}, {-64, 16, 0, 3373}, {-65, 15, 0x150ffd44f4a73dL, 1686}, {-65, 16, 0, 8433}, {-65, 16, 0, 4216}, {-66, 15, 0x10d9976a5d5297L, 2108}, {-66, 15, 0, 1054}, {-66, 16, 0, 5271}, {-66, 16, 0, 2635}, {-67, 15, 0x1af5bf109550f2L, 1317}, {-67, 16, 0, 6588}, {-67, 16, 0, 3294}, {-68, 15, 0x159165a6ddda5bL, 1647}, {-68, 16, 0, 8236}, {-68, 16, 0, 4118}, {-69, 15, 0x11411e1f17e1e2L, 2059}, {-69, 15, 0, 1029}, {-69, 16, 0, 5147}, {-69, 16, 0, 2573}, {-70, 15, 0x1b9b6364f30304L, 1286}, {-70, 16, 0, 6434}, {-70, 16, 0, 3217}, {-71, 15, 0x1615e91d8f359dL, 1608}, {-71, 16, 0, 8043}, {-71, 16, 0, 4021}, {-72, 15, 0x11ab20e472914aL, 2010}, {-72, 15, 0, 1005}, {-72, 16, 0, 5026}, {-72, 16, 0, 2513}, {-73, 15, 0x1c45016d841baaL, 1256}, {-73, 16, 0, 6283}, {-73, 16, 0, 3141}, {-74, 15, 0x169d9abe034955L, 1570}, {-74, 16, 0, 7854}, {-74, 16, 0, 3927}, {-75, 15, 0x1217aefe690777L, 1963}, {-75, 16, 0, 9818}, {-75, 16, 0, 4909}, {-75, 16, 0, 2454}, {-76, 15, 0x1cf2b1970e7258L, 1227}, {-76, 16, 0, 6136}, {-76, 16, 0, 3068}, {-77, 15, 0x17288e1271f513L, 1534}, {-77, 16, 0, 7670}, {-77, 16, 0, 3835}, {-78, 15, 0x1286d80ec190dcL, 1917}, {-78, 16, 0, 9588}, {-78, 16, 0, 4794}, {-78, 16, 0, 2397}, {-79, 15, 0x1da48ce468e7c7L, 1198}, {-79, 16, 0, 5992}, {-79, 16, 0, 2996}, {-80, 15, 0x17b6d71d20b96cL, 1498}, {-80, 16, 0, 7490}, {-80, 16, 0, 3745}, {-81, 15, 0x12f8ac174d6123L, 1872}, {-81, 16, 0, 9363}, {-81, 16, 0, 4681}, {-81, 16, 0, 2340}, {-82, 15, 0x1e5aacf2156838L, 1170}, {-82, 16, 0, 5852}, {-82, 16, 0, 2926}, {-83, 15, 0x18488a5b445360L, 1463}, {-83, 16, 0, 7315}, {-83, 16, 0, 3657}, {-84, 15, 0x136d3b7c36a919L, 1828}, {-84, 16, 0, 9143}, {-84, 16, 0, 4571}, {-84, 16, 0, 2285}, {-85, 15, 0x1f152bf9f10e8fL, 1142}, {-85, 16, 0, 5714}, {-85, 16, 0, 2857}, {-86, 15, 0x18ddbcc7f40ba6L, 1428}, {-86, 16, 0, 7143}, {-86, 16, 0, 3571}, {-87, 15, 0x13e497065cd61eL, 1785}, {-87, 16, 0, 8929}, {-87, 16, 0, 4464}, {-87, 16, 0, 2232}, {-88, 15, 0x1fd424d6faf030L, 1116}, {-88, 16, 0, 5580}, {-88, 16, 0, 2790}, {-89, 15, 0x197683df2f268dL, 1395}, {-89, 16, 0, 6976}, {-89, 16, 0, 3488}, {-90, 15, 0x145ecfe5bf520aL, 1744}, {-90, 16, 0, 8720}, {-90, 16, 0, 4360}, {-91, 15, 0x104bd984990e6fL, 2180}, {-91, 15, 0, 1090}, {-91, 16, 0, 5450}, {-91, 16, 0, 2725}, {-92, 15, 0x1a12f5a0f4e3e4L, 1362}, {-92, 16, 0, 6812}, {-92, 16, 0, 3406}, {-93, 15, 0x14dbf7b3f71cb7L, 1703}, {-93, 16, 0, 8515}, {-93, 16, 0, 4257}, {-94, 15, 0x10aff95cc5b092L, 2128}, {-94, 15, 0, 1064}, {-94, 16, 0, 5322}, {-94, 16, 0, 2661}, {-95, 15, 0x1ab328946f80eaL, 1330}, {-95, 16, 0, 6653}, {-95, 16, 0, 3326}, {-96, 15, 0x155c2076bf9a55L, 1663}, {-96, 16, 0, 8316}, {-96, 16, 0, 4158}, {-97, 15, 0x1116805effaeaaL, 2079}, {-97, 15, 0, 1039}, {-97, 16, 0, 5197}, {-97, 16, 0, 2598}, {-98, 15, 0x1b5733cb32b110L, 1299}, {-98, 16, 0, 6497}, {-98, 16, 0, 3248}, {-99, 15, 0x15df5ca28ef40dL, 1624}, {-99, 16, 0, 8121}, {-99, 16, 0, 4060}, {-100, 15, 0x117f7d4ed8c33dL, 2030}, {-100, 15, 0, 1015}, {-100, 16, 0, 5075}, {-100, 16, 0, 2537}, {-101, 15, 0x1bff2ee48e052fL, 1268}, {-101, 16, 0, 6344}, {-101, 16, 0, 3172}, {-102, 15, 0x1665bf1d3e6a8cL, 1586}, {-102, 16, 0, 7931}, {-102, 16, 0, 3965}, {-103, 15, 0x11eaff4a98553dL, 1982}, {-103, 16, 0, 9913}, {-103, 16, 0, 4956}, {-103, 16, 0, 2478}, {-104, 15, 0x1cab3210f3bb95L, 1239}, {-104, 16, 0, 6196}, {-104, 16, 0, 3098}, {-105, 15, 0x16ef5b40c2fc77L, 1549}, {-105, 16, 0, 7745}, {-105, 16, 0, 3872}, {-106, 15, 0x125915cd68c9f9L, 1936}, {-106, 16, 0, 9681}, {-106, 16, 0, 4840}, {-106, 16, 0, 2420}, {-107, 15, 0x1d5b561574765bL, 1210}, {-107, 16, 0, 6050}, {-107, 16, 0, 3025}, {-108, 15, 0x177c44ddf6c515L, 1512}, {-108, 16, 0, 7563}, {-108, 16, 0, 3781}, {-109, 15, 0x12c9d0b1923744L, 1890}, {-109, 16, 0, 9454}, {-109, 16, 0, 4727}, {-109, 16, 0, 2363}, {-110, 15, 0x1e0fb44f50586eL, 1181}, {-110, 16, 0, 5909}, {-110, 16, 0, 2954}, {-111, 15, 0x180c903f7379f1L, 1477}, {-111, 16, 0, 7386}, {-111, 16, 0, 3693}, {-112, 15, 0x133d4032c2c7f4L, 1846}, {-112, 16, 0, 9232}, {-112, 16, 0, 4616}, {-112, 16, 0, 2308}, {-113, 15, 0x1ec866b79e0cbaL, 1154}, {-113, 16, 0, 5770}, {-113, 16, 0, 2885}, {-114, 15, 0x18a0522c7e7095L, 1442}, {-114, 16, 0, 7213}, {-114, 16, 0, 3606}, {-115, 15, 0x13b374f06526ddL, 1803}, {-115, 16, 0, 9016}, {-115, 16, 0, 4508}, {-115, 16, 0, 2254}, {-116, 15, 0x1f8587e7083e2fL, 1127}, {-116, 16, 0, 5635}, {-116, 16, 0, 2817}, {-117, 15, 0x19379fec069826L, 1408}, {-117, 16, 0, 7044}, {-117, 16, 0, 3522}, {-118, 15, 0x142c7ff0054684L, 1761}, {-118, 16, 0, 8805}, {-118, 16, 0, 4402}, {-119, 15, 0x1023998cd10537L, 2201}, {-119, 15, 0, 1100}, {-119, 16, 0, 5503}, {-119, 16, 0, 2751}, {-120, 15, 0x19d28f47b4d524L, 1375}, {-120, 16, 0, 6879}, {-120, 16, 0, 3439}, {-121, 15, 0x14a8729fc3ddb7L, 1719}, {-121, 16, 0, 8598}, {-121, 16, 0, 4299}, {-122, 15, 0x1086c219697e2cL, 2149}, {-122, 15, 0, 1074}, {-122, 16, 0, 5374}, {-122, 16, 0, 2687}, {-123, 15, 0x1a71368f0f3046L, 1343}, {-123, 16, 0, 6717}, {-123, 16, 0, 3358}, {-124, 15, 0x15275ed8d8f36bL, 1679}, {-124, 16, 0, 8397}, {-124, 16, 0, 4198}, {-125, 15, 0x10ec4be0ad8f89L, 2099}, {-125, 15, 0, 1049}, {-125, 16, 0, 5248}, {-125, 16, 0, 2624}, {-126, 15, 0x1b13ac9aaf4c0eL, 1312}, {-126, 16, 0, 6560}, {-126, 16, 0, 3280}, {-127, 15, 0x15a956e225d672L, 1640}, {-127, 16, 0, 8200}, {-127, 16, 0, 4100}, {-128, 15, 0x11544581b7dec1L, 2050}, {-128, 15, 0, 1025}, {-128, 16, 0, 5125}, {-128, 16, 0, 2562}, {-129, 15, 0x1bba08cf8c979cL, 1281}, {-129, 16, 0, 6406}, {-129, 16, 0, 3203}, {-130, 15, 0x162e6d72d6dfb0L, 1601}, {-130, 16, 0, 8008}, {-130, 16, 0, 4004}, {-131, 15, 0x11bebdf578b2f3L, 2002}, {-131, 15, 0, 1001}, {-131, 16, 0, 5005}, {-131, 16, 0, 2502}, {-132, 15, 0x1c6463225ab7ecL, 1251}, {-132, 16, 0, 6256}, {-132, 16, 0, 3128}, {-133, 15, 0x16b6b5b5155ff0L, 1564}, {-133, 16, 0, 7820}, {-133, 16, 0, 3910}, {-134, 15, 0x122bc490dde659L, 1955}, {-134, 16, 0, 9775}, {-134, 16, 0, 4887}, {-134, 16, 0, 2443}, {-135, 15, 0x1d12d41afca3c2L, 1221}, {-135, 16, 0, 6109}, {-135, 16, 0, 3054}, {-136, 15, 0x17424348ca1c9bL, 1527}, {-136, 16, 0, 7637}, {-136, 16, 0, 3818}, {-137, 15, 0x129b69070816e2L, 1909}, {-137, 16, 0, 9546}, {-137, 16, 0, 4773}, {-137, 16, 0, 2386}, {-138, 15, 0x1dc574d80cf16bL, 1193}, {-138, 16, 0, 5966}, {-138, 16, 0, 2983}, {-139, 15, 0x17d12a4670c122L, 1491}, {-139, 16, 0, 7458}, {-139, 16, 0, 3729}, {-140, 15, 0x130dbb6b8d674eL, 1864}, {-140, 16, 0, 9322}, {-140, 16, 0, 4661}, {-140, 16, 0, 2330}, {-141, 15, 0x1e7c5f127bd87eL, 1165}, {-141, 16, 0, 5826}, {-141, 16, 0, 2913}, {-142, 15, 0x18637f41fcad31L, 1456}, {-142, 16, 0, 7283}, {-142, 16, 0, 3641}, {-143, 15, 0x1382cc34ca2427L, 1820}, {-143, 16, 0, 9104}, {-143, 16, 0, 4552}, {-143, 16, 0, 2276}, {-144, 15, 0x1f37ad21436d0cL, 1138}, {-144, 16, 0, 5690}, {-144, 16, 0, 2845}, {-145, 15, 0x18f9574dcf8a70L, 1422}, {-145, 16, 0, 7112}, {-145, 16, 0, 3556}, {-146, 15, 0x13faac3e3fa1f3L, 1778}, {-146, 16, 0, 8891}, {-146, 16, 0, 4445}, {-146, 16, 0, 2222}, {-147, 15, 0x1ff779fd329cb8L, 1111}, {-147, 16, 0, 5556}, {-147, 16, 0, 2778}, {-148, 15, 0x1992c7fdc216faL, 1389}, {-148, 16, 0, 6946}, {-148, 16, 0, 3473}, {-149, 15, 0x14756ccb01abfbL, 1736}, {-149, 16, 0, 8682}, {-149, 16, 0, 4341}, {-150, 15, 0x105df0a267bcc9L, 2170}, {-150, 15, 0, 1085}, {-150, 16, 0, 5426}, {-150, 16, 0, 2713}, {-151, 15, 0x1a2fe76a3f9474L, 1356}, {-151, 16, 0, 6783}, {-151, 16, 0, 3391}, {-152, 15, 0x14f31f8832dd2aL, 1695}, {-152, 16, 0, 8479}, {-152, 16, 0, 4239}, {-153, 15, 0x10c27fa028b0eeL, 2119}, {-153, 15, 0, 1059}, {-153, 16, 0, 5299}, {-153, 16, 0, 2649}, {-154, 15, 0x1ad0cc33744e4aL, 1324}, {-154, 16, 0, 6624}, {-154, 16, 0, 3312}, {-155, 15, 0x1573d68f903ea2L, 1656}, {-155, 16, 0, 8280}, {-155, 16, 0, 4140}, {-156, 15, 0x11297872d9cbb4L, 2070}, {-156, 15, 0, 1035}, {-156, 16, 0, 5175}, {-156, 16, 0, 2587}, {-157, 15, 0x1b758d848fac54L, 1293}, {-157, 16, 0, 6469}, {-157, 16, 0, 3234}, {-158, 15, 0x15f7a46a0c89ddL, 1617}, {-158, 16, 0, 8086}, {-158, 16, 0, 4043}, {-159, 15, 0x1192e9ee706e4aL, 2021}, {-159, 15, 0, 1010}, {-159, 16, 0, 5053}, {-159, 16, 0, 2526}, {-160, 15, 0x1c1e43171a4a11L, 1263}, {-160, 16, 0, 6317}, {-160, 16, 0, 3158}, {-161, 15, 0x167e9c127b6e74L, 1579}, {-161, 16, 0, 7896}, {-161, 16, 0, 3948}, {-162, 15, 0x11fee341fc585cL, 1974}, {-162, 16, 0, 9871}, {-162, 16, 0, 4935}, {-162, 16, 0, 2467}, {-163, 15, 0x1ccb0536608d61L, 1233}, {-163, 16, 0, 6169}, {-163, 16, 0, 3084}, {-164, 15, 0x1708d0f84d3de7L, 1542}, {-164, 16, 0, 7711}, {-164, 16, 0, 3855}, {-165, 15, 0x126d73f9d764b9L, 1927}, {-165, 16, 0, 9639}, {-165, 16, 0, 4819}, {-165, 16, 0, 2409}, {-166, 15, 0x1d7becc2f23ac1L, 1204}, {-166, 16, 0, 6024}, {-166, 16, 0, 3012}, {-167, 15, 0x179657025b6234L, 1506}, {-167, 16, 0, 7530}, {-167, 16, 0, 3765}, {-168, 15, 0x12deac01e2b4f6L, 1882}, {-168, 16, 0, 9413}, {-168, 16, 0, 4706}, {-168, 16, 0, 2353}, {-169, 15, 0x1e3113363787f1L, 1176}, {-169, 16, 0, 5883}, {-169, 16, 0, 2941}, {-170, 15, 0x18274291c6065aL, 1470}, {-170, 16, 0, 7354}, {-170, 16, 0, 3677}, {-171, 15, 0x13529ba7d19eafL, 1838}, {-171, 16, 0, 9193}, {-171, 16, 0, 4596}, {-171, 16, 0, 2298}, {-172, 15, 0x1eea92a61c3118L, 1149}, {-172, 16, 0, 5745}, {-172, 16, 0, 2872}, {-173, 15, 0x18bba884e35a79L, 1436}, {-173, 16, 0, 7182}, {-173, 16, 0, 3591}, {-174, 15, 0x13c9539d82aec7L, 1795}, {-174, 16, 0, 8977}, {-174, 16, 0, 4488}, {-174, 16, 0, 2244}, {-175, 15, 0x1fa885c8d117a6L, 1122}, {-175, 16, 0, 5611}, {-175, 16, 0, 2805}, {-176, 15, 0x19539e3a40dfb8L, 1402}, {-176, 16, 0, 7013}, {-176, 16, 0, 3506}, {-177, 15, 0x1442e4fb671960L, 1753}, {-177, 16, 0, 8767}, {-177, 16, 0, 4383}, {-178, 15, 0x103583fc527ab3L, 2191}, {-178, 15, 0, 1095}, {-178, 16, 0, 5479}, {-178, 16, 0, 2739}, {-179, 15, 0x19ef3993b72ab8L, 1369}, {-179, 16, 0, 6849}, {-179, 16, 0, 3424}, {-180, 15, 0x14bf6142f8eef9L, 1712}, {-180, 16, 0, 8561}, {-180, 16, 0, 4280}, {-181, 15, 0x10991a9bfa58c7L, 2140}, {-181, 15, 0, 1070}, {-181, 16, 0, 5351}, {-181, 16, 0, 2675}, {-182, 15, 0x1a8e90f9908e0cL, 1337}, {-182, 16, 0, 6688}, {-182, 16, 0, 3344}, {-183, 15, 0x153eda614071a3L, 1672}, {-183, 16, 0, 8361}, {-183, 16, 0, 4180}, {-184, 15, 0x10ff151a99f482L, 2090}, {-184, 15, 0, 1045}, {-184, 16, 0, 5225}, {-184, 16, 0, 2612}, {-185, 15, 0x1b31bb5dc320d1L, 1306}, {-185, 16, 0, 6532}, {-185, 16, 0, 3266}, {-186, 15, 0x15c162b168e70eL, 1633}, {-186, 16, 0, 8165}, {-186, 16, 0, 4082}, {-187, 15, 0x11678227871f3eL, 2041}, {-187, 15, 0, 1020}, {-187, 16, 0, 5103}, {-187, 16, 0, 2551}, {-188, 15, 0x1bd8d03f3e9863L, 1275}, {-188, 16, 0, 6379}, {-188, 16, 0, 3189}, {-189, 15, 0x16470cff6546b6L, 1594}, {-189, 16, 0, 7973}, {-189, 16, 0, 3986}, {-190, 15, 0x11d270cc51055eL, 1993}, {-190, 16, 0, 9967}, {-190, 16, 0, 4983}, {-190, 16, 0, 2491}, {-191, 15, 0x1c83e7ad4e6efdL, 1245}, {-191, 16, 0, 6229}, {-191, 16, 0, 3114}, {-192, 15, 0x16cfec8aa52597L, 1557}, {-192, 16, 0, 7786}, {-192, 16, 0, 3893}, {-193, 15, 0x123ff06eea8479L, 1946}, {-193, 16, 0, 9733}, {-193, 16, 0, 4866}, {-193, 16, 0, 2433}, {-194, 15, 0x1d331a4b10d3f5L, 1216}, {-194, 16, 0, 6083}, {-194, 16, 0, 3041}, {-195, 15, 0x175c1508da432aL, 1520}, {-195, 16, 0, 7604}, {-195, 16, 0, 3802}, {-196, 15, 0x12b010d3e1cf55L, 1901}, {-196, 16, 0, 9505}, {-196, 16, 0, 4752}, {-196, 16, 0, 2376}, {-197, 15, 0x1de6815302e555L, 1188}, {-197, 16, 0, 5940}, {-197, 16, 0, 2970}, {-198, 15, 0x17eb9aa8cf1ddeL, 1485}, {-198, 16, 0, 7426}, {-198, 16, 0, 3713}, {-199, 15, 0x1322e220a5b17eL, 1856}, {-199, 16, 0, 9282}, {-199, 16, 0, 4641}, {-199, 16, 0, 2320}, {-200, 15, 0x1e9e369aa2b597L, 1160}, {-200, 16, 0, 5801}, {-200, 16, 0, 2900}, {-201, 15, 0x187e92154ef7acL, 1450}, {-201, 16, 0, 7252}, {-201, 16, 0, 3626}, {-202, 15, 0x139874ddd8c623L, 1813}, {-202, 16, 0, 9065}, {-202, 16, 0, 4532}, {-202, 16, 0, 2266}, {-203, 15, 0x1f5a549627a36bL, 1133}, {-203, 16, 0, 5665}, {-203, 16, 0, 2832}, {-204, 15, 0x191510781fb5efL, 1416}, {-204, 16, 0, 7082}, {-204, 16, 0, 3541}, {-205, 15, 0x1410d9f9b2f7f2L, 1770}, {-205, 16, 0, 8852}, {-205, 16, 0, 4426}, {-206, 15, 0x100d7b2e28c65bL, 2213}, {-206, 15, 0, 1106}, {-206, 16, 0, 5532}, {-206, 16, 0, 2766}, {-207, 15, 0x19af2b7d0e0a2cL, 1383}, {-207, 16, 0, 6916}, {-207, 16, 0, 3458}, {-208, 15, 0x148c22ca71a1bdL, 1729}, {-208, 16, 0, 8645}, {-208, 16, 0, 4322}, {-209, 15, 0x10701bd527b497L, 2161}, {-209, 15, 0, 1080}, {-209, 16, 0, 5403}, {-209, 16, 0, 2701}, {-210, 15, 0x1a4cf9550c5425L, 1350}, {-210, 16, 0, 6754}, {-210, 16, 0, 3377}, {-211, 15, 0x150a6110d6a9b7L, 1688}, {-211, 16, 0, 8442}, {-211, 16, 0, 4221}, {-212, 15, 0x10d51a73deee2cL, 2110}, {-212, 15, 0, 1055}, {-212, 16, 0, 5276}, {-212, 16, 0, 2638}, {-213, 15, 0x1aee90b964b047L, 1319}, {-213, 16, 0, 6595}, {-213, 16, 0, 3297}, {-214, 15, 0x158ba6fab6f36cL, 1648}, {-214, 16, 0, 8244}, {-214, 16, 0, 4122}, {-215, 15, 0x113c85955f2923L, 2061}, {-215, 15, 0, 1030}, {-215, 16, 0, 5152}, {-215, 16, 0, 2576}, {-216, 15, 0x1b9408eefea838L, 1288}, {-216, 16, 0, 6441}, {-216, 16, 0, 3220}, {-217, 15, 0x16100725988693L, 1610}, {-217, 16, 0, 8051}, {-217, 16, 0, 4025}, {-218, 15, 0x11a66c1e139edcL, 2012}, {-218, 15, 0, 1006}, {-218, 16, 0, 5032}, {-218, 16, 0, 2516}, {-219, 15, 0x1c3d79c9b8fe2dL, 1258}, {-219, 16, 0, 6290}, {-219, 16, 0, 3145}, {-220, 15, 0x169794a160cb57L, 1572}, {-220, 16, 0, 7862}, {-220, 16, 0, 3931}, {-221, 15, 0x1212dd4de70913L, 1965}, {-221, 16, 0, 9828}, {-221, 16, 0, 4914}, {-221, 16, 0, 2457}, {-222, 15, 0x1ceafbafd80e84L, 1228}, {-222, 16, 0, 6142}, {-222, 16, 0, 3071}, {-223, 15, 0x172262f3133ed0L, 1535}, {-223, 16, 0, 7678}, {-223, 16, 0, 3839}, {-224, 15, 0x1281e8c275cbdaL, 1919}, {-224, 16, 0, 9598}, {-224, 16, 0, 4799}, {-224, 16, 0, 2399}, {-225, 15, 0x1d9ca79d894629L, 1199}, {-225, 16, 0, 5998}, {-225, 16, 0, 2999}, {-226, 15, 0x17b08617a104eeL, 1499}, {-226, 16, 0, 7498}, {-226, 16, 0, 3749}, {-227, 15, 0x12f39e794d9d8bL, 1874}, {-227, 16, 0, 9373}, {-227, 16, 0, 4686}, {-227, 16, 0, 2343}, {-228, 15, 0x1e5297287c2f45L, 1171}, {-228, 16, 0, 5858}, {-228, 16, 0, 2929}, {-229, 15, 0x18421286c9bf6aL, 1464}, {-229, 16, 0, 7322}, {-229, 16, 0, 3661}, {-230, 15, 0x13680ed23aff88L, 1830}, {-230, 16, 0, 9153}, {-230, 16, 0, 4576}, {-230, 16, 0, 2288}, {-231, 15, 0x1f0ce4839198daL, 1144}, {-231, 16, 0, 5720}, {-231, 16, 0, 2860}, {-232, 15, 0x18d71d360e13e2L, 1430}, {-232, 16, 0, 7151}, {-232, 16, 0, 3575}, {-233, 15, 0x13df4a91a4dcb4L, 1787}, {-233, 16, 0, 8938}, {-233, 16, 0, 4469}, {-233, 16, 0, 2234}, {-234, 15, 0x1fcbaa82a16121L, 1117}, {-234, 16, 0, 5586}, {-234, 16, 0, 2793}, {-235, 15, 0x196fbb9bb44db4L, 1396}, {-235, 16, 0, 6983}, {-235, 16, 0, 3491}, {-236, 15, 0x145962e2f6a490L, 1745}, {-236, 16, 0, 8729}, {-236, 16, 0, 4364}, {-237, 15, 0x1047824f2bb6d9L, 2182}, {-237, 15, 0, 1091}, {-237, 16, 0, 5455}, {-237, 16, 0, 2727}, {-238, 15, 0x1a0c03b1df8af6L, 1363}, {-238, 16, 0, 6819}, {-238, 16, 0, 3409}, {-239, 15, 0x14d6695b193bf8L, 1704}, {-239, 16, 0, 8524}, {-239, 16, 0, 4262}, {-240, 15, 0x10ab877c142ff9L, 2131}, {-240, 15, 0, 1065}, {-240, 16, 0, 5327}, {-240, 16, 0, 2663}, {-241, 15, 0x1aac0bf9b9e65cL, 1331}, {-241, 16, 0, 6659}, {-241, 16, 0, 3329}, {-242, 15, 0x15566ffafb1eb0L, 1664}, {-242, 16, 0, 8324}, {-242, 16, 0, 4162}, {-243, 15, 0x1111f32f2f4bc0L, 2081}, {-243, 15, 0, 1040}, {-243, 16, 0, 5203}, {-243, 16, 0, 2601}, {-244, 15, 0x1b4feb7eb212cdL, 1300}, {-244, 16, 0, 6503}, {-244, 16, 0, 3251}, {-245, 15, 0x15d98932280f0aL, 1625}, {-245, 16, 0, 8129}, {-245, 16, 0, 4064}, {-246, 15, 0x117ad428200c08L, 2032}, {-246, 15, 0, 1016}, {-246, 16, 0, 5081}, {-246, 16, 0, 2540}, {-247, 15, 0x1bf7b9d9cce00dL, 1270}, {-247, 16, 0, 6351}, {-247, 16, 0, 3175}, {-248, 15, 0x165fc7e170b33dL, 1587}, {-248, 16, 0, 7939}, {-248, 16, 0, 3969}, {-249, 15, 0x11e6398126f5cbL, 1984}, {-249, 16, 0, 9924}, {-249, 16, 0, 4962}, {-249, 16, 0, 2481}, {-250, 15, 0x1ca38f350b22deL, 1240}, {-250, 16, 0, 6202}, {-250, 16, 0, 3101}, {-251, 15, 0x16e93f5da2824bL, 1550}, {-251, 16, 0, 7753}, {-251, 16, 0, 3876}, {-252, 15, 0x125432b14ecea2L, 1938}, {-252, 16, 0, 9691}, {-252, 16, 0, 4845}, {-252, 16, 0, 2422}, {-253, 15, 0x1d53844ee47dd1L, 1211}, {-253, 16, 0, 6057}, {-253, 16, 0, 3028}, {-254, 15, 0x177603725064a7L, 1514}, {-254, 16, 0, 7571}, {-254, 16, 0, 3785}, {-255, 15, 0x12c4cf8ea6b6ecL, 1892}, {-255, 16, 0, 9464}, {-255, 16, 0, 4732}, {-255, 16, 0, 2366}, {-256, 15, 0x1e07b27dd78b13L, 1183}, {-256, 16, 0, 5915}, {-256, 16, 0, 2957}, {-257, 15, 0x18062864ac6f43L, 1478}, {-257, 16, 0, 7394}, {-257, 16, 0, 3697}, {-258, 15, 0x1338205089f29cL, 1848}, {-258, 16, 0, 9242}, {-258, 16, 0, 4621}, {-258, 16, 0, 2310}, {-259, 15, 0x1ec033b40fea93L, 1155}, {-259, 16, 0, 5776}, {-259, 16, 0, 2888}, {-260, 15, 0x1899c2f673220fL, 1444}, {-260, 16, 0, 7220}, {-260, 16, 0, 3610}, {-261, 15, 0x13ae3591f5b4d9L, 1805}, {-261, 16, 0, 9025}, {-261, 16, 0, 4512}, {-261, 16, 0, 2256}, {-262, 15, 0x1f7d228322baf5L, 1128}, {-262, 16, 0, 5641}, {-262, 16, 0, 2820}, {-263, 15, 0x1930e868e89590L, 1410}, {-263, 16, 0, 7051}, {-263, 16, 0, 3525}, {-264, 15, 0x14272053ed4473L, 1762}, {-264, 16, 0, 8814}, {-264, 16, 0, 4407}, {-265, 15, 0x101f4d0ff1038fL, 2203}, {-265, 15, 0, 1101}, {-265, 16, 0, 5509}, {-265, 16, 0, 2754}, {-266, 15, 0x19cbae7fe805b3L, 1377}, {-266, 16, 0, 6886}, {-266, 16, 0, 3443}, {-267, 15, 0x14a2f1ffecd15cL, 1721}, {-267, 16, 0, 8607}, {-267, 16, 0, 4303}, {-268, 15, 0x10825b3323dab0L, 2151}, {-268, 15, 0, 1075}, {-268, 16, 0, 5379}, {-268, 16, 0, 2689}, {-269, 15, 0x1a6a2b85062ab3L, 1344}, {-269, 16, 0, 6724}, {-269, 16, 0, 3362}, {-270, 15, 0x1521bc6a6b555cL, 1681}, {-270, 16, 0, 8406}, {-270, 16, 0, 4203}, {-271, 15, 0x10e7c9eebc4449L, 2101}, {-271, 15, 0, 1050}, {-271, 16, 0, 5253}, {-271, 16, 0, 2626}, {-272, 15, 0x1b0c764ac6d3a9L, 1313}, {-272, 16, 0, 6567}, {-272, 16, 0, 3283}, {-273, 15, 0x15a391d56bdc87L, 1641}, {-273, 16, 0, 8209}, {-273, 16, 0, 4104}, {-274, 15, 0x114fa7ddefe39fL, 2052}, {-274, 15, 0, 1026}, {-274, 16, 0, 5130}, {-274, 16, 0, 2565}, {-275, 15, 0x1bb2a62fe638ffL, 1282}, {-275, 16, 0, 6413}, {-275, 16, 0, 3206}, {-276, 15, 0x162884f31e93ffL, 1603}, {-276, 16, 0, 8016}, {-276, 16, 0, 4008}, {-277, 15, 0x11ba03f5b20fffL, 2004}, {-277, 15, 0, 1002}, {-277, 16, 0, 5010}, {-277, 16, 0, 2505}, {-278, 15, 0x1c5cd322b67fffL, 1252}, {-278, 16, 0, 6263}, {-278, 16, 0, 3131}, {-279, 15, 0x16b0a8e891ffffL, 1565}, {-279, 16, 0, 7828}, {-279, 16, 0, 3914}, {-280, 15, 0x1226ed86db3332L, 1957}, {-280, 16, 0, 9785}, {-280, 16, 0, 4892}, {-280, 16, 0, 2446}, {-281, 15, 0x1d0b15a491eb84L, 1223}, {-281, 16, 0, 6116}, {-281, 16, 0, 3058}, {-282, 15, 0x173c115074bc69L, 1529}, {-282, 16, 0, 7645}, {-282, 16, 0, 3822}, {-283, 15, 0x129674405d6387L, 1911}, {-283, 16, 0, 9556}, {-283, 16, 0, 4778}, {-283, 16, 0, 2389}, {-284, 15, 0x1dbd86cd6238d9L, 1194}, {-284, 16, 0, 5972}, {-284, 16, 0, 2986}, {-285, 15, 0x17cad23de82d7aL, 1493}, {-285, 16, 0, 7466}, {-285, 16, 0, 3733}, {-286, 15, 0x1308a831868ac8L, 1866}, {-286, 16, 0, 9332}, {-286, 16, 0, 4666}, {-286, 16, 0, 2333}, {-287, 15, 0x1e74404f3daadaL, 1166}, {-287, 16, 0, 5832}, {-287, 16, 0, 2916}, {-288, 15, 0x185d003f6488aeL, 1458}, {-288, 16, 0, 7291}, {-288, 16, 0, 3645}, {-289, 15, 0x137d99cc506d58L, 1822}, {-289, 16, 0, 9113}, {-289, 16, 0, 4556}, {-289, 16, 0, 2278}, {-290, 15, 0x1f2f5c7a1a488dL, 1139}, {-290, 16, 0, 5696}, {-290, 16, 0, 2848}, {-291, 15, 0x18f2b061aea071L, 1424}, {-291, 16, 0, 7120}, {-291, 16, 0, 3560}, {-292, 15, 0x13f559e7bee6c1L, 1780}, {-292, 16, 0, 8900}, {-292, 16, 0, 4450}, {-292, 16, 0, 2225}, {-293, 15, 0x1feef63f97d79bL, 1112}, {-293, 16, 0, 5562}, {-293, 16, 0, 2781}, {-294, 15, 0x198bf832dfdfafL, 1390}, {-294, 16, 0, 6953}, {-294, 16, 0, 3476}, {-295, 15, 0x146ff9c24cb2f2L, 1738}, {-295, 16, 0, 8691}, {-295, 16, 0, 4345}, {-296, 15, 0x1059949b708f28L, 2172}, {-296, 15, 0, 1086}, {-296, 16, 0, 5432}, {-296, 16, 0, 2716}, {-297, 15, 0x1a28edc580e50dL, 1358}, {-297, 16, 0, 6790}, {-297, 16, 0, 3395}, {-298, 15, 0x14ed8b04671da4L, 1697}, {-298, 16, 0, 8487}, {-298, 16, 0, 4243}, {-299, 15, 0x10be08d0527e1dL, 2121}, {-299, 15, 0, 1060}, {-299, 16, 0, 5304}, {-299, 16, 0, 2652}, {-300, 15, 0x1ac9a7b3b7302fL, 1326}, {-300, 16, 0, 6631}, {-300, 16, 0, 3315}, {-301, 15, 0x156e1fc2f8f358L, 1657}, {-301, 16, 0, 8289}, {-301, 16, 0, 4144}, {-302, 15, 0x1124e63593f5e0L, 2072}, {-302, 15, 0, 1036}, {-302, 16, 0, 5180}, {-302, 16, 0, 2590}, {-303, 15, 0x1b6e3d22865634L, 1295}, {-303, 16, 0, 6475}, {-303, 16, 0, 3237}, {-304, 15, 0x15f1ca820511c3L, 1618}, {-304, 16, 0, 8094}, {-304, 16, 0, 4047}, {-305, 15, 0x118e3b9b374169L, 2023}, {-305, 15, 0, 1011}, {-305, 16, 0, 5059}, {-305, 16, 0, 2529}, {-306, 15, 0x1c16c5c5253575L, 1264}, {-306, 16, 0, 6324}, {-306, 16, 0, 3162}, {-307, 15, 0x16789e3750f790L, 1581}, {-307, 16, 0, 7905}, {-307, 16, 0, 3952}, {-308, 15, 0x11fa182c40c60dL, 1976}, {-308, 16, 0, 9881}, {-308, 16, 0, 4940}, {-308, 16, 0, 4940}, {-309, 15, 0x1cc359e067a348L, 4940}, {-309, 15, 0, 4940}, {-309, 15, 0, 4940}, {-310, 14, 0x1702ae4d1fb5c0L, 4940}, {-310, 14, 0, 4940}, {-310, 14, 0, 4940}, {-311, 13, 0x12688b70e62b00L, 4940}, {-311, 13, 0, 4940}, {-311, 13, 0, 4940}, {-311, 13, 0, 4940}, {-312, 12, 0x1d74124e3d1000L, 4940}, {-312, 12, 0, 4940}, {-312, 12, 0, 4940}, {-313, 11, 0x17900ea4fd8000L, 4940}, {-313, 11, 0, 4940}, {-313, 11, 0, 4940}, {-314, 10, 0x12d9a550c80000L, 4940}, {-314, 10, 0, 4940}, {-314, 10, 0, 4940}, {-314, 10, 0, 4940}, {-315, 9, 0x1e290881400000L, 4940}, {-315, 9, 0, 4940}, {-315, 9, 0, 4940}, {-316, 8, 0x1820d39a000000L, 4940}, {-316, 8, 0, 4940}, {-316, 8, 0, 4940}, {-317, 7, 0x134d7610000000L, 4940}, {-317, 7, 0, 4940}, {-317, 7, 0, 4940}, {-317, 7, 0, 4940}, {-318, 6, 0x1ee25600000000L, 4940}, {-318, 6, 0, 4940}, {-318, 6, 0, 4940}, {-319, 5, 0x18b51000000000L, 4940}, {-319, 5, 0, 4940}, {-319, 5, 0, 4940}, {-320, 4, 0x13c40000000000L, 4940}, {-320, 4, 0, 4940}, {-320, 4, 0, 4940}, {-320, 4, 0, 4940}, {-321, 3, 0x1fa00000000000L, 4940}, {-321, 3, 0, 4940}, {-321, 3, 0, 4940}, {-322, 2, 0x19400000000000L, 4940}, {-322, 2, 0, 4940}, {-322, 2, 0, 4940}, {-323, 1, 0x14000000000000L, 4940}, {-323, 1, 0, 4940}, {-323, 1, 0, 4940}, {-324, 0, 0x10000000000000L, 4940}, {-324, 0, 0, 4940}};
        long[][] e2datas = {{15, 15, 0, 1000}, {15, 15, 0x11c37937e07fffL, 2000}, {16, 16, 0, 4000}, {16, 16, 0, 8000}, {16, 15, 0x16345785d89fffL, 1600}, {17, 16, 0, 3200}, {17, 16, 0, 6400}, {17, 15, 0x1bc16d674ec7ffL, 1280}, {18, 16, 0, 2560}, {18, 16, 0, 5120}, {18, 15, 0, 1024}, {18, 15, 0x1158e460913cffL, 2048}, {19, 16, 0, 4096}, {19, 16, 0, 8192}, {19, 15, 0x15af1d78b58c3fL, 1638}, {20, 16, 0, 3276}, {20, 16, 0, 6553}, {20, 15, 0x1b1ae4d6e2ef4fL, 1310}, {21, 16, 0, 2621}, {21, 16, 0, 5242}, {21, 15, 0, 1048}, {21, 15, 0x10f0cf064dd591L, 2097}, {22, 16, 0, 4194}, {22, 16, 0, 8388}, {22, 15, 0x152d02c7e14af6L, 1677}, {23, 16, 0, 3355}, {23, 16, 0, 6710}, {23, 15, 0x1a784379d99db4L, 1342}, {24, 16, 0, 2684}, {24, 16, 0, 5368}, {24, 15, 0, 1073}, {24, 15, 0x108b2a2c280290L, 2147}, {25, 16, 0, 4294}, {25, 16, 0, 8589}, {25, 15, 0x14adf4b7320334L, 1717}, {26, 16, 0, 3435}, {26, 16, 0, 6871}, {26, 15, 0x19d971e4fe8401L, 1374}, {27, 16, 0, 2748}, {27, 16, 0, 5497}, {27, 15, 0, 1099}, {27, 15, 0x1027e72f1f1281L, 2199}, {28, 16, 0, 4398}, {28, 16, 0, 8796}, {28, 15, 0x1431e0fae6d721L, 1759}, {29, 16, 0, 3518}, {29, 16, 0, 7036}, {29, 15, 0x193e5939a08ce9L, 1407}, {30, 16, 0, 2814}, {30, 16, 0, 5629}, {30, 15, 0x1f8def8808b024L, 1125}, {31, 16, 0, 2251}, {31, 16, 0, 4503}, {31, 16, 0, 9007}, {31, 15, 0x13b8b5b5056e16L, 1801}, {32, 16, 0, 3602}, {32, 16, 0, 7205}, {32, 15, 0x18a6e32246c99cL, 1441}, {33, 16, 0, 2882}, {33, 16, 0, 5764}, {33, 15, 0x1ed09bead87c03L, 1152}, {34, 16, 0, 2305}, {34, 16, 0, 4611}, {34, 16, 0, 9223}, {34, 15, 0x13426172c74d82L, 1844}, {35, 16, 0, 3689}, {35, 16, 0, 7378}, {35, 15, 0x1812f9cf7920e2L, 1475}, {36, 16, 0, 2951}, {36, 16, 0, 5902}, {36, 15, 0x1e17b84357691bL, 1180}, {37, 16, 0, 2361}, {37, 16, 0, 4722}, {37, 16, 0, 9444}, {37, 15, 0x12ced32a16a1b1L, 1888}, {38, 16, 0, 3777}, {38, 16, 0, 7555}, {38, 15, 0x178287f49c4a1dL, 1511}, {39, 16, 0, 3022}, {39, 16, 0, 6044}, {39, 15, 0x1d6329f1c35ca4L, 1208}, {40, 16, 0, 2417}, {40, 16, 0, 4835}, {40, 16, 0, 9671}, {40, 15, 0x125dfa371a19e6L, 1934}, {41, 16, 0, 3868}, {41, 16, 0, 7737}, {41, 15, 0x16f578c4e0a060L, 1547}, {42, 16, 0, 3094}, {42, 16, 0, 6189}, {42, 15, 0x1cb2d6f618c878L, 1237}, {43, 16, 0, 2475}, {43, 16, 0, 4951}, {43, 16, 0, 9903}, {43, 15, 0x11efc659cf7d4bL, 1980}, {44, 16, 0, 3961}, {44, 16, 0, 7922}, {44, 15, 0x166bb7f0435c9eL, 1584}, {45, 16, 0, 3169}, {45, 16, 0, 6338}, {45, 15, 0x1c06a5ec5433c6L, 1267}, {46, 16, 0, 2535}, {46, 16, 0, 5070}, {46, 15, 0, 1014}, {46, 15, 0x118427b3b4a05bL, 2028}, {47, 16, 0, 4056}, {47, 16, 0, 8112}, {47, 15, 0x15e531a0a1c872L, 1622}, {48, 16, 0, 3245}, {48, 16, 0, 6490}, {48, 15, 0x1b5e7e08ca3a8fL, 1298}, {49, 16, 0, 2596}, {49, 16, 0, 5192}, {49, 15, 0, 1038}, {49, 15, 0x111b0ec57e6499L, 2076}, {50, 16, 0, 4153}, {50, 16, 0, 8307}, {50, 15, 0x1561d276ddfdc0L, 1661}, {51, 16, 0, 3323}, {51, 16, 0, 6646}, {51, 15, 0x1aba4714957d30L, 1329}, {52, 16, 0, 2658}, {52, 16, 0, 5316}, {52, 15, 0, 1063}, {52, 15, 0x10b46c6cdd6e3eL, 2126}, {53, 16, 0, 4253}, {53, 16, 0, 8507}, {53, 15, 0x14e1878814c9cdL, 1701}, {54, 16, 0, 3402}, {54, 16, 0, 6805}, {54, 15, 0x1a19e96a19fc40L, 1361}, {55, 16, 0, 2722}, {55, 16, 0, 5444}, {55, 15, 0, 1088}, {55, 15, 0x105031e2503da8L, 2177}, {56, 16, 0, 4355}, {56, 16, 0, 8711}, {56, 15, 0x14643e5ae44d12L, 1742}, {57, 16, 0, 3484}, {57, 16, 0, 6968}, {57, 15, 0x197d4df19d6057L, 1393}, {58, 16, 0, 2787}, {58, 16, 0, 5575}, {58, 15, 0x1fdca16e04b86dL, 1115}, {59, 16, 0, 2230}, {59, 16, 0, 4460}, {59, 16, 0, 8920}, {59, 15, 0x13e9e4e4c2f344L, 1784}, {60, 16, 0, 3568}, {60, 16, 0, 7136}, {60, 15, 0x18e45e1df3b015L, 1427}, {61, 16, 0, 2854}, {61, 16, 0, 5708}, {61, 15, 0x1f1d75a5709c1aL, 1141}, {62, 16, 0, 2283}, {62, 16, 0, 4567}, {62, 16, 0, 9134}, {62, 15, 0x13726987666190L, 1826}, {63, 16, 0, 3653}, {63, 16, 0, 7307}, {63, 15, 0x184f03e93ff9f4L, 1461}, {64, 16, 0, 2923}, {64, 16, 0, 5846}, {64, 15, 0x1e62c4e38ff872L, 1169}, {65, 16, 0, 2338}, {65, 16, 0, 4676}, {65, 16, 0, 9353}, {65, 15, 0x12fdbb0e39fb47L, 1870}, {66, 16, 0, 3741}, {66, 16, 0, 7482}, {66, 15, 0x17bd29d1c87a19L, 1496}, {67, 16, 0, 2993}, {67, 16, 0, 5986}, {67, 15, 0x1dac74463a989fL, 1197}, {68, 16, 0, 2394}, {68, 16, 0, 4789}, {68, 16, 0, 9578}, {68, 15, 0x128bc8abe49f63L, 1915}, {69, 16, 0, 3831}, {69, 16, 0, 7662}, {69, 15, 0x172ebad6ddc73cL, 1532}, {70, 16, 0, 3064}, {70, 16, 0, 6129}, {70, 15, 0x1cfa698c95390bL, 1225}, {71, 16, 0, 2451}, {71, 16, 0, 4903}, {71, 16, 0, 9807}, {71, 15, 0x121c81f7dd43a7L, 1961}, {72, 16, 0, 3923}, {72, 16, 0, 7846}, {72, 15, 0x16a3a275d49491L, 1569}, {73, 16, 0, 3138}, {73, 16, 0, 6277}, {73, 15, 0x1c4c8b1349b9b5L, 1255}, {74, 16, 0, 2510}, {74, 16, 0, 5021}, {74, 15, 0, 1004}, {74, 15, 0x11afd6ec0e1411L, 2008}, {75, 16, 0, 4017}, {75, 16, 0, 8034}, {75, 15, 0x161bcca7119915L, 1606}, {76, 16, 0, 3213}, {76, 16, 0, 6427}, {76, 15, 0x1ba2bfd0d5ff5bL, 1285}, {77, 16, 0, 2571}, {77, 16, 0, 5142}, {77, 15, 0, 1028}, {77, 15, 0x1145b7e285bf98L, 2056}, {78, 16, 0, 4113}, {78, 16, 0, 8227}, {78, 15, 0x159725db272f7fL, 1645}, {79, 16, 0, 3291}, {79, 16, 0, 6582}, {79, 15, 0x1afcef51f0fb5eL, 1316}, {80, 16, 0, 2632}, {80, 16, 0, 5265}, {80, 15, 0, 1053}, {80, 15, 0x10de1593369d1bL, 2106}, {81, 16, 0, 4212}, {81, 16, 0, 8424}, {81, 15, 0x15159af8044462L, 1684}, {82, 16, 0, 3369}, {82, 16, 0, 6739}, {82, 15, 0x1a5b01b605557aL, 1347}, {83, 16, 0, 2695}, {83, 16, 0, 5391}, {83, 15, 0, 1078}, {83, 15, 0x1078e111c3556cL, 2156}, {84, 16, 0, 4313}, {84, 16, 0, 8627}, {84, 15, 0x14971956342ac7L, 1725}, {85, 16, 0, 3450}, {85, 16, 0, 6901}, {85, 15, 0x19bcdfabc13579L, 1380}, {86, 16, 0, 2760}, {86, 16, 0, 5521}, {86, 15, 0, 1104}, {86, 15, 0x10160bcb58c16cL, 2208}, {87, 16, 0, 4417}, {87, 16, 0, 8834}, {87, 15, 0x141b8ebe2ef1c7L, 1766}, {88, 16, 0, 3533}, {88, 16, 0, 7067}, {88, 15, 0x1922726dbaae39L, 1413}, {89, 16, 0, 2826}, {89, 16, 0, 5653}, {89, 15, 0x1f6b0f092959c7L, 1130}, {90, 16, 0, 2261}, {90, 16, 0, 4523}, {90, 16, 0, 9046}, {90, 15, 0x13a2e965b9d81cL, 1809}, {91, 16, 0, 3618}, {91, 16, 0, 7237}, {91, 15, 0x188ba3bf284e23L, 1447}, {92, 16, 0, 2894}, {92, 16, 0, 5789}, {92, 15, 0x1eae8caef261acL, 1157}, {93, 16, 0, 2315}, {93, 16, 0, 4631}, {93, 16, 0, 9263}, {93, 15, 0x132d17ed577d0bL, 1852}, {94, 16, 0, 3705}, {94, 16, 0, 7410}, {94, 15, 0x17f85de8ad5c4eL, 1482}, {95, 16, 0, 2964}, {95, 16, 0, 5928}, {95, 15, 0x1df67562d8b362L, 1185}, {96, 16, 0, 2371}, {96, 16, 0, 4742}, {96, 16, 0, 9485}, {96, 15, 0x12ba095dc7701dL, 1897}, {97, 16, 0, 3794}, {97, 16, 0, 7588}, {97, 15, 0x17688bb5394c25L, 1517}, {98, 16, 0, 3035}, {98, 16, 0, 6070}, {98, 15, 0x1d42aea2879f2eL, 1214}, {99, 16, 0, 2428}, {99, 16, 0, 4856}, {99, 16, 0, 9713}, {99, 15, 0x1249ad2594c37cL, 1942}, {100, 16, 0, 3885}, {100, 16, 0, 7770}, {100, 15, 0x16dc186ef9f45cL, 1554}, {101, 16, 0, 3108}, {101, 16, 0, 6216}, {101, 15, 0x1c931e8ab87173L, 1243}, {102, 16, 0, 2486}, {102, 16, 0, 4973}, {102, 16, 0, 9946}, {102, 15, 0x11dbf316b346e7L, 1989}, {103, 16, 0, 3978}, {103, 16, 0, 7957}, {103, 15, 0x1652efdc6018a1L, 1591}, {104, 16, 0, 3182}, {104, 16, 0, 6365}, {104, 15, 0x1be7abd3781ecaL, 1273}, {105, 16, 0, 2546}, {105, 16, 0, 5092}, {105, 15, 0, 1018}, {105, 15, 0x1170cb642b133eL, 2037}, {106, 16, 0, 4074}, {106, 16, 0, 8148}, {106, 15, 0x15ccfe3d35d80eL, 1629}, {107, 16, 0, 3259}, {107, 16, 0, 6518}, {107, 15, 0x1b403dcc834e11L, 1303}, {108, 16, 0, 2607}, {108, 16, 0, 5214}, {108, 15, 0, 1042}, {108, 15, 0x1108269fd210cbL, 2085}, {109, 16, 0, 4171}, {109, 16, 0, 8343}, {109, 15, 0x154a3047c694fdL, 1668}, {110, 16, 0, 3337}, {110, 16, 0, 6674}, {110, 15, 0x1a9cbc59b83a3dL, 1334}, {111, 16, 0, 2669}, {111, 16, 0, 5339}, {111, 15, 0, 1067}, {111, 15, 0x10a1f5b8132466L, 2135}, {112, 16, 0, 4271}, {112, 16, 0, 8543}, {112, 15, 0x14ca732617ed7fL, 1708}, {113, 16, 0, 3417}, {113, 16, 0, 6835}, {113, 15, 0x19fd0fef9de8dfL, 1367}, {114, 16, 0, 2734}, {114, 16, 0, 5468}, {114, 15, 0, 1093}, {114, 15, 0x103e29f5c2b18bL, 2187}, {115, 16, 0, 4374}, {115, 16, 0, 8749}, {115, 15, 0x144db473335deeL, 1749}, {116, 16, 0, 3499}, {116, 16, 0, 6999}, {116, 15, 0x1961219000356aL, 1399}, {117, 16, 0, 2799}, {117, 16, 0, 5599}, {117, 15, 0x1fb969f40042c5L, 1119}, {118, 16, 0, 2239}, {118, 16, 0, 4479}, {118, 16, 0, 8958}, {118, 15, 0x13d3e2388029bbL, 1791}, {119, 16, 0, 3583}, {119, 16, 0, 7167}, {119, 15, 0x18c8dac6a0342aL, 1433}, {120, 16, 0, 2866}, {120, 16, 0, 5733}, {120, 15, 0x1efb1178484134L, 1146}, {121, 16, 0, 2293}, {121, 16, 0, 4586}, {121, 16, 0, 9173}, {121, 15, 0x135ceaeb2d28c0L, 1834}, {122, 16, 0, 3669}, {122, 16, 0, 7339}, {122, 15, 0x183425a5f872f1L, 1467}, {123, 16, 0, 2935}, {123, 16, 0, 5871}, {123, 15, 0x1e412f0f768fadL, 1174}, {124, 16, 0, 2348}, {124, 16, 0, 4697}, {124, 16, 0, 9394}, {124, 15, 0x12e8bd69aa19ccL, 1878}, {125, 16, 0, 3757}, {125, 16, 0, 7515}, {125, 15, 0x17a2ecc414a03fL, 1503}, {126, 16, 0, 3006}, {126, 16, 0, 6012}, {126, 15, 0x1d8ba7f519c84fL, 1202}, {127, 16, 0, 2404}, {127, 16, 0, 4809}, {127, 16, 0, 9619}, {127, 15, 0x127748f9301d31L, 1923}, {128, 16, 0, 3847}, {128, 16, 0, 7695}, {128, 15, 0x17151b377c247eL, 1539}, {129, 16, 0, 3078}, {129, 16, 0, 6156}, {129, 15, 0x1cda62055b2d9dL, 1231}, {130, 16, 0, 2462}, {130, 16, 0, 4925}, {130, 16, 0, 9850}, {130, 15, 0x12087d4358fc82L, 1970}, {131, 16, 0, 3940}, {131, 16, 0, 7880}, {131, 15, 0x168a9c942f3ba3L, 1576}, {132, 16, 0, 3152}, {132, 16, 0, 6304}, {132, 15, 0x1c2d43b93b0a8bL, 1260}, {133, 16, 0, 2521}, {133, 16, 0, 5043}, {133, 15, 0, 1008}, {133, 15, 0x119c4a53c4e697L, 2017}, {134, 16, 0, 4034}, {134, 16, 0, 8069}, {134, 15, 0x16035ce8b6203dL, 1613}, {135, 16, 0, 3227}, {135, 16, 0, 6455}, {135, 15, 0x1b843422e3a84cL, 1291}, {136, 16, 0, 2582}, {136, 16, 0, 5164}, {136, 15, 0, 1032}, {136, 15, 0x1132a095ce492fL, 2065}, {137, 16, 0, 4131}, {137, 16, 0, 8263}, {137, 15, 0x157f48bb41db7bL, 1652}, {138, 16, 0, 3305}, {138, 16, 0, 6610}, {138, 15, 0x1adf1aea12525aL, 1322}, {139, 16, 0, 2644}, {139, 16, 0, 5288}, {139, 15, 0, 1057}, {139, 15, 0x10cb70d24b7378L, 2115}, {140, 16, 0, 4230}, {140, 16, 0, 8461}, {140, 15, 0x14fe4d06de5056L, 1692}, {141, 16, 0, 3384}, {141, 16, 0, 6769}, {141, 15, 0x1a3de04895e46cL, 1353}, {142, 16, 0, 2707}, {142, 16, 0, 5415}, {142, 15, 0, 1083}, {142, 15, 0x1066ac2d5daec3L, 2166}, {143, 16, 0, 4332}, {143, 16, 0, 8664}, {143, 15, 0x14805738b51a74L, 1732}, {144, 16, 0, 3465}, {144, 16, 0, 6931}, {144, 15, 0x19a06d06e26112L, 1386}, {145, 16, 0, 2772}, {145, 16, 0, 5545}, {145, 15, 0, 1109}, {145, 15, 0x100444244d7cabL, 2218}, {146, 16, 0, 4436}, {146, 16, 0, 8872}, {146, 15, 0x1405552d60dbd6L, 1774}, {147, 16, 0, 3549}, {147, 16, 0, 7098}, {147, 15, 0x1906aa78b912cbL, 1419}, {148, 16, 0, 2839}, {148, 16, 0, 5678}, {148, 15, 0x1f485516e7577eL, 1135}, {149, 16, 0, 2271}, {149, 16, 0, 4542}, {149, 16, 0, 9085}, {149, 15, 0x138d352e5096afL, 1817}, {150, 16, 0, 3634}, {150, 16, 0, 7268}, {150, 15, 0x18708279e4bc5aL, 1453}, {151, 16, 0, 2907}, {151, 16, 0, 5814}, {151, 15, 0x1e8ca3185deb71L, 1162}, {152, 16, 0, 2325}, {152, 16, 0, 4651}, {152, 16, 0, 9303}, {152, 15, 0x1317e5ef3ab327L, 1860}, {153, 16, 0, 3721}, {153, 16, 0, 7442}, {153, 15, 0x17dddf6b095ff0L, 1488}, {154, 16, 0, 2977}, {154, 16, 0, 5954}, {154, 15, 0x1dd55745cbb7ecL, 1190}, {155, 16, 0, 2381}, {155, 16, 0, 4763}, {155, 16, 0, 9526}, {155, 15, 0x12a5568b9f52f4L, 1905}, {156, 16, 0, 3810}, {156, 16, 0, 7621}, {156, 15, 0x174eac2e8727b1L, 1524}, {157, 16, 0, 3048}, {157, 16, 0, 6097}, {157, 15, 0x1d22573a28f19dL, 1219}, {158, 16, 0, 2438}, {158, 16, 0, 4877}, {158, 16, 0, 9755}, {158, 15, 0x12357684599702L, 1951}, {159, 16, 0, 3902}, {159, 16, 0, 7804}, {159, 15, 0x16c2d4256ffcc2L, 1560}, {160, 16, 0, 3121}, {160, 16, 0, 6243}, {160, 15, 0x1c73892ecbfbf3L, 1248}, {161, 16, 0, 2497}, {161, 16, 0, 4994}, {161, 16, 0, 9989}, {161, 15, 0x11c835bd3f7d78L, 1997}, {162, 16, 0, 3995}, {162, 16, 0, 7991}, {162, 15, 0x163a432c8f5cd6L, 1598}, {163, 16, 0, 3196}, {163, 16, 0, 6393}, {163, 15, 0x1bc8d3f7b3340bL, 1278}, {164, 16, 0, 2557}, {164, 16, 0, 5114}, {164, 15, 0, 1022}, {164, 15, 0x115d847ad00087L, 2045}, {165, 16, 0, 4091}, {165, 16, 0, 8183}, {165, 15, 0x15b4e5998400a9L, 1636}, {166, 16, 0, 3273}, {166, 16, 0, 6546}, {166, 15, 0x1b221effe500d3L, 1309}, {167, 16, 0, 2618}, {167, 16, 0, 5237}, {167, 15, 0, 1047}, {167, 15, 0x10f5535fef2084L, 2094}, {168, 16, 0, 4189}, {168, 16, 0, 8379}, {168, 15, 0x1532a837eae8a5L, 1675}, {169, 16, 0, 3351}, {169, 16, 0, 6703}, {169, 15, 0x1a7f5245e5a2ceL, 1340}, {170, 16, 0, 2681}, {170, 16, 0, 5363}, {170, 15, 0, 1072}, {170, 15, 0x108f936baf85c1L, 2145}, {171, 16, 0, 4290}, {171, 16, 0, 8580}, {171, 15, 0x14b378469b6731L, 1716}, {172, 16, 0, 3432}, {172, 16, 0, 6864}, {172, 15, 0x19e056584240fdL, 1372}, {173, 16, 0, 2745}, {173, 16, 0, 5491}, {173, 15, 0, 1098}, {173, 15, 0x102c35f729689eL, 2196}, {174, 16, 0, 4393}, {174, 16, 0, 8786}, {174, 15, 0x14374374f3c2c6L, 1757}, {175, 16, 0, 3514}, {175, 16, 0, 7029}, {175, 15, 0x1945145230b377L, 1405}, {176, 16, 0, 2811}, {176, 16, 0, 5623}, {176, 15, 0x1f965966bce055L, 1124}, {177, 16, 0, 2249}, {177, 16, 0, 4498}, {177, 16, 0, 8997}, {177, 15, 0x13bdf7e0360c35L, 1799}, {178, 16, 0, 3599}, {178, 16, 0, 7198}, {178, 15, 0x18ad75d8438f43L, 1439}, {179, 16, 0, 2879}, {179, 16, 0, 5758}, {179, 15, 0x1ed8d34e547313L, 1151}, {180, 16, 0, 2303}, {180, 16, 0, 4606}, {180, 16, 0, 9213}, {180, 15, 0x13478410f4c7ecL, 1842}, {181, 16, 0, 3685}, {181, 16, 0, 7371}, {181, 15, 0x1819651531f9e7L, 1474}, {182, 16, 0, 2948}, {182, 16, 0, 5896}, {182, 15, 0x1e1fbe5a7e7861L, 1179}, {183, 16, 0, 2358}, {183, 16, 0, 4717}, {183, 16, 0, 9434}, {183, 15, 0x12d3d6f88f0b3cL, 1886}, {184, 16, 0, 3773}, {184, 16, 0, 7547}, {184, 15, 0x1788ccb6b2ce0cL, 1509}, {185, 16, 0, 3019}, {185, 16, 0, 6038}, {185, 15, 0x1d6affe45f818fL, 1207}, {186, 16, 0, 2415}, {186, 16, 0, 4830}, {186, 16, 0, 9661}, {186, 15, 0x1262dfeebbb0f9L, 1932}, {187, 16, 0, 3864}, {187, 16, 0, 7729}, {187, 15, 0x16fb97ea6a9d37L, 1545}, {188, 16, 0, 3091}, {188, 16, 0, 6183}, {188, 15, 0x1cba7de5054485L, 1236}, {189, 16, 0, 2473}, {189, 16, 0, 4946}, {189, 16, 0, 9893}, {189, 15, 0x11f48eaf234ad3L, 1978}, {190, 16, 0, 3957}, {190, 16, 0, 7914}, {190, 15, 0x1671b25aec1d88L, 1582}, {191, 16, 0, 3165}, {191, 16, 0, 6331}, {191, 15, 0x1c0e1ef1a724eaL, 1266}, {192, 16, 0, 2532}, {192, 16, 0, 5065}, {192, 15, 0, 1013}, {192, 15, 0x1188d357087712L, 2026}, {193, 16, 0, 4052}, {193, 16, 0, 8104}, {193, 15, 0x15eb082cca94d7L, 1620}, {194, 16, 0, 3241}, {194, 16, 0, 6483}, {194, 15, 0x1b65ca37fd3a0dL, 1296}, {195, 16, 0, 2593}, {195, 16, 0, 5186}, {195, 15, 0, 1037}, {195, 15, 0x111f9e62fe4448L, 2074}, {196, 16, 0, 4149}, {196, 16, 0, 8299}, {196, 15, 0x156785fbbdd55aL, 1659}, {197, 16, 0, 3319}, {197, 16, 0, 6639}, {197, 15, 0x1ac1677aad4ab0L, 1327}, {198, 16, 0, 2655}, {198, 16, 0, 5311}, {198, 15, 0, 1062}, {198, 15, 0x10b8e0acac4eaeL, 2124}, {199, 16, 0, 4249}, {199, 16, 0, 8498}, {199, 15, 0x14e718d7d7625aL, 1699}, {200, 16, 0, 3399}, {200, 16, 0, 6798}, {200, 15, 0x1a20df0dcd3af0L, 1359}, {201, 16, 0, 2719}, {201, 16, 0, 5438}, {201, 15, 0, 1087}, {201, 15, 0x10548b68a044d6L, 2175}, {202, 16, 0, 4351}, {202, 16, 0, 8702}, {202, 15, 0x1469ae42c8560cL, 1740}, {203, 16, 0, 3480}, {203, 16, 0, 6961}, {203, 15, 0x198419d37a6b8fL, 1392}, {204, 16, 0, 2784}, {204, 16, 0, 5569}, {204, 15, 0x1fe52048590672L, 1113}, {205, 16, 0, 2227}, {205, 16, 0, 4455}, {205, 16, 0, 8911}, {205, 15, 0x13ef342d37a407L, 1782}, {206, 16, 0, 3564}, {206, 16, 0, 7128}, {206, 15, 0x18eb0138858d09L, 1425}, {207, 16, 0, 2851}, {207, 16, 0, 5703}, {207, 15, 0x1f25c186a6f04cL, 1140}, {208, 16, 0, 2281}, {208, 16, 0, 4562}, {208, 16, 0, 9124}, {208, 15, 0x137798f428562fL, 1824}, {209, 16, 0, 3649}, {209, 16, 0, 7299}, {209, 15, 0x18557f31326bbbL, 1459}, {210, 16, 0, 2919}, {210, 16, 0, 5839}, {210, 15, 0x1e6adefd7f06aaL, 1167}, {211, 16, 0, 2335}, {211, 16, 0, 4671}, {211, 16, 0, 9343}, {211, 15, 0x1302cb5e6f642aL, 1868}, {212, 16, 0, 3737}, {212, 16, 0, 7475}, {212, 15, 0x17c37e360b3d35L, 1495}, {213, 16, 0, 2990}, {213, 16, 0, 5980}, {213, 15, 0x1db45dc38e0c82L, 1196}, {214, 16, 0, 2392}, {214, 16, 0, 4784}, {214, 16, 0, 9568}, {214, 15, 0x1290ba9a38c7d1L, 1913}, {215, 16, 0, 3827}, {215, 16, 0, 7654}, {215, 15, 0x1734e940c6f9c5L, 1530}, {216, 16, 0, 3061}, {216, 16, 0, 6123}, {216, 15, 0x1d022390f8b837L, 1224}, {217, 16, 0, 2449}, {217, 16, 0, 4898}, {217, 16, 0, 9797}, {217, 15, 0x1221563a9b7322L, 1959}, {218, 16, 0, 3919}, {218, 16, 0, 7838}, {218, 15, 0x16a9abc9424febL, 1567}, {219, 16, 0, 3135}, {219, 16, 0, 6270}, {219, 15, 0x1c5416bb92e3e6L, 1254}, {220, 16, 0, 2508}, {220, 16, 0, 5016}, {220, 15, 0, 1003}, {220, 15, 0x11b48e353bce6fL, 2006}, {221, 16, 0, 4013}, {221, 16, 0, 8026}, {221, 15, 0x1621b1c28ac20bL, 1605}, {222, 16, 0, 3210}, {222, 16, 0, 6421}, {222, 15, 0x1baa1e332d728eL, 1284}, {223, 16, 0, 2568}, {223, 16, 0, 5136}, {223, 15, 0, 1027}, {223, 15, 0x114a52dffc6799L, 2054}, {224, 16, 0, 4109}, {224, 16, 0, 8218}, {224, 15, 0x159ce797fb817fL, 1643}, {225, 16, 0, 3287}, {225, 16, 0, 6575}, {225, 15, 0x1b04217dfa61dfL, 1315}, {226, 16, 0, 2630}, {226, 16, 0, 5260}, {226, 15, 0, 1052}, {226, 15, 0x10e294eebc7d2bL, 2104}, {227, 16, 0, 4208}, {227, 16, 0, 8416}, {227, 15, 0x151b3a2a6b9c76L, 1683}, {228, 16, 0, 3366}, {228, 16, 0, 6732}, {228, 15, 0x1a6208b5068394L, 1346}, {229, 16, 0, 2693}, {229, 16, 0, 5386}, {229, 15, 0, 1077}, {229, 15, 0x107d457124123cL, 2154}, {230, 16, 0, 4309}, {230, 16, 0, 8618}, {230, 15, 0x149c96cd6d16cbL, 1723}, {231, 16, 0, 3447}, {231, 16, 0, 6894}, {231, 15, 0x19c3bc80c85c7eL, 1378}, {232, 16, 0, 2757}, {232, 16, 0, 5515}, {232, 15, 0, 1103}, {232, 15, 0x101a55d07d39cfL, 2206}, {233, 16, 0, 4412}, {233, 16, 0, 8825}, {233, 15, 0x1420eb449c8842L, 1765}, {234, 16, 0, 3530}, {234, 16, 0, 7060}, {234, 15, 0x19292615c3aa53L, 1412}, {235, 16, 0, 2824}, {235, 16, 0, 5648}, {235, 15, 0x1f736f9b3494e8L, 1129}, {236, 16, 0, 2259}, {236, 16, 0, 4518}, {236, 16, 0, 9036}, {236, 15, 0x13a825c100dd11L, 1807}, {237, 16, 0, 3614}, {237, 16, 0, 7229}, {237, 15, 0x18922f31411455L, 1445}, {238, 16, 0, 2891}, {238, 16, 0, 5783}, {238, 15, 0x1eb6bafd91596bL, 1156}, {239, 16, 0, 2313}, {239, 16, 0, 4626}, {239, 16, 0, 9253}, {239, 15, 0x133234de7ad7e2L, 1850}, {240, 16, 0, 3701}, {240, 16, 0, 7402}, {240, 15, 0x17fec216198ddbL, 1480}, {241, 16, 0, 2961}, {241, 16, 0, 5922}, {241, 15, 0x1dfe729b9ff152L, 1184}, {242, 16, 0, 2368}, {242, 16, 0, 4737}, {242, 16, 0, 9475}, {242, 15, 0x12bf07a143f6d3L, 1895}, {243, 16, 0, 3790}, {243, 16, 0, 7580}, {243, 15, 0x176ec98994f488L, 1516}, {244, 16, 0, 3032}, {244, 16, 0, 6064}, {244, 15, 0x1d4a7bebfa31aaL, 1212}, {245, 16, 0, 2425}, {245, 16, 0, 4851}, {245, 16, 0, 9703}, {245, 15, 0x124e8d737c5f0aL, 1940}, {246, 16, 0, 3881}, {246, 16, 0, 7762}, {246, 15, 0x16e230d05b76cdL, 1552}, {247, 16, 0, 3105}, {247, 16, 0, 6210}, {247, 15, 0x1c9abd04725480L, 1242}, {248, 16, 0, 2484}, {248, 16, 0, 4968}, {248, 16, 0, 9936}, {248, 15, 0x11e0b622c774d0L, 1987}, {249, 16, 0, 3974}, {249, 16, 0, 7948}, {249, 15, 0x1658e3ab795204L, 1589}, {250, 16, 0, 3179}, {250, 16, 0, 6359}, {250, 15, 0x1bef1c9657a685L, 1271}, {251, 16, 0, 2543}, {251, 16, 0, 5087}, {251, 15, 0, 1017}, {251, 15, 0x117571ddf6c813L, 2034}, {252, 16, 0, 4069}, {252, 16, 0, 8139}, {252, 15, 0x15d2ce55747a18L, 1627}, {253, 16, 0, 3255}, {253, 16, 0, 6511}, {253, 15, 0x1b4781ead1989eL, 1302}, {254, 16, 0, 2604}, {254, 16, 0, 5209}, {254, 15, 0, 1041}, {254, 15, 0x110cb132c2ff63L, 2083}, {255, 16, 0, 4167}, {255, 16, 0, 8335}, {255, 15, 0x154fdd7f73bf3bL, 1667}, {256, 16, 0, 3334}, {256, 16, 0, 6668}, {256, 15, 0x1aa3d4df50af0aL, 1333}, {257, 16, 0, 2667}, {257, 16, 0, 5334}, {257, 15, 0, 1066}, {257, 15, 0x10a6650b926d66L, 2133}, {258, 16, 0, 4267}, {258, 16, 0, 8535}, {258, 15, 0x14cffe4e7708c0L, 1707}, {259, 16, 0, 3414}, {259, 16, 0, 6828}, {259, 15, 0x1a03fde214caf0L, 1365}, {260, 16, 0, 2731}, {260, 16, 0, 5462}, {260, 15, 0, 1092}, {260, 15, 0x10427ead4cfed6L, 2184}, {261, 16, 0, 4369}, {261, 16, 0, 8739}, {261, 15, 0x14531e58a03e8bL, 1747}, {262, 16, 0, 3495}, {262, 16, 0, 6991}, {262, 15, 0x1967e5eec84e2eL, 1398}, {263, 16, 0, 2796}, {263, 16, 0, 5593}, {263, 15, 0x1fc1df6a7a61baL, 1118}, {264, 16, 0, 2237}, {264, 16, 0, 4474}, {264, 16, 0, 8949}, {264, 15, 0x13d92ba28c7d14L, 1789}, {265, 16, 0, 3579}, {265, 16, 0, 7159}, {265, 15, 0x18cf768b2f9c59L, 1431}, {266, 16, 0, 2863}, {266, 16, 0, 5727}, {266, 15, 0x1f03542dfb8370L, 1145}, {267, 16, 0, 2291}, {267, 16, 0, 4582}, {267, 16, 0, 9164}, {267, 15, 0x1362149cbd3226L, 1832}, {268, 16, 0, 3665}, {268, 16, 0, 7331}, {268, 15, 0x183a99c3ec7eafL, 1466}, {269, 16, 0, 2932}, {269, 16, 0, 5865}, {269, 15, 0x1e494034e79e5bL, 1173}, {270, 16, 0, 2346}, {270, 16, 0, 4692}, {270, 16, 0, 9384}, {270, 15, 0x12edc82110c2f9L, 1876}, {271, 16, 0, 3753}, {271, 16, 0, 7507}, {271, 15, 0x17a93a2954f3b7L, 1501}, {272, 16, 0, 3003}, {272, 16, 0, 6006}, {272, 15, 0x1d9388b3aa30a5L, 1201}, {273, 16, 0, 2402}, {273, 16, 0, 4804}, {273, 16, 0, 9609}, {273, 15, 0x127c35704a5e67L, 1921}, {274, 16, 0, 3843}, {274, 16, 0, 7687}, {274, 15, 0x171b42cc5cf601L, 1537}, {275, 16, 0, 3075}, {275, 16, 0, 6150}, {275, 15, 0x1ce2137f743381L, 1230}, {276, 16, 0, 2460}, {276, 16, 0, 4920}, {276, 16, 0, 9840}, {276, 15, 0x120d4c2fa8a030L, 1968}, {277, 16, 0, 3936}, {277, 16, 0, 7872}, {277, 15, 0x16909f3b92c83dL, 1574}, {278, 16, 0, 3148}, {278, 16, 0, 6297}, {278, 15, 0x1c34c70a777a4cL, 1259}, {279, 16, 0, 2519}, {279, 16, 0, 5038}, {279, 15, 0, 1007}, {279, 15, 0x11a0fc668aac6fL, 2015}, {280, 16, 0, 4030}, {280, 16, 0, 8061}, {280, 15, 0x16093b802d578bL, 1612}, {281, 16, 0, 3224}, {281, 16, 0, 6448}, {281, 15, 0x1b8b8a6038ad6eL, 1289}, {282, 16, 0, 2579}, {282, 16, 0, 5159}, {282, 15, 0, 1031}, {282, 15, 0x1137367c236c65L, 2063}, {283, 16, 0, 4127}, {283, 16, 0, 8254}, {283, 15, 0x1585041b2c477eL, 1650}, {284, 16, 0, 3301}, {284, 16, 0, 6603}, {284, 15, 0x1ae64521f7595eL, 1320}, {285, 16, 0, 2641}, {285, 16, 0, 5282}, {285, 15, 0, 1056}, {285, 15, 0x10cfeb353a97daL, 2113}, {286, 16, 0, 4226}, {286, 16, 0, 8452}, {286, 15, 0x1503e602893dd1L, 1690}, {287, 16, 0, 3381}, {287, 16, 0, 6762}, {287, 15, 0x1a44df832b8d45L, 1352}, {288, 16, 0, 2704}, {288, 16, 0, 5409}, {288, 15, 0, 1081}, {288, 15, 0x106b0bb1fb384bL, 2163}, {289, 16, 0, 4327}, {289, 16, 0, 8655}, {289, 15, 0x1485ce9e7a065eL, 1731}, {290, 16, 0, 3462}, {290, 16, 0, 6924}, {290, 15, 0x19a742461887f6L, 1384}, {291, 16, 0, 2769}, {291, 16, 0, 5539}, {291, 15, 0, 1107}, {291, 15, 0x1008896bcf54f9L, 2215}, {292, 16, 0, 4431}, {292, 16, 0, 8863}, {292, 15, 0x140aabc6c32a38L, 1772}, {293, 16, 0, 3545}, {293, 16, 0, 7090}, {293, 15, 0x190d56b873f4c6L, 1418}, {294, 16, 0, 2836}, {294, 16, 0, 5672}, {294, 15, 0x1f50ac6690f1f8L, 1134}, {295, 16, 0, 2269}, {295, 16, 0, 4538}, {295, 16, 0, 9076}, {295, 15, 0x13926bc01a973bL, 1815}, {296, 16, 0, 3630}, {296, 16, 0, 7260}, {296, 15, 0x187706b0213d09L, 1452}, {297, 16, 0, 2904}, {297, 16, 0, 5808}, {297, 15, 0x1e94c85c298c4cL, 1161}, {298, 16, 0, 2323}, {298, 16, 0, 4646}, {298, 16, 0, 9293}, {298, 15, 0x131cfd3999f7afL, 1858}, {299, 16, 0, 3717}, {299, 16, 0, 7435}, {299, 15, 0x17e43c8800759bL, 1487}, {300, 16, 0, 2974}, {300, 16, 0, 5948}, {300, 15, 0x1ddd4baa009302L, 1189}, {301, 16, 0, 2379}, {301, 16, 0, 4758}, {301, 16, 0, 9516}, {301, 15, 0x12aa4f4a405be1L, 1903}, {302, 16, 0, 3806}, {302, 16, 0, 7613}, {302, 15, 0x1754e31cd072d9L, 1522}, {303, 16, 0, 3045}, {303, 16, 0, 6090}, {303, 15, 0x1d2a1be4048f90L, 1218}, {304, 16, 0, 2436}, {304, 16, 0, 4872}, {304, 16, 0, 9745}, {304, 15, 0x123a516e82d9baL, 1949}, {305, 16, 0, 3898}, {305, 16, 0, 7796}, {305, 15, 0x16c8e5ca239028L, 1559}, {306, 16, 0, 3118}, {306, 16, 0, 6237}, {306, 15, 0x1c7b1f3cac7433L, 1247}, {307, 16, 0, 2494}, {307, 16, 0, 4989}, {307, 16, 0, 9979}, {307, 15, 0x11ccf385ebc89fL, 1995}};
        for (int i = 0; i < e5datas.length; ++i) {
            E5_D_A[i] = e5datas[i] == null ? null : new ED(e5datas[i]);
        }
        for (int i = 0; i < e2datas.length; ++i) {
            E2_D_A[i] = new ED(e2datas[i]);
        }
    }
}
