/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.beans.factory.annotation;

import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.spring.beans.factory.annotation.AbstractNacosServiceBeanBuilder;
import com.alibaba.spring.beans.factory.annotation.AnnotationInjectedBeanPostProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class AnnotationNacosInjectedBeanPostProcessor
extends AnnotationInjectedBeanPostProcessor<NacosInjected>
implements InitializingBean {
    public static final String BEAN_NAME = "annotationNacosInjectedBeanPostProcessor";
    private Map<Class<?>, AbstractNacosServiceBeanBuilder> nacosServiceBeanBuilderMap;

    public final void afterPropertiesSet() throws Exception {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        this.initNacosServiceBeanBuilderMap(beanFactory);
    }

    private void initNacosServiceBeanBuilderMap(ConfigurableListableBeanFactory beanFactory) {
        Class<AbstractNacosServiceBeanBuilder> builderClass = AbstractNacosServiceBeanBuilder.class;
        Collection serviceBeanBuilders = beanFactory.getBeansOfType(builderClass).values();
        if (serviceBeanBuilders.isEmpty()) {
            throw new NoSuchBeanDefinitionException(builderClass, String.format("Please check the BeanDefinition of %s in Spring BeanFactory", builderClass));
        }
        HashMap builderMap = new HashMap(serviceBeanBuilders.size());
        for (AbstractNacosServiceBeanBuilder serviceBeanBuilder : serviceBeanBuilders) {
            Class<?> type = serviceBeanBuilder.getType();
            builderMap.put(type, serviceBeanBuilder);
        }
        this.nacosServiceBeanBuilderMap = Collections.unmodifiableMap(builderMap);
    }

    protected Object doGetInjectedBean(NacosInjected annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        AbstractNacosServiceBeanBuilder serviceBeanBuilder = this.nacosServiceBeanBuilderMap.get(injectedType);
        return serviceBeanBuilder.build(annotation.properties());
    }

    protected String buildInjectedObjectCacheKey(NacosInjected annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        StringBuilder keyBuilder = new StringBuilder(injectedType.getSimpleName());
        AbstractNacosServiceBeanBuilder serviceBeanBuilder = this.nacosServiceBeanBuilderMap.get(injectedType);
        if (serviceBeanBuilder == null) {
            throw new UnsupportedOperationException(String.format("Only support to inject types[%s] instance , however actual injected type [%s] in member[%s]", this.nacosServiceBeanBuilderMap.keySet(), injectedType, injectedElement.getMember()));
        }
        Properties properties = serviceBeanBuilder.resolveProperties(annotation.properties());
        keyBuilder.append(properties);
        return keyBuilder.toString();
    }
}

