/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.manager.model;

import com.alibaba.otter.canal.common.utils.CanalToStringStyle;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CanalParameter
implements Serializable {
    private static final long serialVersionUID = -5893459662315430900L;
    private Long canalId;
    private RunMode runMode = RunMode.EMBEDDED;
    private ClusterMode clusterMode = ClusterMode.STANDALONE;
    private Long zkClusterId;
    private List<String> zkClusters;
    private MetaMode metaMode = MetaMode.MEMORY;
    private Integer transactionSize = 1024;
    private StorageMode storageMode = StorageMode.MEMORY;
    private BatchMode storageBatchMode = BatchMode.MEMSIZE;
    private Integer memoryStorageBufferSize = 16384;
    private Integer memoryStorageBufferMemUnit = 1024;
    private String fileStorageDirectory;
    private Integer fileStorageStoreCount;
    private Integer fileStorageRollverCount;
    private Integer fileStoragePercentThresold;
    private StorageScavengeMode storageScavengeMode = StorageScavengeMode.ON_ACK;
    private String scavengeSchdule;
    private SourcingType sourcingType = SourcingType.MYSQL;
    private String localBinlogDirectory;
    private HAMode haMode = HAMode.HEARTBEAT;
    private Integer port = 11111;
    private Integer defaultConnectionTimeoutInSeconds = 30;
    private Integer receiveBufferSize = 65536;
    private Integer sendBufferSize = 65536;
    private Byte connectionCharsetNumber = 33;
    private String connectionCharset = "UTF-8";
    private List<InetSocketAddress> dbAddresses;
    private List<List<DataSourcing>> groupDbAddresses;
    private String dbUsername;
    private String dbPassword;
    private IndexMode indexMode;
    private List<String> positions;
    private String defaultDatabaseName;
    private Long slaveId;
    private Integer fallbackIntervalInSeconds = 60;
    private Boolean detectingEnable = true;
    private Boolean heartbeatHaEnable = false;
    private String detectingSQL;
    private Integer detectingIntervalInSeconds = 3;
    private Integer detectingTimeoutThresholdInSeconds = 30;
    private Integer detectingRetryTimes = 3;
    private String app;
    private String group;
    private String mediaGroup;
    private String metaqStoreUri;
    private Boolean ddlIsolation = Boolean.FALSE;
    private Boolean filterTableError = Boolean.FALSE;
    private String blackFilter = null;
    private InetSocketAddress masterAddress;
    private String masterUsername;
    private String masterPassword;
    private InetSocketAddress standbyAddress;
    private String standbyUsername;
    private String standbyPassword;
    private String masterLogfileName = null;
    private Long masterLogfileOffest = null;
    private Long masterTimestamp = null;
    private String standbyLogfileName = null;
    private Long standbyLogfileOffest = null;
    private Long standbyTimestamp = null;

    public Long getCanalId() {
        return this.canalId;
    }

    public void setCanalId(Long canalId) {
        this.canalId = canalId;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public ClusterMode getClusterMode() {
        return this.clusterMode;
    }

    public void setClusterMode(ClusterMode clusterMode) {
        this.clusterMode = clusterMode;
    }

    public List<String> getZkClusters() {
        return this.zkClusters;
    }

    public void setZkClusters(List<String> zkClusters) {
        this.zkClusters = zkClusters;
    }

    public MetaMode getMetaMode() {
        return this.metaMode;
    }

    public void setMetaMode(MetaMode metaMode) {
        this.metaMode = metaMode;
    }

    public StorageMode getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(StorageMode storageMode) {
        this.storageMode = storageMode;
    }

    public Integer getMemoryStorageBufferSize() {
        return this.memoryStorageBufferSize;
    }

    public void setMemoryStorageBufferSize(Integer memoryStorageBufferSize) {
        this.memoryStorageBufferSize = memoryStorageBufferSize;
    }

    public String getFileStorageDirectory() {
        return this.fileStorageDirectory;
    }

    public void setFileStorageDirectory(String fileStorageDirectory) {
        this.fileStorageDirectory = fileStorageDirectory;
    }

    public Integer getFileStorageStoreCount() {
        return this.fileStorageStoreCount;
    }

    public void setFileStorageStoreCount(Integer fileStorageStoreCount) {
        this.fileStorageStoreCount = fileStorageStoreCount;
    }

    public Integer getFileStorageRollverCount() {
        return this.fileStorageRollverCount;
    }

    public void setFileStorageRollverCount(Integer fileStorageRollverCount) {
        this.fileStorageRollverCount = fileStorageRollverCount;
    }

    public Integer getFileStoragePercentThresold() {
        return this.fileStoragePercentThresold;
    }

    public void setFileStoragePercentThresold(Integer fileStoragePercentThresold) {
        this.fileStoragePercentThresold = fileStoragePercentThresold;
    }

    public SourcingType getSourcingType() {
        return this.sourcingType;
    }

    public void setSourcingType(SourcingType sourcingType) {
        this.sourcingType = sourcingType;
    }

    public String getLocalBinlogDirectory() {
        return this.localBinlogDirectory;
    }

    public void setLocalBinlogDirectory(String localBinlogDirectory) {
        this.localBinlogDirectory = localBinlogDirectory;
    }

    public HAMode getHaMode() {
        return this.haMode;
    }

    public void setHaMode(HAMode haMode) {
        this.haMode = haMode;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getDefaultConnectionTimeoutInSeconds() {
        return this.defaultConnectionTimeoutInSeconds;
    }

    public void setDefaultConnectionTimeoutInSeconds(Integer defaultConnectionTimeoutInSeconds) {
        this.defaultConnectionTimeoutInSeconds = defaultConnectionTimeoutInSeconds;
    }

    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public Byte getConnectionCharsetNumber() {
        return this.connectionCharsetNumber;
    }

    public void setConnectionCharsetNumber(Byte connectionCharsetNumber) {
        this.connectionCharsetNumber = connectionCharsetNumber;
    }

    public String getConnectionCharset() {
        return this.connectionCharset;
    }

    public void setConnectionCharset(String connectionCharset) {
        this.connectionCharset = connectionCharset;
    }

    public IndexMode getIndexMode() {
        return this.indexMode;
    }

    public void setIndexMode(IndexMode indexMode) {
        this.indexMode = indexMode;
    }

    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    public void setDefaultDatabaseName(String defaultDatabaseName) {
        this.defaultDatabaseName = defaultDatabaseName;
    }

    public Long getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(Long slaveId) {
        this.slaveId = slaveId;
    }

    public Boolean getDetectingEnable() {
        return this.detectingEnable;
    }

    public void setDetectingEnable(Boolean detectingEnable) {
        this.detectingEnable = detectingEnable;
    }

    public String getDetectingSQL() {
        return this.detectingSQL;
    }

    public void setDetectingSQL(String detectingSQL) {
        this.detectingSQL = detectingSQL;
    }

    public Integer getDetectingIntervalInSeconds() {
        return this.detectingIntervalInSeconds;
    }

    public void setDetectingIntervalInSeconds(Integer detectingIntervalInSeconds) {
        this.detectingIntervalInSeconds = detectingIntervalInSeconds;
    }

    public Integer getDetectingTimeoutThresholdInSeconds() {
        return this.detectingTimeoutThresholdInSeconds;
    }

    public void setDetectingTimeoutThresholdInSeconds(Integer detectingTimeoutThresholdInSeconds) {
        this.detectingTimeoutThresholdInSeconds = detectingTimeoutThresholdInSeconds;
    }

    public Integer getDetectingRetryTimes() {
        return this.detectingRetryTimes;
    }

    public void setDetectingRetryTimes(Integer detectingRetryTimes) {
        this.detectingRetryTimes = detectingRetryTimes;
    }

    public StorageScavengeMode getStorageScavengeMode() {
        return this.storageScavengeMode;
    }

    public void setStorageScavengeMode(StorageScavengeMode storageScavengeMode) {
        this.storageScavengeMode = storageScavengeMode;
    }

    public String getScavengeSchdule() {
        return this.scavengeSchdule;
    }

    public void setScavengeSchdule(String scavengeSchdule) {
        this.scavengeSchdule = scavengeSchdule;
    }

    public String getApp() {
        return this.app;
    }

    public String getGroup() {
        return this.group;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getMetaqStoreUri() {
        return this.metaqStoreUri;
    }

    public void setMetaqStoreUri(String metaqStoreUri) {
        this.metaqStoreUri = metaqStoreUri;
    }

    public Integer getTransactionSize() {
        return this.transactionSize != null ? this.transactionSize : 1024;
    }

    public void setTransactionSize(Integer transactionSize) {
        this.transactionSize = transactionSize;
    }

    public List<InetSocketAddress> getDbAddresses() {
        if (this.dbAddresses == null) {
            this.dbAddresses = new ArrayList<InetSocketAddress>();
            if (this.masterAddress != null) {
                this.dbAddresses.add(this.masterAddress);
            }
            if (this.standbyAddress != null) {
                this.dbAddresses.add(this.standbyAddress);
            }
        }
        return this.dbAddresses;
    }

    public List<List<DataSourcing>> getGroupDbAddresses() {
        if (this.groupDbAddresses == null) {
            this.groupDbAddresses = new ArrayList<List<DataSourcing>>();
            if (this.dbAddresses != null) {
                for (InetSocketAddress address : this.dbAddresses) {
                    ArrayList<DataSourcing> groupAddresses = new ArrayList<DataSourcing>();
                    groupAddresses.add(new DataSourcing(this.sourcingType, address));
                    this.groupDbAddresses.add(groupAddresses);
                }
            } else {
                ArrayList<DataSourcing> groupAddresses;
                if (this.masterAddress != null) {
                    groupAddresses = new ArrayList<DataSourcing>();
                    groupAddresses.add(new DataSourcing(this.sourcingType, this.masterAddress));
                    this.groupDbAddresses.add(groupAddresses);
                }
                if (this.standbyAddress != null) {
                    groupAddresses = new ArrayList();
                    groupAddresses.add(new DataSourcing(this.sourcingType, this.standbyAddress));
                    this.groupDbAddresses.add(groupAddresses);
                }
            }
        }
        return this.groupDbAddresses;
    }

    public void setGroupDbAddresses(List<List<DataSourcing>> groupDbAddresses) {
        this.groupDbAddresses = groupDbAddresses;
    }

    public void setDbAddresses(List<InetSocketAddress> dbAddresses) {
        this.dbAddresses = dbAddresses;
    }

    public String getDbUsername() {
        if (this.dbUsername == null) {
            this.dbUsername = this.masterUsername != null ? this.masterUsername : this.standbyUsername;
        }
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        if (this.dbPassword == null) {
            this.dbPassword = this.masterPassword != null ? this.masterPassword : this.standbyPassword;
        }
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public List<String> getPositions() {
        if (this.positions == null) {
            String standbyPosition;
            this.positions = new ArrayList<String>();
            String masterPosition = this.buildPosition(this.masterLogfileName, this.masterLogfileOffest, this.masterTimestamp);
            if (masterPosition != null) {
                this.positions.add(masterPosition);
            }
            if ((standbyPosition = this.buildPosition(this.standbyLogfileName, this.standbyLogfileOffest, this.standbyTimestamp)) != null) {
                this.positions.add(standbyPosition);
            }
        }
        return this.positions;
    }

    public void setPositions(List<String> positions) {
        this.positions = positions;
    }

    private String buildPosition(String journalName, Long position, Long timestamp) {
        StringBuilder masterBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((String)journalName) || position != null || timestamp != null) {
            masterBuilder.append('{');
            if (StringUtils.isNotEmpty((String)journalName)) {
                masterBuilder.append("\"journalName\":\"").append(journalName).append("\"");
            }
            if (position != null) {
                if (masterBuilder.length() > 1) {
                    masterBuilder.append(",");
                }
                masterBuilder.append("\"position\":").append(position);
            }
            if (timestamp != null) {
                if (masterBuilder.length() > 1) {
                    masterBuilder.append(",");
                }
                masterBuilder.append("\"timestamp\":").append(timestamp);
            }
            masterBuilder.append('}');
            return masterBuilder.toString();
        }
        return null;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public void setMasterPassword(String masterPassword) {
        this.masterPassword = masterPassword;
    }

    public void setStandbyAddress(InetSocketAddress standbyAddress) {
        this.standbyAddress = standbyAddress;
    }

    public void setStandbyUsername(String standbyUsername) {
        this.standbyUsername = standbyUsername;
    }

    public void setStandbyPassword(String standbyPassword) {
        this.standbyPassword = standbyPassword;
    }

    public void setMasterLogfileName(String masterLogfileName) {
        this.masterLogfileName = masterLogfileName;
    }

    public void setMasterLogfileOffest(Long masterLogfileOffest) {
        this.masterLogfileOffest = masterLogfileOffest;
    }

    public void setMasterTimestamp(Long masterTimestamp) {
        this.masterTimestamp = masterTimestamp;
    }

    public void setStandbyLogfileName(String standbyLogfileName) {
        this.standbyLogfileName = standbyLogfileName;
    }

    public void setStandbyLogfileOffest(Long standbyLogfileOffest) {
        this.standbyLogfileOffest = standbyLogfileOffest;
    }

    public void setStandbyTimestamp(Long standbyTimestamp) {
        this.standbyTimestamp = standbyTimestamp;
    }

    public void setMasterAddress(InetSocketAddress masterAddress) {
        this.masterAddress = masterAddress;
    }

    public Integer getFallbackIntervalInSeconds() {
        return this.fallbackIntervalInSeconds == null ? 60 : this.fallbackIntervalInSeconds;
    }

    public void setFallbackIntervalInSeconds(Integer fallbackIntervalInSeconds) {
        this.fallbackIntervalInSeconds = fallbackIntervalInSeconds;
    }

    public Boolean getHeartbeatHaEnable() {
        return this.heartbeatHaEnable == null ? false : this.heartbeatHaEnable;
    }

    public void setHeartbeatHaEnable(Boolean heartbeatHaEnable) {
        this.heartbeatHaEnable = heartbeatHaEnable;
    }

    public BatchMode getStorageBatchMode() {
        return this.storageBatchMode == null ? BatchMode.MEMSIZE : this.storageBatchMode;
    }

    public void setStorageBatchMode(BatchMode storageBatchMode) {
        this.storageBatchMode = storageBatchMode;
    }

    public Integer getMemoryStorageBufferMemUnit() {
        return this.memoryStorageBufferMemUnit == null ? 1024 : this.memoryStorageBufferMemUnit;
    }

    public void setMemoryStorageBufferMemUnit(Integer memoryStorageBufferMemUnit) {
        this.memoryStorageBufferMemUnit = memoryStorageBufferMemUnit;
    }

    public String getMediaGroup() {
        return this.mediaGroup;
    }

    public void setMediaGroup(String mediaGroup) {
        this.mediaGroup = mediaGroup;
    }

    public Long getZkClusterId() {
        return this.zkClusterId;
    }

    public void setZkClusterId(Long zkClusterId) {
        this.zkClusterId = zkClusterId;
    }

    public Boolean getDdlIsolation() {
        return this.ddlIsolation == null ? false : this.ddlIsolation;
    }

    public void setDdlIsolation(Boolean ddlIsolation) {
        this.ddlIsolation = ddlIsolation;
    }

    public Boolean getFilterTableError() {
        return this.filterTableError == null ? false : this.filterTableError;
    }

    public void setFilterTableError(Boolean filterTableError) {
        this.filterTableError = filterTableError;
    }

    public String getBlackFilter() {
        return this.blackFilter;
    }

    public void setBlackFilter(String blackFilter) {
        this.blackFilter = blackFilter;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CanalToStringStyle.DEFAULT_STYLE);
    }

    public static class DataSourcing
    implements Serializable {
        private static final long serialVersionUID = -1770648468678085234L;
        private SourcingType type;
        private InetSocketAddress dbAddress;

        public DataSourcing() {
        }

        public DataSourcing(SourcingType type, InetSocketAddress dbAddress) {
            this.type = type;
            this.dbAddress = dbAddress;
        }

        public SourcingType getType() {
            return this.type;
        }

        public void setType(SourcingType type) {
            this.type = type;
        }

        public InetSocketAddress getDbAddress() {
            return this.dbAddress;
        }

        public void setDbAddress(InetSocketAddress dbAddress) {
            this.dbAddress = dbAddress;
        }
    }

    public static enum BatchMode {
        ITEMSIZE,
        MEMSIZE;


        public boolean isItemSize() {
            return this == ITEMSIZE;
        }

        public boolean isMemSize() {
            return this == MEMSIZE;
        }
    }

    public static enum IndexMode {
        MEMORY,
        ZOOKEEPER,
        MIXED,
        META,
        MEMORY_META_FAILBACK;


        public boolean isMemory() {
            return this.equals((Object)MEMORY);
        }

        public boolean isZookeeper() {
            return this.equals((Object)ZOOKEEPER);
        }

        public boolean isMixed() {
            return this.equals((Object)MIXED);
        }

        public boolean isMeta() {
            return this.equals((Object)META);
        }

        public boolean isMemoryMetaFailback() {
            return this.equals((Object)MEMORY_META_FAILBACK);
        }
    }

    public static enum MetaMode {
        MEMORY,
        ZOOKEEPER,
        MIXED;


        public boolean isMemory() {
            return this.equals((Object)MEMORY);
        }

        public boolean isZookeeper() {
            return this.equals((Object)ZOOKEEPER);
        }

        public boolean isMixed() {
            return this.equals((Object)MIXED);
        }
    }

    public static enum SourcingType {
        MYSQL,
        LOCALBINLOG,
        ORACLE,
        GROUP;


        public boolean isMysql() {
            return this.equals((Object)MYSQL);
        }

        public boolean isLocalBinlog() {
            return this.equals((Object)LOCALBINLOG);
        }

        public boolean isOracle() {
            return this.equals((Object)ORACLE);
        }

        public boolean isGroup() {
            return this.equals((Object)GROUP);
        }
    }

    public static enum StorageScavengeMode {
        ON_FULL,
        ON_ACK,
        ON_SCHEDULE,
        NO_OP;


        public boolean isOnFull() {
            return this.equals((Object)ON_FULL);
        }

        public boolean isOnAck() {
            return this.equals((Object)ON_ACK);
        }

        public boolean isOnSchedule() {
            return this.equals((Object)ON_SCHEDULE);
        }

        public boolean isNoop() {
            return this.equals((Object)NO_OP);
        }
    }

    public static enum StorageMode {
        MEMORY,
        FILE,
        MIXED;


        public boolean isMemory() {
            return this.equals((Object)MEMORY);
        }

        public boolean isFile() {
            return this.equals((Object)FILE);
        }

        public boolean isMixed() {
            return this.equals((Object)MIXED);
        }
    }

    public static enum HAMode {
        HEARTBEAT,
        MEDIA;


        public boolean isHeartBeat() {
            return this.equals((Object)HEARTBEAT);
        }

        public boolean isMedia() {
            return this.equals((Object)MEDIA);
        }
    }

    public static enum ClusterMode {
        STANDALONE,
        STANDBY,
        ACTIVE;


        public boolean isStandalone() {
            return this.equals((Object)STANDALONE);
        }

        public boolean isStandby() {
            return this.equals((Object)STANDBY);
        }

        public boolean isActive() {
            return this.equals((Object)ACTIVE);
        }
    }

    public static enum RunMode {
        EMBEDDED,
        SERVICE;


        public boolean isEmbedded() {
            return this.equals((Object)EMBEDDED);
        }

        public boolean isService() {
            return this.equals((Object)SERVICE);
        }
    }
}

