/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client;

import com.alibaba.rocketmq.client.consumer.DefaultMQPullConsumer;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;

public class MQHelper {
    public static void resetOffsetByTimestamp(MessageModel messageModel, String consumerGroup, String topic, long timestamp) throws Exception {
        Logger log = ClientLogger.getLog();
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer(consumerGroup);
        consumer.setMessageModel(messageModel);
        consumer.start();
        Set<MessageQueue> mqs = null;
        try {
            mqs = consumer.fetchSubscribeMessageQueues(topic);
            if (mqs != null && !mqs.isEmpty()) {
                TreeSet<MessageQueue> mqsNew = new TreeSet<MessageQueue>(mqs);
                for (MessageQueue mq : mqsNew) {
                    long offset = consumer.searchOffset(mq, timestamp);
                    if (offset < 0L) continue;
                    consumer.updateConsumeOffset(mq, offset);
                    log.info("resetOffsetByTimestamp updateConsumeOffset success, {} {} {}", new Object[]{consumerGroup, offset, mq});
                }
            }
        }
        catch (Exception e) {
            log.warn("resetOffsetByTimestamp Exception", (Throwable)e);
            throw e;
        }
        finally {
            consumer.shutdown();
            if (mqs != null) {
                consumer.getDefaultMQPullConsumerImpl().getOffsetStore().persistAll(mqs);
            }
        }
    }
}

