/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ExportItem;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.FunctionInstructionSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ExpressLoader {
    private final ConcurrentHashMap<String, InstructionSet> expressInstructionSetCache = new ConcurrentHashMap();
    final ExpressRunner expressRunner;

    public ExpressLoader(ExpressRunner expressRunner) {
        this.expressRunner = expressRunner;
    }

    public InstructionSet loadExpress(String expressName) throws Exception {
        return this.parseInstructionSet(expressName, this.expressRunner.getExpressResourceLoader().loadExpress(expressName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstructionSet(String expressName, InstructionSet set) throws Exception {
        ConcurrentHashMap<String, InstructionSet> concurrentHashMap = this.expressInstructionSetCache;
        synchronized (concurrentHashMap) {
            if (this.expressInstructionSetCache.containsKey(expressName)) {
                throw new QLException("\u8868\u8fbe\u5f0f\u5b9a\u4e49\u91cd\u590d\uff1a" + expressName);
            }
            this.expressInstructionSetCache.put(expressName, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstructionSet parseInstructionSet(String expressName, String expressString) throws Exception {
        InstructionSet parseResult;
        if (this.expressInstructionSetCache.containsKey(expressName)) {
            throw new QLException("\u8868\u8fbe\u5f0f\u5b9a\u4e49\u91cd\u590d\uff1a" + expressName);
        }
        ConcurrentHashMap<String, InstructionSet> concurrentHashMap = this.expressInstructionSetCache;
        synchronized (concurrentHashMap) {
            parseResult = this.expressRunner.parseInstructionSet(expressString);
            parseResult.setName(expressName);
            parseResult.setGlobeName(expressName);
            for (FunctionInstructionSet item : parseResult.getFunctionInstructionSets()) {
                this.addInstructionSet(item.name, item.instructionSet);
                item.instructionSet.setName(item.name);
                item.instructionSet.setGlobeName(expressName + "." + item.name);
            }
            if (parseResult.hasMain()) {
                this.addInstructionSet(expressName, parseResult);
            }
        }
        return parseResult;
    }

    public void clear() {
        this.expressInstructionSetCache.clear();
    }

    public InstructionSet getInstructionSet(String expressName) {
        return this.expressInstructionSetCache.get(expressName);
    }

    public ExportItem[] getExportInfo() {
        TreeMap<String, ExportItem> result = new TreeMap<String, ExportItem>();
        for (InstructionSet instructionSet : this.expressInstructionSetCache.values()) {
            String globeName = instructionSet.getGlobeName();
            for (ExportItem exportItem : instructionSet.getExportDef()) {
                exportItem.setGlobeName(globeName + "." + exportItem.getName());
                result.put(exportItem.getGlobeName(), exportItem);
            }
            String name = instructionSet.getName();
            String type = instructionSet.getType();
            result.put(globeName, new ExportItem(globeName, name, type, instructionSet.toString()));
        }
        return result.values().toArray(new ExportItem[0]);
    }
}

