/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.dialect.db2.parser.DB2Lexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class DB2ExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};

    public DB2ExprParser(String sql) {
        this(new DB2Lexer(sql));
        this.lexer.nextToken();
    }

    public DB2ExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.identifierEquals("VALUE") && expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            String ident = identExpr.getName();
            if (ident.equalsIgnoreCase("NEXT")) {
                this.lexer.nextToken();
                this.accept(Token.FOR);
                SQLName seqName = this.name();
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.NextVal);
                return seqExpr;
            }
            if (ident.equalsIgnoreCase("PREVIOUS")) {
                this.lexer.nextToken();
                this.accept(Token.FOR);
                SQLName seqName = this.name();
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.PrevVal);
                return seqExpr;
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        if (this.identifierEquals("NEXTVAL")) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.NextVal);
                this.lexer.nextToken();
                return seqExpr;
            }
        } else if (this.identifierEquals("PREVVAL")) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.PrevVal);
                this.lexer.nextToken();
                return seqExpr;
            }
        } else if (this.identifierEquals("CURRVAL") && expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.CurrVal);
            this.lexer.nextToken();
            return seqExpr;
        }
        return super.dotRest(expr);
    }
}

