/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.anno.CacheConsts;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.lettuce.JetCacheCodec;
import com.alicp.jetcache.redis.lettuce.LettuceConnectionManager;
import com.alicp.jetcache.redis.lettuce.RedisLettuceCacheBuilder;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RedisLettuceCondition.class})
public class RedisLettuceAutoConfiguration {
    public static final String AUTO_INIT_BEAN_NAME = "redisLettuceAutoInit";

    @Bean(name={"redisLettuceAutoInit"})
    public RedisLettuceAutoInit redisLettuceAutoInit() {
        return new RedisLettuceAutoInit();
    }

    public static class RedisLettuceAutoInit
    extends ExternalCacheAutoInit {
        public RedisLettuceAutoInit() {
            super("redis.lettuce");
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            RedisClient client;
            Map<String, Object> map = ct.subTree("uri").getProperties();
            String readFromStr = (String)ct.getProperty("readFrom");
            String mode = (String)ct.getProperty("mode");
            long asyncResultTimeoutInMillis = Long.parseLong(ct.getProperty("asyncResultTimeoutInMillis", Long.toString(CacheConsts.ASYNC_RESULT_TIMEOUT.toMillis())));
            ReadFrom readFrom = null;
            if (readFromStr != null) {
                readFrom = ReadFrom.valueOf((String)readFromStr.trim());
            }
            StatefulConnection connection = null;
            if (map == null || map.size() == 0) {
                throw new CacheConfigException("lettuce uri is required");
            }
            List uriList = map.values().stream().map(k -> RedisURI.create((URI)URI.create(k.toString()))).collect(Collectors.toList());
            if (uriList.size() == 1) {
                RedisURI uri = (RedisURI)uriList.get(0);
                if ("Cluster".equalsIgnoreCase(mode)) {
                    client = RedisClusterClient.create((RedisURI)uri);
                    connection = this.clusterConnection(ct, readFrom, (RedisClusterClient)client);
                } else if (readFrom == null) {
                    client = RedisClient.create((RedisURI)uri);
                    client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                } else {
                    client = RedisClient.create();
                    client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                    StatefulRedisMasterReplicaConnection c = MasterReplica.connect((RedisClient)client, (RedisCodec)new JetCacheCodec(), (RedisURI)uri);
                    c.setReadFrom(readFrom);
                    connection = c;
                }
            } else if ("MasterSlave".equalsIgnoreCase(mode) || "MasterReplica".equalsIgnoreCase(mode)) {
                client = RedisClient.create();
                client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                StatefulRedisMasterReplicaConnection c = MasterReplica.connect((RedisClient)client, (RedisCodec)new JetCacheCodec(), uriList);
                if (readFrom != null) {
                    c.setReadFrom(readFrom);
                }
                connection = c;
            } else {
                client = RedisClusterClient.create(uriList);
                connection = this.clusterConnection(ct, readFrom, (RedisClusterClient)client);
            }
            ExternalCacheBuilder externalCacheBuilder = ((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)RedisLettuceCacheBuilder.createRedisLettuceCacheBuilder().connection(connection)).redisClient((AbstractRedisClient)client)).asyncResultTimeoutInMillis(asyncResultTimeoutInMillis);
            this.parseGeneralConfig((CacheBuilder)externalCacheBuilder, ct);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".client", client);
            LettuceConnectionManager m = LettuceConnectionManager.defaultManager();
            m.init((AbstractRedisClient)client, connection);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".connection", m.connection((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".commands", m.commands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".asyncCommands", m.asyncCommands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".reactiveCommands", m.reactiveCommands((AbstractRedisClient)client));
            return externalCacheBuilder;
        }

        private StatefulConnection clusterConnection(ConfigTree ct, ReadFrom readFrom, RedisClusterClient client) {
            int enablePeriodicRefresh = Integer.parseInt(ct.getProperty("enablePeriodicRefresh", "60"));
            boolean enableAllAdaptiveRefreshTriggers = Boolean.parseBoolean(ct.getProperty("enableAllAdaptiveRefreshTriggers", "true"));
            ClusterTopologyRefreshOptions.Builder topologyOptionBuilder = ClusterTopologyRefreshOptions.builder();
            if (enablePeriodicRefresh > 0) {
                topologyOptionBuilder.enablePeriodicRefresh(Duration.ofSeconds(enablePeriodicRefresh));
            }
            if (enableAllAdaptiveRefreshTriggers) {
                topologyOptionBuilder.enableAllAdaptiveRefreshTriggers();
            }
            ClusterClientOptions options = ClusterClientOptions.builder().topologyRefreshOptions(topologyOptionBuilder.build()).disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build();
            client.setOptions(options);
            if (readFrom != null) {
                StatefulRedisClusterConnection c = client.connect((RedisCodec)new JetCacheCodec());
                c.setReadFrom(readFrom);
                return c;
            }
            return null;
        }
    }

    public static class RedisLettuceCondition
    extends JetCacheCondition {
        public RedisLettuceCondition() {
            super("redis.lettuce");
        }
    }
}

