/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayEbppInvoiceTaxnoBatchqueryDefaultResponse;
import com.alipay.v3.model.AlipayEbppInvoiceTaxnoBatchqueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class AlipayEbppInvoiceTaxnoApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayEbppInvoiceTaxnoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayEbppInvoiceTaxnoApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call batchqueryCall(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/ebpp/invoice/taxno/batchquery";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auth_token", authToken));
        }
        if (taxNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tax_no", taxNo));
        }
        if (invoiceKindList != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_kind_list", invoiceKindList));
        }
        if (scene != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scene", scene));
        }
        if (startInvoiceDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_invoice_date", startInvoiceDate));
        }
        if (endInvoiceDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_invoice_date", endInvoiceDate));
        }
        if (limitSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit_size", limitSize));
        }
        if (enableTradeOut != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("enable_trade_out", enableTradeOut));
        }
        if (pageNum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_num", pageNum));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call batchqueryValidateBeforeCall(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.batchqueryCall(authToken, taxNo, invoiceKindList, scene, startInvoiceDate, endInvoiceDate, limitSize, enableTradeOut, pageNum, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayEbppInvoiceTaxnoBatchqueryResponseModel batchquery(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum) throws ApiException {
        ApiResponse<AlipayEbppInvoiceTaxnoBatchqueryResponseModel> localVarResp = this.batchqueryWithHttpInfo(authToken, taxNo, invoiceKindList, scene, startInvoiceDate, endInvoiceDate, limitSize, enableTradeOut, pageNum, null);
        return localVarResp.getData();
    }

    public AlipayEbppInvoiceTaxnoBatchqueryResponseModel batchquery(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayEbppInvoiceTaxnoBatchqueryResponseModel> localVarResp = this.batchqueryWithHttpInfo(authToken, taxNo, invoiceKindList, scene, startInvoiceDate, endInvoiceDate, limitSize, enableTradeOut, pageNum, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayEbppInvoiceTaxnoBatchqueryResponseModel> batchqueryWithHttpInfo(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.batchqueryValidateBeforeCall(authToken, taxNo, invoiceKindList, scene, startInvoiceDate, endInvoiceDate, limitSize, enableTradeOut, pageNum, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayEbppInvoiceTaxnoBatchqueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayEbppInvoiceTaxnoBatchqueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call batchqueryAsync(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum, ApiCallback<AlipayEbppInvoiceTaxnoBatchqueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.batchqueryValidateBeforeCall(authToken, taxNo, invoiceKindList, scene, startInvoiceDate, endInvoiceDate, limitSize, enableTradeOut, pageNum, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayEbppInvoiceTaxnoBatchqueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call batchqueryAsync(String authToken, String taxNo, List<String> invoiceKindList, String scene, String startInvoiceDate, String endInvoiceDate, Integer limitSize, String enableTradeOut, Integer pageNum, ApiCallback<AlipayEbppInvoiceTaxnoBatchqueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.batchqueryValidateBeforeCall(authToken, taxNo, invoiceKindList, scene, startInvoiceDate, endInvoiceDate, limitSize, enableTradeOut, pageNum, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayEbppInvoiceTaxnoBatchqueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

