/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayFundAuthOperationDetailQueryDefaultResponse;
import com.alipay.v3.model.AlipayFundAuthOperationDetailQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class AlipayFundAuthOperationDetailApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayFundAuthOperationDetailApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayFundAuthOperationDetailApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call queryCall(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/fund/auth/operation/detail/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auth_no", authNo));
        }
        if (outOrderNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_order_no", outOrderNo));
        }
        if (operationId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("operation_id", operationId));
        }
        if (outRequestNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_request_no", outRequestNo));
        }
        if (operationType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("operation_type", operationType));
        }
        if (queryOptions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "query_options", queryOptions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(authNo, outOrderNo, operationId, outRequestNo, operationType, queryOptions, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayFundAuthOperationDetailQueryResponseModel query(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions) throws ApiException {
        ApiResponse<AlipayFundAuthOperationDetailQueryResponseModel> localVarResp = this.queryWithHttpInfo(authNo, outOrderNo, operationId, outRequestNo, operationType, queryOptions, null);
        return localVarResp.getData();
    }

    public AlipayFundAuthOperationDetailQueryResponseModel query(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayFundAuthOperationDetailQueryResponseModel> localVarResp = this.queryWithHttpInfo(authNo, outOrderNo, operationId, outRequestNo, operationType, queryOptions, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayFundAuthOperationDetailQueryResponseModel> queryWithHttpInfo(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(authNo, outOrderNo, operationId, outRequestNo, operationType, queryOptions, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayFundAuthOperationDetailQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayFundAuthOperationDetailQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions, ApiCallback<AlipayFundAuthOperationDetailQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(authNo, outOrderNo, operationId, outRequestNo, operationType, queryOptions, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayFundAuthOperationDetailQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String authNo, String outOrderNo, String operationId, String outRequestNo, String operationType, List<String> queryOptions, ApiCallback<AlipayFundAuthOperationDetailQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(authNo, outOrderNo, operationId, outRequestNo, operationType, queryOptions, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayFundAuthOperationDetailQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

