/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenMiniQrcodeBindDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniQrcodeBindModel;
import com.alipay.v3.model.AlipayOpenMiniQrcodeBindResponseModel;
import com.alipay.v3.model.AlipayOpenMiniQrcodeQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniQrcodeQueryResponseModel;
import com.alipay.v3.model.AlipayOpenMiniQrcodeUnbindDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniQrcodeUnbindModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenMiniQrcodeApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenMiniQrcodeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenMiniQrcodeApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call bindCall(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenMiniQrcodeBindModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenMiniQrcodeBindModel;
        String localVarPath = "/v3/alipay/open/mini/qrcode/bind";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bindValidateBeforeCall(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.bindCall(alipayOpenMiniQrcodeBindModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenMiniQrcodeBindResponseModel bind(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel) throws ApiException {
        ApiResponse<AlipayOpenMiniQrcodeBindResponseModel> localVarResp = this.bindWithHttpInfo(alipayOpenMiniQrcodeBindModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenMiniQrcodeBindResponseModel bind(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenMiniQrcodeBindResponseModel> localVarResp = this.bindWithHttpInfo(alipayOpenMiniQrcodeBindModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenMiniQrcodeBindResponseModel> bindWithHttpInfo(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.bindValidateBeforeCall(alipayOpenMiniQrcodeBindModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenMiniQrcodeBindResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniQrcodeBindDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call bindAsync(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel, ApiCallback<AlipayOpenMiniQrcodeBindResponseModel> _callback) throws ApiException {
        Call localVarCall = this.bindValidateBeforeCall(alipayOpenMiniQrcodeBindModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniQrcodeBindResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call bindAsync(AlipayOpenMiniQrcodeBindModel alipayOpenMiniQrcodeBindModel, ApiCallback<AlipayOpenMiniQrcodeBindResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.bindValidateBeforeCall(alipayOpenMiniQrcodeBindModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniQrcodeBindResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(Integer pageNo, Integer pageSize, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/mini/qrcode/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_no", pageNo));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(Integer pageNo, Integer pageSize, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(pageNo, pageSize, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenMiniQrcodeQueryResponseModel query(Integer pageNo, Integer pageSize) throws ApiException {
        ApiResponse<AlipayOpenMiniQrcodeQueryResponseModel> localVarResp = this.queryWithHttpInfo(pageNo, pageSize, null);
        return localVarResp.getData();
    }

    public AlipayOpenMiniQrcodeQueryResponseModel query(Integer pageNo, Integer pageSize, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenMiniQrcodeQueryResponseModel> localVarResp = this.queryWithHttpInfo(pageNo, pageSize, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenMiniQrcodeQueryResponseModel> queryWithHttpInfo(Integer pageNo, Integer pageSize, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(pageNo, pageSize, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenMiniQrcodeQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniQrcodeQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(Integer pageNo, Integer pageSize, ApiCallback<AlipayOpenMiniQrcodeQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(pageNo, pageSize, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniQrcodeQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(Integer pageNo, Integer pageSize, ApiCallback<AlipayOpenMiniQrcodeQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(pageNo, pageSize, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniQrcodeQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unbindCall(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenMiniQrcodeUnbindModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenMiniQrcodeUnbindModel;
        String localVarPath = "/v3/alipay/open/mini/qrcode/unbind";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unbindValidateBeforeCall(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unbindCall(alipayOpenMiniQrcodeUnbindModel, _callback, customizedParams);
        return localVarCall;
    }

    public Object unbind(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel) throws ApiException {
        ApiResponse<Object> localVarResp = this.unbindWithHttpInfo(alipayOpenMiniQrcodeUnbindModel, null);
        return localVarResp.getData();
    }

    public Object unbind(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.unbindWithHttpInfo(alipayOpenMiniQrcodeUnbindModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> unbindWithHttpInfo(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unbindValidateBeforeCall(alipayOpenMiniQrcodeUnbindModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniQrcodeUnbindDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call unbindAsync(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.unbindValidateBeforeCall(alipayOpenMiniQrcodeUnbindModel, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unbindAsync(AlipayOpenMiniQrcodeUnbindModel alipayOpenMiniQrcodeUnbindModel, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unbindValidateBeforeCall(alipayOpenMiniQrcodeUnbindModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

