/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordApplyDefaultResponse;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordApplyModel;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordApplyResponseModel;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordBatchqueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordBatchqueryResponseModel;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordDeleteDefaultResponse;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordDeleteModel;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordQuerystatusDefaultResponse;
import com.alipay.v3.model.AlipayOpenSearchAppkeywordQuerystatusResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenSearchAppkeywordApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenSearchAppkeywordApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenSearchAppkeywordApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call applyCall(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenSearchAppkeywordApplyModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenSearchAppkeywordApplyModel;
        String localVarPath = "/v3/alipay/open/search/appkeyword/apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyValidateBeforeCall(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyCall(alipayOpenSearchAppkeywordApplyModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenSearchAppkeywordApplyResponseModel apply(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel) throws ApiException {
        ApiResponse<AlipayOpenSearchAppkeywordApplyResponseModel> localVarResp = this.applyWithHttpInfo(alipayOpenSearchAppkeywordApplyModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenSearchAppkeywordApplyResponseModel apply(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenSearchAppkeywordApplyResponseModel> localVarResp = this.applyWithHttpInfo(alipayOpenSearchAppkeywordApplyModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenSearchAppkeywordApplyResponseModel> applyWithHttpInfo(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayOpenSearchAppkeywordApplyModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordApplyResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSearchAppkeywordApplyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call applyAsync(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel, ApiCallback<AlipayOpenSearchAppkeywordApplyResponseModel> _callback) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayOpenSearchAppkeywordApplyModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordApplyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applyAsync(AlipayOpenSearchAppkeywordApplyModel alipayOpenSearchAppkeywordApplyModel, ApiCallback<AlipayOpenSearchAppkeywordApplyResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayOpenSearchAppkeywordApplyModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordApplyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call batchqueryCall(String targetAppid, Integer pageNumber, Integer pageSize, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/search/appkeyword/batchquery";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (targetAppid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("target_appid", targetAppid));
        }
        if (pageNumber != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_number", pageNumber));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call batchqueryValidateBeforeCall(String targetAppid, Integer pageNumber, Integer pageSize, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.batchqueryCall(targetAppid, pageNumber, pageSize, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenSearchAppkeywordBatchqueryResponseModel batchquery(String targetAppid, Integer pageNumber, Integer pageSize) throws ApiException {
        ApiResponse<AlipayOpenSearchAppkeywordBatchqueryResponseModel> localVarResp = this.batchqueryWithHttpInfo(targetAppid, pageNumber, pageSize, null);
        return localVarResp.getData();
    }

    public AlipayOpenSearchAppkeywordBatchqueryResponseModel batchquery(String targetAppid, Integer pageNumber, Integer pageSize, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenSearchAppkeywordBatchqueryResponseModel> localVarResp = this.batchqueryWithHttpInfo(targetAppid, pageNumber, pageSize, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenSearchAppkeywordBatchqueryResponseModel> batchqueryWithHttpInfo(String targetAppid, Integer pageNumber, Integer pageSize, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.batchqueryValidateBeforeCall(targetAppid, pageNumber, pageSize, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordBatchqueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSearchAppkeywordBatchqueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call batchqueryAsync(String targetAppid, Integer pageNumber, Integer pageSize, ApiCallback<AlipayOpenSearchAppkeywordBatchqueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.batchqueryValidateBeforeCall(targetAppid, pageNumber, pageSize, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordBatchqueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call batchqueryAsync(String targetAppid, Integer pageNumber, Integer pageSize, ApiCallback<AlipayOpenSearchAppkeywordBatchqueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.batchqueryValidateBeforeCall(targetAppid, pageNumber, pageSize, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordBatchqueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCall(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenSearchAppkeywordDeleteModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenSearchAppkeywordDeleteModel;
        String localVarPath = "/v3/alipay/open/search/appkeyword/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteCall(alipayOpenSearchAppkeywordDeleteModel, _callback, customizedParams);
        return localVarCall;
    }

    public Object delete(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(alipayOpenSearchAppkeywordDeleteModel, null);
        return localVarResp.getData();
    }

    public Object delete(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(alipayOpenSearchAppkeywordDeleteModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteWithHttpInfo(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(alipayOpenSearchAppkeywordDeleteModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSearchAppkeywordDeleteDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call deleteAsync(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(alipayOpenSearchAppkeywordDeleteModel, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAsync(AlipayOpenSearchAppkeywordDeleteModel alipayOpenSearchAppkeywordDeleteModel, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(alipayOpenSearchAppkeywordDeleteModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call querystatusCall(String targetAppid, String applyNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/search/appkeyword/querystatus";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (targetAppid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("target_appid", targetAppid));
        }
        if (applyNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("apply_no", applyNo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call querystatusValidateBeforeCall(String targetAppid, String applyNo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.querystatusCall(targetAppid, applyNo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenSearchAppkeywordQuerystatusResponseModel querystatus(String targetAppid, String applyNo) throws ApiException {
        ApiResponse<AlipayOpenSearchAppkeywordQuerystatusResponseModel> localVarResp = this.querystatusWithHttpInfo(targetAppid, applyNo, null);
        return localVarResp.getData();
    }

    public AlipayOpenSearchAppkeywordQuerystatusResponseModel querystatus(String targetAppid, String applyNo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenSearchAppkeywordQuerystatusResponseModel> localVarResp = this.querystatusWithHttpInfo(targetAppid, applyNo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenSearchAppkeywordQuerystatusResponseModel> querystatusWithHttpInfo(String targetAppid, String applyNo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.querystatusValidateBeforeCall(targetAppid, applyNo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordQuerystatusResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenSearchAppkeywordQuerystatusDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call querystatusAsync(String targetAppid, String applyNo, ApiCallback<AlipayOpenSearchAppkeywordQuerystatusResponseModel> _callback) throws ApiException {
        Call localVarCall = this.querystatusValidateBeforeCall(targetAppid, applyNo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordQuerystatusResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call querystatusAsync(String targetAppid, String applyNo, ApiCallback<AlipayOpenSearchAppkeywordQuerystatusResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.querystatusValidateBeforeCall(targetAppid, applyNo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenSearchAppkeywordQuerystatusResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

