/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayTradeRefundApplyDefaultResponse;
import com.alipay.v3.model.AlipayTradeRefundApplyModel;
import com.alipay.v3.model.AlipayTradeRefundApplyResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayTradeRefundApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayTradeRefundApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayTradeRefundApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call applyCall(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayTradeRefundApplyModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayTradeRefundApplyModel;
        String localVarPath = "/v3/alipay/trade/refund/apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyValidateBeforeCall(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyCall(alipayTradeRefundApplyModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeRefundApplyResponseModel apply(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel) throws ApiException {
        ApiResponse<AlipayTradeRefundApplyResponseModel> localVarResp = this.applyWithHttpInfo(alipayTradeRefundApplyModel, null);
        return localVarResp.getData();
    }

    public AlipayTradeRefundApplyResponseModel apply(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeRefundApplyResponseModel> localVarResp = this.applyWithHttpInfo(alipayTradeRefundApplyModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeRefundApplyResponseModel> applyWithHttpInfo(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayTradeRefundApplyModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeRefundApplyResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeRefundApplyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call applyAsync(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel, ApiCallback<AlipayTradeRefundApplyResponseModel> _callback) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayTradeRefundApplyModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeRefundApplyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applyAsync(AlipayTradeRefundApplyModel alipayTradeRefundApplyModel, ApiCallback<AlipayTradeRefundApplyResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayTradeRefundApplyModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeRefundApplyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

