/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.AdvertItem;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class Advert {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ADVERT_GROUP = "advert_group";
    @SerializedName(value="advert_group")
    private String advertGroup;
    public static final String SERIALIZED_NAME_ADVERT_ID = "advert_id";
    @SerializedName(value="advert_id")
    private String advertId;
    public static final String SERIALIZED_NAME_ADVERT_ITEMS = "advert_items";
    @SerializedName(value="advert_items")
    private List<AdvertItem> advertItems = null;
    public static final String SERIALIZED_NAME_GROUP_ID = "group_id";
    @SerializedName(value="group_id")
    private String groupId;
    public static final String SERIALIZED_NAME_MOBILE_CLIENT_TYPE = "mobile_client_type";
    @SerializedName(value="mobile_client_type")
    private String mobileClientType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Advert advertGroup(String advertGroup) {
        this.advertGroup = advertGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CG202008041013200064690", value="\u5e7f\u544a\u7ec4\u6807\u8bc6")
    public String getAdvertGroup() {
        return this.advertGroup;
    }

    public void setAdvertGroup(String advertGroup) {
        this.advertGroup = advertGroup;
    }

    public Advert advertId(String advertId) {
        this.advertId = advertId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123", value="\u5e7f\u544a\u4f4did")
    public String getAdvertId() {
        return this.advertId;
    }

    public void setAdvertId(String advertId) {
        this.advertId = advertId;
    }

    public Advert advertItems(List<AdvertItem> advertItems) {
        this.advertItems = advertItems;
        return this;
    }

    public Advert addAdvertItemsItem(AdvertItem advertItemsItem) {
        if (this.advertItems == null) {
            this.advertItems = new ArrayList<AdvertItem>();
        }
        this.advertItems.add(advertItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u5e7f\u544a\u4f4d\u8f6e\u64ad\u5185\u5bb9\u5217\u8868")
    public List<AdvertItem> getAdvertItems() {
        return this.advertItems;
    }

    public void setAdvertItems(List<AdvertItem> advertItems) {
        this.advertItems = advertItems;
    }

    public Advert groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RQ20191025100100595279", value="\u6295\u653e\u4eba\u7fa4\u5206\u7ec4id")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Advert mobileClientType(String mobileClientType) {
        this.mobileClientType = mobileClientType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="android", value="\u624b\u673a\u5ba2\u6237\u7aef\u7c7b\u578b\uff0ciphone\u3001android\u3001wp,\u7a7a\u4e3a\u4e0d\u533a\u5206\u673a\u578b")
    public String getMobileClientType() {
        return this.mobileClientType;
    }

    public void setMobileClientType(String mobileClientType) {
        this.mobileClientType = mobileClientType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Advert advert = (Advert)o;
        return Objects.equals(this.advertGroup, advert.advertGroup) && Objects.equals(this.advertId, advert.advertId) && Objects.equals(this.advertItems, advert.advertItems) && Objects.equals(this.groupId, advert.groupId) && Objects.equals(this.mobileClientType, advert.mobileClientType);
    }

    public int hashCode() {
        return Objects.hash(this.advertGroup, this.advertId, this.advertItems, this.groupId, this.mobileClientType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Advert {\n");
        sb.append("    advertGroup: ").append(this.toIndentedString(this.advertGroup)).append("\n");
        sb.append("    advertId: ").append(this.toIndentedString(this.advertId)).append("\n");
        sb.append("    advertItems: ").append(this.toIndentedString(this.advertItems)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    mobileClientType: ").append(this.toIndentedString(this.mobileClientType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Advert is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Advert` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADVERT_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_ADVERT_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `advert_group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADVERT_GROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADVERT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ADVERT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `advert_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADVERT_ID).toString()));
        }
        JsonArray jsonArrayadvertItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADVERT_ITEMS);
        if (jsonArrayadvertItems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADVERT_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `advert_items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADVERT_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayadvertItems.size(); ++i) {
                AdvertItem.validateJsonObject(jsonArrayadvertItems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ID) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOBILE_CLIENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MOBILE_CLIENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mobile_client_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOBILE_CLIENT_TYPE).toString()));
        }
    }

    public static Advert fromJson(String jsonString) throws IOException {
        return (Advert)JSON.getGson().fromJson(jsonString, Advert.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADVERT_GROUP);
        openapiFields.add(SERIALIZED_NAME_ADVERT_ID);
        openapiFields.add(SERIALIZED_NAME_ADVERT_ITEMS);
        openapiFields.add(SERIALIZED_NAME_GROUP_ID);
        openapiFields.add(SERIALIZED_NAME_MOBILE_CLIENT_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Advert.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Advert.class));
            return new TypeAdapter<Advert>(){

                public void write(JsonWriter out, Advert value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Advert read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Advert.validateJsonObject(jsonObj);
                    return (Advert)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

