/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.CashCampaignInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayMarketingCampaignCashListQueryResponseModel {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CAMP_LIST = "camp_list";
    @SerializedName(value="camp_list")
    private List<CashCampaignInfo> campList = null;
    public static final String SERIALIZED_NAME_PAGE_INDEX = "page_index";
    @SerializedName(value="page_index")
    private String pageIndex;
    public static final String SERIALIZED_NAME_PAGE_SIZE = "page_size";
    @SerializedName(value="page_size")
    private String pageSize;
    public static final String SERIALIZED_NAME_TOTAL_SIZE = "total_size";
    @SerializedName(value="total_size")
    private String totalSize;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayMarketingCampaignCashListQueryResponseModel campList(List<CashCampaignInfo> campList) {
        this.campList = campList;
        return this;
    }

    public AlipayMarketingCampaignCashListQueryResponseModel addCampListItem(CashCampaignInfo campListItem) {
        if (this.campList == null) {
            this.campList = new ArrayList<CashCampaignInfo>();
        }
        this.campList.add(campListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u6d3b\u52a8\u5217\u8868")
    public List<CashCampaignInfo> getCampList() {
        return this.campList;
    }

    public void setCampList(List<CashCampaignInfo> campList) {
        this.campList = campList;
    }

    public AlipayMarketingCampaignCashListQueryResponseModel pageIndex(String pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="\u5206\u9875\u7684\u9875\u7801,\u8d77\u59cb\u4ece1\u5f00\u59cb")
    public String getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(String pageIndex) {
        this.pageIndex = pageIndex;
    }

    public AlipayMarketingCampaignCashListQueryResponseModel pageSize(String pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="\u5206\u9875\u6bcf\u9875\u5927\u5c0f")
    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public AlipayMarketingCampaignCashListQueryResponseModel totalSize(String totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="20", value="\u6d3b\u52a8\u603b\u4e2a\u6570")
    public String getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(String totalSize) {
        this.totalSize = totalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayMarketingCampaignCashListQueryResponseModel alipayMarketingCampaignCashListQueryResponseModel = (AlipayMarketingCampaignCashListQueryResponseModel)o;
        return Objects.equals(this.campList, alipayMarketingCampaignCashListQueryResponseModel.campList) && Objects.equals(this.pageIndex, alipayMarketingCampaignCashListQueryResponseModel.pageIndex) && Objects.equals(this.pageSize, alipayMarketingCampaignCashListQueryResponseModel.pageSize) && Objects.equals(this.totalSize, alipayMarketingCampaignCashListQueryResponseModel.totalSize);
    }

    public int hashCode() {
        return Objects.hash(this.campList, this.pageIndex, this.pageSize, this.totalSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayMarketingCampaignCashListQueryResponseModel {\n");
        sb.append("    campList: ").append(this.toIndentedString(this.campList)).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.pageIndex)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    totalSize: ").append(this.toIndentedString(this.totalSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayMarketingCampaignCashListQueryResponseModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayMarketingCampaignCashListQueryResponseModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArraycampList = jsonObj.getAsJsonArray(SERIALIZED_NAME_CAMP_LIST);
        if (jsonArraycampList != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CAMP_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `camp_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAMP_LIST).toString()));
            }
            for (int i = 0; i < jsonArraycampList.size(); ++i) {
                CashCampaignInfo.validateJsonObject(jsonArraycampList.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PAGE_INDEX) != null && !jsonObj.get(SERIALIZED_NAME_PAGE_INDEX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `page_index` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAGE_INDEX).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAGE_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_PAGE_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `page_size` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAGE_SIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOTAL_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_TOTAL_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `total_size` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOTAL_SIZE).toString()));
        }
    }

    public static AlipayMarketingCampaignCashListQueryResponseModel fromJson(String jsonString) throws IOException {
        return (AlipayMarketingCampaignCashListQueryResponseModel)JSON.getGson().fromJson(jsonString, AlipayMarketingCampaignCashListQueryResponseModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAMP_LIST);
        openapiFields.add(SERIALIZED_NAME_PAGE_INDEX);
        openapiFields.add(SERIALIZED_NAME_PAGE_SIZE);
        openapiFields.add(SERIALIZED_NAME_TOTAL_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayMarketingCampaignCashListQueryResponseModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayMarketingCampaignCashListQueryResponseModel.class));
            return new TypeAdapter<AlipayMarketingCampaignCashListQueryResponseModel>(){

                public void write(JsonWriter out, AlipayMarketingCampaignCashListQueryResponseModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayMarketingCampaignCashListQueryResponseModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayMarketingCampaignCashListQueryResponseModel.validateJsonObject(jsonObj);
                    return (AlipayMarketingCampaignCashListQueryResponseModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

