/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.StandardServiceBaseInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayOpenAppServiceListQueryResponseModel {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PAGE_NUM = "page_num";
    @SerializedName(value="page_num")
    private Integer pageNum;
    public static final String SERIALIZED_NAME_PAGE_SIZE = "page_size";
    @SerializedName(value="page_size")
    private Integer pageSize;
    public static final String SERIALIZED_NAME_RECORDS = "records";
    @SerializedName(value="records")
    private List<StandardServiceBaseInfo> records = null;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private Integer total;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayOpenAppServiceListQueryResponseModel pageNum(Integer pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="\u9875\u7801")
    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public AlipayOpenAppServiceListQueryResponseModel pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="\u6bcf\u9875\u8bb0\u5f55\u6570")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public AlipayOpenAppServiceListQueryResponseModel records(List<StandardServiceBaseInfo> records) {
        this.records = records;
        return this;
    }

    public AlipayOpenAppServiceListQueryResponseModel addRecordsItem(StandardServiceBaseInfo recordsItem) {
        if (this.records == null) {
            this.records = new ArrayList<StandardServiceBaseInfo>();
        }
        this.records.add(recordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u670d\u52a1\u5217\u8868")
    public List<StandardServiceBaseInfo> getRecords() {
        return this.records;
    }

    public void setRecords(List<StandardServiceBaseInfo> records) {
        this.records = records;
    }

    public AlipayOpenAppServiceListQueryResponseModel total(Integer total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="500", value="\u603b\u8bb0\u5f55\u6570")
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayOpenAppServiceListQueryResponseModel alipayOpenAppServiceListQueryResponseModel = (AlipayOpenAppServiceListQueryResponseModel)o;
        return Objects.equals(this.pageNum, alipayOpenAppServiceListQueryResponseModel.pageNum) && Objects.equals(this.pageSize, alipayOpenAppServiceListQueryResponseModel.pageSize) && Objects.equals(this.records, alipayOpenAppServiceListQueryResponseModel.records) && Objects.equals(this.total, alipayOpenAppServiceListQueryResponseModel.total);
    }

    public int hashCode() {
        return Objects.hash(this.pageNum, this.pageSize, this.records, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayOpenAppServiceListQueryResponseModel {\n");
        sb.append("    pageNum: ").append(this.toIndentedString(this.pageNum)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    records: ").append(this.toIndentedString(this.records)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayOpenAppServiceListQueryResponseModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayOpenAppServiceListQueryResponseModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArrayrecords = jsonObj.getAsJsonArray(SERIALIZED_NAME_RECORDS);
        if (jsonArrayrecords != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECORDS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `records` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECORDS).toString()));
            }
            for (int i = 0; i < jsonArrayrecords.size(); ++i) {
                StandardServiceBaseInfo.validateJsonObject(jsonArrayrecords.get(i).getAsJsonObject());
            }
        }
    }

    public static AlipayOpenAppServiceListQueryResponseModel fromJson(String jsonString) throws IOException {
        return (AlipayOpenAppServiceListQueryResponseModel)JSON.getGson().fromJson(jsonString, AlipayOpenAppServiceListQueryResponseModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PAGE_NUM);
        openapiFields.add(SERIALIZED_NAME_PAGE_SIZE);
        openapiFields.add(SERIALIZED_NAME_RECORDS);
        openapiFields.add(SERIALIZED_NAME_TOTAL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayOpenAppServiceListQueryResponseModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayOpenAppServiceListQueryResponseModel.class));
            return new TypeAdapter<AlipayOpenAppServiceListQueryResponseModel>(){

                public void write(JsonWriter out, AlipayOpenAppServiceListQueryResponseModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayOpenAppServiceListQueryResponseModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayOpenAppServiceListQueryResponseModel.validateJsonObject(jsonObj);
                    return (AlipayOpenAppServiceListQueryResponseModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

