/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.AppTokenExchangeSubElement;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayOpenAuthTokenAppResponseModel {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_APP_AUTH_TOKEN = "app_auth_token";
    @SerializedName(value="app_auth_token")
    private String appAuthToken;
    public static final String SERIALIZED_NAME_APP_REFRESH_TOKEN = "app_refresh_token";
    @SerializedName(value="app_refresh_token")
    private String appRefreshToken;
    public static final String SERIALIZED_NAME_AUTH_APP_ID = "auth_app_id";
    @SerializedName(value="auth_app_id")
    private String authAppId;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expires_in";
    @SerializedName(value="expires_in")
    private String expiresIn;
    public static final String SERIALIZED_NAME_RE_EXPIRES_IN = "re_expires_in";
    @SerializedName(value="re_expires_in")
    private String reExpiresIn;
    public static final String SERIALIZED_NAME_TOKENS = "tokens";
    @SerializedName(value="tokens")
    private List<AppTokenExchangeSubElement> tokens = null;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayOpenAuthTokenAppResponseModel appAuthToken(String appAuthToken) {
        this.appAuthToken = appAuthToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="201509BBeff9351ad1874306903e96b91d248A36", value="\u5e94\u7528\u6388\u6743\u4ee4\u724c")
    public String getAppAuthToken() {
        return this.appAuthToken;
    }

    public void setAppAuthToken(String appAuthToken) {
        this.appAuthToken = appAuthToken;
    }

    public AlipayOpenAuthTokenAppResponseModel appRefreshToken(String appRefreshToken) {
        this.appRefreshToken = appRefreshToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="201509BBdcba1e3347de4e75ba3fed2c9abebE36", value="\u5237\u65b0\u4ee4\u724c")
    public String getAppRefreshToken() {
        return this.appRefreshToken;
    }

    public void setAppRefreshToken(String appRefreshToken) {
        this.appRefreshToken = appRefreshToken;
    }

    public AlipayOpenAuthTokenAppResponseModel authAppId(String authAppId) {
        this.authAppId = authAppId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2013121100055554", value="\u6388\u6743\u5546\u6237\u7684appid")
    public String getAuthAppId() {
        return this.authAppId;
    }

    public void setAuthAppId(String authAppId) {
        this.authAppId = authAppId;
    }

    public AlipayOpenAuthTokenAppResponseModel expiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123456", value="\u8be5\u5b57\u6bb5\u5df2\u4f5c\u5e9f\uff0c\u5e94\u7528\u4ee4\u724c\u957f\u671f\u6709\u6548\uff0c\u63a5\u5165\u65b9\u4e0d\u9700\u8981\u6d88\u8d39\u8be5\u5b57\u6bb5")
    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public AlipayOpenAuthTokenAppResponseModel reExpiresIn(String reExpiresIn) {
        this.reExpiresIn = reExpiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123456", value="\u5237\u65b0\u4ee4\u724c\u7684\u6709\u6548\u65f6\u95f4\uff08\u4ece\u63a5\u53e3\u8c03\u7528\u65f6\u95f4\u4f5c\u4e3a\u8d77\u59cb\u65f6\u95f4\uff09\uff0c\u5355\u4f4d\u5230\u79d2")
    public String getReExpiresIn() {
        return this.reExpiresIn;
    }

    public void setReExpiresIn(String reExpiresIn) {
        this.reExpiresIn = reExpiresIn;
    }

    public AlipayOpenAuthTokenAppResponseModel tokens(List<AppTokenExchangeSubElement> tokens) {
        this.tokens = tokens;
        return this;
    }

    public AlipayOpenAuthTokenAppResponseModel addTokensItem(AppTokenExchangeSubElement tokensItem) {
        if (this.tokens == null) {
            this.tokens = new ArrayList<AppTokenExchangeSubElement>();
        }
        this.tokens.add(tokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u6279\u91cf\u6388\u6743\u6362\u7801\u8bbf\u95ee\u4ee4\u724c\u5217\u8868")
    public List<AppTokenExchangeSubElement> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<AppTokenExchangeSubElement> tokens) {
        this.tokens = tokens;
    }

    public AlipayOpenAuthTokenAppResponseModel userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2088102150527498", value="\u6388\u6743\u5546\u6237\u7684user_id")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayOpenAuthTokenAppResponseModel alipayOpenAuthTokenAppResponseModel = (AlipayOpenAuthTokenAppResponseModel)o;
        return Objects.equals(this.appAuthToken, alipayOpenAuthTokenAppResponseModel.appAuthToken) && Objects.equals(this.appRefreshToken, alipayOpenAuthTokenAppResponseModel.appRefreshToken) && Objects.equals(this.authAppId, alipayOpenAuthTokenAppResponseModel.authAppId) && Objects.equals(this.expiresIn, alipayOpenAuthTokenAppResponseModel.expiresIn) && Objects.equals(this.reExpiresIn, alipayOpenAuthTokenAppResponseModel.reExpiresIn) && Objects.equals(this.tokens, alipayOpenAuthTokenAppResponseModel.tokens) && Objects.equals(this.userId, alipayOpenAuthTokenAppResponseModel.userId);
    }

    public int hashCode() {
        return Objects.hash(this.appAuthToken, this.appRefreshToken, this.authAppId, this.expiresIn, this.reExpiresIn, this.tokens, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayOpenAuthTokenAppResponseModel {\n");
        sb.append("    appAuthToken: ").append(this.toIndentedString(this.appAuthToken)).append("\n");
        sb.append("    appRefreshToken: ").append(this.toIndentedString(this.appRefreshToken)).append("\n");
        sb.append("    authAppId: ").append(this.toIndentedString(this.authAppId)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    reExpiresIn: ").append(this.toIndentedString(this.reExpiresIn)).append("\n");
        sb.append("    tokens: ").append(this.toIndentedString(this.tokens)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayOpenAuthTokenAppResponseModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayOpenAuthTokenAppResponseModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APP_AUTH_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_APP_AUTH_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `app_auth_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APP_AUTH_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APP_REFRESH_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_APP_REFRESH_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `app_refresh_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APP_REFRESH_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_APP_ID) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_APP_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `auth_app_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTH_APP_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRES_IN) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRES_IN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expires_in` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRES_IN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RE_EXPIRES_IN) != null && !jsonObj.get(SERIALIZED_NAME_RE_EXPIRES_IN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `re_expires_in` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RE_EXPIRES_IN).toString()));
        }
        JsonArray jsonArraytokens = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOKENS);
        if (jsonArraytokens != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOKENS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tokens` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKENS).toString()));
            }
            for (int i = 0; i < jsonArraytokens.size(); ++i) {
                AppTokenExchangeSubElement.validateJsonObject(jsonArraytokens.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_ID) != null && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_ID).toString()));
        }
    }

    public static AlipayOpenAuthTokenAppResponseModel fromJson(String jsonString) throws IOException {
        return (AlipayOpenAuthTokenAppResponseModel)JSON.getGson().fromJson(jsonString, AlipayOpenAuthTokenAppResponseModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APP_AUTH_TOKEN);
        openapiFields.add(SERIALIZED_NAME_APP_REFRESH_TOKEN);
        openapiFields.add(SERIALIZED_NAME_AUTH_APP_ID);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_IN);
        openapiFields.add(SERIALIZED_NAME_RE_EXPIRES_IN);
        openapiFields.add(SERIALIZED_NAME_TOKENS);
        openapiFields.add(SERIALIZED_NAME_USER_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayOpenAuthTokenAppResponseModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayOpenAuthTokenAppResponseModel.class));
            return new TypeAdapter<AlipayOpenAuthTokenAppResponseModel>(){

                public void write(JsonWriter out, AlipayOpenAuthTokenAppResponseModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayOpenAuthTokenAppResponseModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayOpenAuthTokenAppResponseModel.validateJsonObject(jsonObj);
                    return (AlipayOpenAuthTokenAppResponseModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

