/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayPassInstanceUpdateErrorResponseModel;
import com.alipay.v3.model.CommonErrorType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class AlipayPassInstanceUpdateDefaultResponse
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(AlipayPassInstanceUpdateDefaultResponse.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public AlipayPassInstanceUpdateDefaultResponse() {
        super("anyOf", Boolean.FALSE);
    }

    public AlipayPassInstanceUpdateDefaultResponse(AlipayPassInstanceUpdateErrorResponseModel o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public AlipayPassInstanceUpdateDefaultResponse(CommonErrorType o) {
        super("anyOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof AlipayPassInstanceUpdateErrorResponseModel) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof CommonErrorType) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be AlipayPassInstanceUpdateErrorResponseModel, CommonErrorType");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public AlipayPassInstanceUpdateErrorResponseModel getAlipayPassInstanceUpdateErrorResponseModel() throws ClassCastException {
        return (AlipayPassInstanceUpdateErrorResponseModel)super.getActualInstance();
    }

    public CommonErrorType getCommonErrorType() throws ClassCastException {
        return (CommonErrorType)super.getActualInstance();
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        boolean validCount = false;
        try {
            AlipayPassInstanceUpdateErrorResponseModel.validateJsonObject(jsonObj);
            return;
        }
        catch (Exception exception) {
            try {
                CommonErrorType.validateJsonObject(jsonObj);
                return;
            }
            catch (Exception exception2) {
                if (!validCount) {
                    throw new IOException(String.format("The JSON string is invalid for AlipayPassInstanceUpdateDefaultResponse with anyOf schemas: AlipayPassInstanceUpdateErrorResponseModel, CommonErrorType. JSON: %s", jsonObj.toString()));
                }
                return;
            }
        }
    }

    public static AlipayPassInstanceUpdateDefaultResponse fromJson(String jsonString) throws IOException {
        return (AlipayPassInstanceUpdateDefaultResponse)JSON.getGson().fromJson(jsonString, AlipayPassInstanceUpdateDefaultResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("AlipayPassInstanceUpdateErrorResponseModel", (GenericType)new GenericType<AlipayPassInstanceUpdateErrorResponseModel>(){});
        schemas.put("CommonErrorType", (GenericType)new GenericType<CommonErrorType>(){});
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayPassInstanceUpdateDefaultResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterAlipayPassInstanceUpdateErrorResponseModel = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayPassInstanceUpdateErrorResponseModel.class));
            final TypeAdapter adapterCommonErrorType = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CommonErrorType.class));
            return new TypeAdapter<AlipayPassInstanceUpdateDefaultResponse>(){

                public void write(JsonWriter out, AlipayPassInstanceUpdateDefaultResponse value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof AlipayPassInstanceUpdateErrorResponseModel) {
                        JsonObject obj = adapterAlipayPassInstanceUpdateErrorResponseModel.toJsonTree((Object)((AlipayPassInstanceUpdateErrorResponseModel)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    if (value.getActualInstance() instanceof CommonErrorType) {
                        JsonObject obj = adapterCommonErrorType.toJsonTree((Object)((CommonErrorType)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemas: AlipayPassInstanceUpdateErrorResponseModel, CommonErrorType");
                }

                public AlipayPassInstanceUpdateDefaultResponse read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    try {
                        AlipayPassInstanceUpdateErrorResponseModel.validateJsonObject(jsonObject);
                        log.log(Level.FINER, "Input data matches schema 'AlipayPassInstanceUpdateErrorResponseModel'");
                        AlipayPassInstanceUpdateDefaultResponse ret = new AlipayPassInstanceUpdateDefaultResponse();
                        ret.setActualInstance(adapterAlipayPassInstanceUpdateErrorResponseModel.fromJsonTree((JsonElement)jsonObject));
                        return ret;
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, "Input data does not match schema 'AlipayPassInstanceUpdateErrorResponseModel'", e);
                        try {
                            CommonErrorType.validateJsonObject(jsonObject);
                            log.log(Level.FINER, "Input data matches schema 'CommonErrorType'");
                            AlipayPassInstanceUpdateDefaultResponse ret = new AlipayPassInstanceUpdateDefaultResponse();
                            ret.setActualInstance(adapterCommonErrorType.fromJsonTree((JsonElement)jsonObject));
                            return ret;
                        }
                        catch (Exception e2) {
                            log.log(Level.FINER, "Input data does not match schema 'CommonErrorType'", e2);
                            throw new IOException(String.format("Failed deserialization for AlipayPassInstanceUpdateDefaultResponse: no class matched. JSON: %s", jsonObject.toString()));
                        }
                    }
                }
            }.nullSafe();
        }
    }
}

