/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.AuthenticationResult;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayTradeApplepayAuthenticationSubmitModel {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AUTHENTICATION_RESULTS = "authentication_results";
    @SerializedName(value="authentication_results")
    private List<AuthenticationResult> authenticationResults = null;
    public static final String SERIALIZED_NAME_DEVICE_IDENTIFIER = "device_identifier";
    @SerializedName(value="device_identifier")
    private String deviceIdentifier;
    public static final String SERIALIZED_NAME_DPAN_IDENTIFIER = "dpan_identifier";
    @SerializedName(value="dpan_identifier")
    private String dpanIdentifier;
    public static final String SERIALIZED_NAME_TRANSACTION_IDENTIFIER = "transaction_identifier";
    @SerializedName(value="transaction_identifier")
    private String transactionIdentifier;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayTradeApplepayAuthenticationSubmitModel authenticationResults(List<AuthenticationResult> authenticationResults) {
        this.authenticationResults = authenticationResults;
        return this;
    }

    public AlipayTradeApplepayAuthenticationSubmitModel addAuthenticationResultsItem(AuthenticationResult authenticationResultsItem) {
        if (this.authenticationResults == null) {
            this.authenticationResults = new ArrayList<AuthenticationResult>();
        }
        this.authenticationResults.add(authenticationResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ApplePay\u6838\u8eab\u9274\u6743\u7ed3\u679c\uff0c\u5305\u62ec\uff1a\u652f\u4ed8\u5bc6\u7801\u3001\u7528\u6237\u786e\u8ba4\u3001\u6570\u5b57\u7b7e\u540d")
    public List<AuthenticationResult> getAuthenticationResults() {
        return this.authenticationResults;
    }

    public void setAuthenticationResults(List<AuthenticationResult> authenticationResults) {
        this.authenticationResults = authenticationResults;
    }

    public AlipayTradeApplepayAuthenticationSubmitModel deviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mKS9uBWMBT4Vv4+mgVLy7ZbMYer0XMHMfdqnOBVVr+b/iqNagFVjVWSGeSGOhDBi", value="Apple\u7aef\u7684\u8bbe\u5907ID")
    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public AlipayTradeApplepayAuthenticationSubmitModel dpanIdentifier(String dpanIdentifier) {
        this.dpanIdentifier = dpanIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="DAPLSM20191217003050010000320000001002", value="Apple\u7ed1\u5b9a\u7684BundleId")
    public String getDpanIdentifier() {
        return this.dpanIdentifier;
    }

    public void setDpanIdentifier(String dpanIdentifier) {
        this.dpanIdentifier = dpanIdentifier;
    }

    public AlipayTradeApplepayAuthenticationSubmitModel transactionIdentifier(String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020040422001424181400075556", value="\u4ea4\u6613\u6807\u8bc6")
    public String getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public void setTransactionIdentifier(String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayTradeApplepayAuthenticationSubmitModel alipayTradeApplepayAuthenticationSubmitModel = (AlipayTradeApplepayAuthenticationSubmitModel)o;
        return Objects.equals(this.authenticationResults, alipayTradeApplepayAuthenticationSubmitModel.authenticationResults) && Objects.equals(this.deviceIdentifier, alipayTradeApplepayAuthenticationSubmitModel.deviceIdentifier) && Objects.equals(this.dpanIdentifier, alipayTradeApplepayAuthenticationSubmitModel.dpanIdentifier) && Objects.equals(this.transactionIdentifier, alipayTradeApplepayAuthenticationSubmitModel.transactionIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationResults, this.deviceIdentifier, this.dpanIdentifier, this.transactionIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayTradeApplepayAuthenticationSubmitModel {\n");
        sb.append("    authenticationResults: ").append(this.toIndentedString(this.authenticationResults)).append("\n");
        sb.append("    deviceIdentifier: ").append(this.toIndentedString(this.deviceIdentifier)).append("\n");
        sb.append("    dpanIdentifier: ").append(this.toIndentedString(this.dpanIdentifier)).append("\n");
        sb.append("    transactionIdentifier: ").append(this.toIndentedString(this.transactionIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayTradeApplepayAuthenticationSubmitModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayTradeApplepayAuthenticationSubmitModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArrayauthenticationResults = jsonObj.getAsJsonArray(SERIALIZED_NAME_AUTHENTICATION_RESULTS);
        if (jsonArrayauthenticationResults != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `authentication_results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArrayauthenticationResults.size(); ++i) {
                AuthenticationResult.validateJsonObject(jsonArrayauthenticationResults.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `device_identifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_IDENTIFIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DPAN_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_DPAN_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `dpan_identifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DPAN_IDENTIFIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transaction_identifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_IDENTIFIER).toString()));
        }
    }

    public static AlipayTradeApplepayAuthenticationSubmitModel fromJson(String jsonString) throws IOException {
        return (AlipayTradeApplepayAuthenticationSubmitModel)JSON.getGson().fromJson(jsonString, AlipayTradeApplepayAuthenticationSubmitModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_RESULTS);
        openapiFields.add(SERIALIZED_NAME_DEVICE_IDENTIFIER);
        openapiFields.add(SERIALIZED_NAME_DPAN_IDENTIFIER);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_IDENTIFIER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayTradeApplepayAuthenticationSubmitModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayTradeApplepayAuthenticationSubmitModel.class));
            return new TypeAdapter<AlipayTradeApplepayAuthenticationSubmitModel>(){

                public void write(JsonWriter out, AlipayTradeApplepayAuthenticationSubmitModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayTradeApplepayAuthenticationSubmitModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayTradeApplepayAuthenticationSubmitModel.validateJsonObject(jsonObj);
                    return (AlipayTradeApplepayAuthenticationSubmitModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

