/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.BuyerPayDetail;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayTradeOrderPayModel {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ADVANCE_PAYMENT_TYPE = "advance_payment_type";
    @SerializedName(value="advance_payment_type")
    private String advancePaymentType;
    public static final String SERIALIZED_NAME_BUYER_ID = "buyer_id";
    @SerializedName(value="buyer_id")
    private String buyerId;
    public static final String SERIALIZED_NAME_BUYER_OPEN_ID = "buyer_open_id";
    @SerializedName(value="buyer_open_id")
    private String buyerOpenId;
    public static final String SERIALIZED_NAME_BUYER_PAY_DETAIL = "buyer_pay_detail";
    @SerializedName(value="buyer_pay_detail")
    private List<BuyerPayDetail> buyerPayDetail = null;
    public static final String SERIALIZED_NAME_FULFILLMENT_AMOUNT = "fulfillment_amount";
    @SerializedName(value="fulfillment_amount")
    private String fulfillmentAmount;
    public static final String SERIALIZED_NAME_IS_ASYNC_PAY = "is_async_pay";
    @SerializedName(value="is_async_pay")
    private Boolean isAsyncPay;
    public static final String SERIALIZED_NAME_ORDER_PAY_MODE = "order_pay_mode";
    @SerializedName(value="order_pay_mode")
    private String orderPayMode;
    public static final String SERIALIZED_NAME_OUT_REQUEST_NO = "out_request_no";
    @SerializedName(value="out_request_no")
    private String outRequestNo;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private String totalAmount;
    public static final String SERIALIZED_NAME_TRADE_NO = "trade_no";
    @SerializedName(value="trade_no")
    private String tradeNo;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayTradeOrderPayModel advancePaymentType(String advancePaymentType) {
        this.advancePaymentType = advancePaymentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CREDIT_FULFILLMENT_ZM", value="\u57ab\u8d44\u652f\u4ed8\u6a21\u5f0f\u3002\u652f\u4ed8\u65f6\u9700\u8981\u57ab\u8d44\u7684\u573a\u666f\u624d\u4f20\u5165\u3002\u5177\u4f53\u4f20\u53c2\u9700\u4e0e\u652f\u4ed8\u5b9d\u7ea6\u5b9a\u3002 CREDIT_FULFILLMENT_ZM \u8868\u793a\u5148\u7528\u540e\u4ed8\u4ea7\u54c1\u5c65\u7ea6\u52a8\u4f5c\u652f\u6301\u829d\u9ebb\u57ab\u8d44\u3002")
    public String getAdvancePaymentType() {
        return this.advancePaymentType;
    }

    public void setAdvancePaymentType(String advancePaymentType) {
        this.advancePaymentType = advancePaymentType;
    }

    public AlipayTradeOrderPayModel buyerId(String buyerId) {
        this.buyerId = buyerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2088202954065786", value="\u4e70\u5bb6\u7684\u652f\u4ed8\u5b9d\u7528\u6237id    \u6ce8\uff1a  1.\u7528\u4e8e\u6821\u9a8c\u4e0e\u5df2\u5b58\u4ea4\u6613\u4e2d\u7684\u4e70\u5bb6\u662f\u5426\u76f8\u7b49")
    public String getBuyerId() {
        return this.buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public AlipayTradeOrderPayModel buyerOpenId(String buyerOpenId) {
        this.buyerOpenId = buyerOpenId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="074a1CcTG1LelxKe4xQC0zgNdId0nxi95b5lsNpazWYoCo5", value="\u4e70\u5bb6\u652f\u4ed8\u5b9d\u7528\u6237\u552f\u4e00\u6807\u8bc6  \u6ce8\uff1a 1.\u7528\u4e8e\u6821\u9a8c\u4e0e\u5df2\u5b58\u4ea4\u6613\u4e2d\u7684\u4e70\u5bb6\u662f\u5426\u76f8\u7b49")
    public String getBuyerOpenId() {
        return this.buyerOpenId;
    }

    public void setBuyerOpenId(String buyerOpenId) {
        this.buyerOpenId = buyerOpenId;
    }

    public AlipayTradeOrderPayModel buyerPayDetail(List<BuyerPayDetail> buyerPayDetail) {
        this.buyerPayDetail = buyerPayDetail;
        return this;
    }

    public AlipayTradeOrderPayModel addBuyerPayDetailItem(BuyerPayDetail buyerPayDetailItem) {
        if (this.buyerPayDetail == null) {
            this.buyerPayDetail = new ArrayList<BuyerPayDetail>();
        }
        this.buyerPayDetail.add(buyerPayDetailItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u4e70\u5bb6\u652f\u4ed8\u660e\u7ec6    \u76ee\u524d\u652f\u6301\u7684\u652f\u4ed8\u6e20\u9053\u4e3a\uff1a  - offline_pos\uff1a\u672c\u6b21\u4e70\u5bb6\u4f7f\u7528\u7684\u662fpos\u5237\u5361\u652f\u4ed8    \u6ce8\uff1a  \u5404\u652f\u4ed8\u5de5\u5177\u91d1\u989d\u603b\u548c=\u8ba2\u5355\u603b\u91d1\u989d")
    public List<BuyerPayDetail> getBuyerPayDetail() {
        return this.buyerPayDetail;
    }

    public void setBuyerPayDetail(List<BuyerPayDetail> buyerPayDetail) {
        this.buyerPayDetail = buyerPayDetail;
    }

    public AlipayTradeOrderPayModel fulfillmentAmount(String fulfillmentAmount) {
        this.fulfillmentAmount = fulfillmentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="88.88", value="\u672c\u6b21\u5c65\u7ea6\u652f\u4ed8\u91d1\u989d\uff0c\u5355\u4f4d\u4e3a\u5143\uff0c\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\u3002\u5c65\u7ea6\u652f\u4ed8\u573a\u666f\u624d\u9700\u8981\u4f20\u5165\u3002")
    public String getFulfillmentAmount() {
        return this.fulfillmentAmount;
    }

    public void setFulfillmentAmount(String fulfillmentAmount) {
        this.fulfillmentAmount = fulfillmentAmount;
    }

    public AlipayTradeOrderPayModel isAsyncPay(Boolean isAsyncPay) {
        this.isAsyncPay = isAsyncPay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="\u662f\u5426\u5f02\u6b65\u652f\u4ed8\uff0c\u4f20\u5165true\u65f6\uff0c\u8868\u660e\u672c\u6b21\u671f\u671b\u8d70\u5f02\u6b65\u652f\u4ed8\uff0c\u4f1a\u5148\u5c06\u652f\u4ed8\u8bf7\u6c42\u53d7\u7406\u4e0b\u6765\uff0c\u518d\u5f02\u6b65\u63a8\u8fdb\u3002\u5546\u6237\u53ef\u4ee5\u901a\u8fc7\u4ea4\u6613\u7684\u5f02\u6b65\u901a\u77e5\u6216\u8005\u8f6e\u8be2\u4ea4\u6613\u7684\u72b6\u6001\u6765\u786e\u5b9a\u6700\u7ec8\u7684\u4ea4\u6613\u7ed3\u679c")
    public Boolean getIsAsyncPay() {
        return this.isAsyncPay;
    }

    public void setIsAsyncPay(Boolean isAsyncPay) {
        this.isAsyncPay = isAsyncPay;
    }

    public AlipayTradeOrderPayModel orderPayMode(String orderPayMode) {
        this.orderPayMode = orderPayMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CREDIT_FULFILLMENT_ZM", value="\u8ba2\u5355\u652f\u4ed8\u6a21\u5f0f\u3002\u7279\u6b8a\u652f\u4ed8\u573a\u666f\u624d\u9700\u8981\u4f20\u5165\u3002\u5177\u4f53\u4f20\u53c2\u9700\u4e0e\u652f\u4ed8\u5b9d\u7ea6\u5b9a\u3002 CREDIT_FULFILLMENT_ZM\u8868\u793a\u57fa\u4e8e\u829d\u9ebb\u6388\u4fe1\u7684\u5c65\u7ea6\u652f\u4ed8\u6a21\u5f0f\uff0c\u6bd4\u5982\u829d\u9ebb\u5148\u7528\u540e\u4ed8\u4ea7\u54c1\u3002")
    public String getOrderPayMode() {
        return this.orderPayMode;
    }

    public void setOrderPayMode(String orderPayMode) {
        this.orderPayMode = orderPayMode;
    }

    public AlipayTradeOrderPayModel outRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="20200320010101001", value="\u5546\u6237\u8bf7\u6c42\u53f7\uff0c\u6807\u8bc6\u4e00\u6b21\u8bf7\u6c42\u7684\u552f\u4e00id\uff0c\u7528\u4e8e\u5e42\u7b49\u63a7\u5236\u3002")
    public String getOutRequestNo() {
        return this.outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public AlipayTradeOrderPayModel productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SETTLE_OFFLINE_GROUP", value="\u9500\u552e\u4ea7\u54c1\u7801")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public AlipayTradeOrderPayModel totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="88.88", value="\u8ba2\u5355\u603b\u91d1\u989d\uff0c\u5355\u4f4d\u4e3a\u5143\uff0c\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\uff0c\u53d6\u503c\u8303\u56f4[0.01,100000000]    \u6ce8\uff1a  1.\u7528\u4e8e\u6821\u9a8c\u4e0e\u5df2\u5b58\u4ea4\u6613\u4e2d\u7684\u91d1\u989d\u662f\u5426\u76f8\u7b49")
    public String getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public AlipayTradeOrderPayModel tradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2018062721001004150200645134", value="\u652f\u4ed8\u5b9d\u4ea4\u6613\u53f7")
    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayTradeOrderPayModel alipayTradeOrderPayModel = (AlipayTradeOrderPayModel)o;
        return Objects.equals(this.advancePaymentType, alipayTradeOrderPayModel.advancePaymentType) && Objects.equals(this.buyerId, alipayTradeOrderPayModel.buyerId) && Objects.equals(this.buyerOpenId, alipayTradeOrderPayModel.buyerOpenId) && Objects.equals(this.buyerPayDetail, alipayTradeOrderPayModel.buyerPayDetail) && Objects.equals(this.fulfillmentAmount, alipayTradeOrderPayModel.fulfillmentAmount) && Objects.equals(this.isAsyncPay, alipayTradeOrderPayModel.isAsyncPay) && Objects.equals(this.orderPayMode, alipayTradeOrderPayModel.orderPayMode) && Objects.equals(this.outRequestNo, alipayTradeOrderPayModel.outRequestNo) && Objects.equals(this.productCode, alipayTradeOrderPayModel.productCode) && Objects.equals(this.totalAmount, alipayTradeOrderPayModel.totalAmount) && Objects.equals(this.tradeNo, alipayTradeOrderPayModel.tradeNo);
    }

    public int hashCode() {
        return Objects.hash(this.advancePaymentType, this.buyerId, this.buyerOpenId, this.buyerPayDetail, this.fulfillmentAmount, this.isAsyncPay, this.orderPayMode, this.outRequestNo, this.productCode, this.totalAmount, this.tradeNo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayTradeOrderPayModel {\n");
        sb.append("    advancePaymentType: ").append(this.toIndentedString(this.advancePaymentType)).append("\n");
        sb.append("    buyerId: ").append(this.toIndentedString(this.buyerId)).append("\n");
        sb.append("    buyerOpenId: ").append(this.toIndentedString(this.buyerOpenId)).append("\n");
        sb.append("    buyerPayDetail: ").append(this.toIndentedString(this.buyerPayDetail)).append("\n");
        sb.append("    fulfillmentAmount: ").append(this.toIndentedString(this.fulfillmentAmount)).append("\n");
        sb.append("    isAsyncPay: ").append(this.toIndentedString(this.isAsyncPay)).append("\n");
        sb.append("    orderPayMode: ").append(this.toIndentedString(this.orderPayMode)).append("\n");
        sb.append("    outRequestNo: ").append(this.toIndentedString(this.outRequestNo)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    tradeNo: ").append(this.toIndentedString(this.tradeNo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayTradeOrderPayModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayTradeOrderPayModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADVANCE_PAYMENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ADVANCE_PAYMENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `advance_payment_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADVANCE_PAYMENT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUYER_ID) != null && !jsonObj.get(SERIALIZED_NAME_BUYER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `buyer_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUYER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUYER_OPEN_ID) != null && !jsonObj.get(SERIALIZED_NAME_BUYER_OPEN_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `buyer_open_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUYER_OPEN_ID).toString()));
        }
        JsonArray jsonArraybuyerPayDetail = jsonObj.getAsJsonArray(SERIALIZED_NAME_BUYER_PAY_DETAIL);
        if (jsonArraybuyerPayDetail != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BUYER_PAY_DETAIL).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `buyer_pay_detail` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUYER_PAY_DETAIL).toString()));
            }
            for (int i = 0; i < jsonArraybuyerPayDetail.size(); ++i) {
                BuyerPayDetail.validateJsonObject(jsonArraybuyerPayDetail.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FULFILLMENT_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_FULFILLMENT_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fulfillment_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FULFILLMENT_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_PAY_MODE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_PAY_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `order_pay_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_PAY_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUT_REQUEST_NO) != null && !jsonObj.get(SERIALIZED_NAME_OUT_REQUEST_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `out_request_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUT_REQUEST_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `product_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOTAL_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_TOTAL_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `total_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOTAL_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRADE_NO) != null && !jsonObj.get(SERIALIZED_NAME_TRADE_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trade_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRADE_NO).toString()));
        }
    }

    public static AlipayTradeOrderPayModel fromJson(String jsonString) throws IOException {
        return (AlipayTradeOrderPayModel)JSON.getGson().fromJson(jsonString, AlipayTradeOrderPayModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADVANCE_PAYMENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_BUYER_ID);
        openapiFields.add(SERIALIZED_NAME_BUYER_OPEN_ID);
        openapiFields.add(SERIALIZED_NAME_BUYER_PAY_DETAIL);
        openapiFields.add(SERIALIZED_NAME_FULFILLMENT_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_IS_ASYNC_PAY);
        openapiFields.add(SERIALIZED_NAME_ORDER_PAY_MODE);
        openapiFields.add(SERIALIZED_NAME_OUT_REQUEST_NO);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_CODE);
        openapiFields.add(SERIALIZED_NAME_TOTAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TRADE_NO);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayTradeOrderPayModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayTradeOrderPayModel.class));
            return new TypeAdapter<AlipayTradeOrderPayModel>(){

                public void write(JsonWriter out, AlipayTradeOrderPayModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayTradeOrderPayModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayTradeOrderPayModel.validateJsonObject(jsonObj);
                    return (AlipayTradeOrderPayModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

