/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class OpenidComplex {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_JSON_STRING = "json_string";
    @SerializedName(value="json_string")
    private String jsonString;
    public static final String SERIALIZED_NAME_OPEN_ID_LIST = "open_id_list";
    @SerializedName(value="open_id_list")
    private List<String> openIdList = null;
    public static final String SERIALIZED_NAME_OPENID = "openid";
    @SerializedName(value="openid")
    private String openid;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private String uid;
    public static final String SERIALIZED_NAME_UID_LIST = "uid_list";
    @SerializedName(value="uid_list")
    private List<String> uidList = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OpenidComplex jsonString(String jsonString) {
        this.jsonString = jsonString;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{}", value="11")
    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public OpenidComplex openIdList(List<String> openIdList) {
        this.openIdList = openIdList;
        return this;
    }

    public OpenidComplex addOpenIdListItem(String openIdListItem) {
        if (this.openIdList == null) {
            this.openIdList = new ArrayList<String>();
        }
        this.openIdList.add(openIdListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"074a1CcTG1LelxKe4xQC0zgNdId0nxi95b5lsNpazWYoCo5\"]", value="1")
    public List<String> getOpenIdList() {
        return this.openIdList;
    }

    public void setOpenIdList(List<String> openIdList) {
        this.openIdList = openIdList;
    }

    public OpenidComplex openid(String openid) {
        this.openid = openid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="074a1CcTG1LelxKe4xQC0zgNdId0nxi95b5lsNpazWYoCo5", value="11")
    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public OpenidComplex uid(String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2088502241306951", value="11")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public OpenidComplex uidList(List<String> uidList) {
        this.uidList = uidList;
        return this;
    }

    public OpenidComplex addUidListItem(String uidListItem) {
        if (this.uidList == null) {
            this.uidList = new ArrayList<String>();
        }
        this.uidList.add(uidListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"2088502241306951\"]", value="1")
    public List<String> getUidList() {
        return this.uidList;
    }

    public void setUidList(List<String> uidList) {
        this.uidList = uidList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenidComplex openidComplex = (OpenidComplex)o;
        return Objects.equals(this.jsonString, openidComplex.jsonString) && Objects.equals(this.openIdList, openidComplex.openIdList) && Objects.equals(this.openid, openidComplex.openid) && Objects.equals(this.uid, openidComplex.uid) && Objects.equals(this.uidList, openidComplex.uidList);
    }

    public int hashCode() {
        return Objects.hash(this.jsonString, this.openIdList, this.openid, this.uid, this.uidList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenidComplex {\n");
        sb.append("    jsonString: ").append(this.toIndentedString(this.jsonString)).append("\n");
        sb.append("    openIdList: ").append(this.toIndentedString(this.openIdList)).append("\n");
        sb.append("    openid: ").append(this.toIndentedString(this.openid)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    uidList: ").append(this.toIndentedString(this.uidList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OpenidComplex is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OpenidComplex` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_JSON_STRING) != null && !jsonObj.get(SERIALIZED_NAME_JSON_STRING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `json_string` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JSON_STRING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPEN_ID_LIST) != null && !jsonObj.get(SERIALIZED_NAME_OPEN_ID_LIST).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `open_id_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPEN_ID_LIST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPENID) != null && !jsonObj.get(SERIALIZED_NAME_OPENID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `openid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPENID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UID) != null && !jsonObj.get(SERIALIZED_NAME_UID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UID_LIST) != null && !jsonObj.get(SERIALIZED_NAME_UID_LIST).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `uid_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UID_LIST).toString()));
        }
    }

    public static OpenidComplex fromJson(String jsonString) throws IOException {
        return (OpenidComplex)JSON.getGson().fromJson(jsonString, OpenidComplex.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_JSON_STRING);
        openapiFields.add(SERIALIZED_NAME_OPEN_ID_LIST);
        openapiFields.add(SERIALIZED_NAME_OPENID);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiFields.add(SERIALIZED_NAME_UID_LIST);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OpenidComplex.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OpenidComplex.class));
            return new TypeAdapter<OpenidComplex>(){

                public void write(JsonWriter out, OpenidComplex value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OpenidComplex read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OpenidComplex.validateJsonObject(jsonObj);
                    return (OpenidComplex)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

