/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.AccountQuotaDetail;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class QuotaQueryResponse {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AGREEMENT_NO = "agreement_no";
    @SerializedName(value="agreement_no")
    private String agreementNo;
    public static final String SERIALIZED_NAME_ERROR_CODE = "error_code";
    @SerializedName(value="error_code")
    private String errorCode;
    public static final String SERIALIZED_NAME_FAIL_REASON = "fail_reason";
    @SerializedName(value="fail_reason")
    private String failReason;
    public static final String SERIALIZED_NAME_QUOTA_DETAILS = "quota_details";
    @SerializedName(value="quota_details")
    private AccountQuotaDetail quotaDetails;
    public static final String SERIALIZED_NAME_SUCCESS = "success";
    @SerializedName(value="success")
    private String success;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public QuotaQueryResponse agreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="20205321001042231004", value="\u534f\u8bae\u53f7")
    public String getAgreementNo() {
        return this.agreementNo;
    }

    public void setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
    }

    public QuotaQueryResponse errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="INVALID_AGREEMENT", value="\u5355\u4e2a\u534f\u8bae\u67e5\u8be2\u7ed3\u679c\u9519\u8bef\u7801")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public QuotaQueryResponse failReason(String failReason) {
        this.failReason = failReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u65e0\u6548\u7684\u4e09\u65b9\u534f\u8bae", value="\u5355\u4e2a\u534f\u8bae\u54cd\u5e94\u9519\u8bef\u63cf\u8ff0")
    public String getFailReason() {
        return this.failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public QuotaQueryResponse quotaDetails(AccountQuotaDetail quotaDetails) {
        this.quotaDetails = quotaDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountQuotaDetail getQuotaDetails() {
        return this.quotaDetails;
    }

    public void setQuotaDetails(AccountQuotaDetail quotaDetails) {
        this.quotaDetails = quotaDetails;
    }

    public QuotaQueryResponse success(String success) {
        this.success = success;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="\u5355\u4e2a\u534f\u8bae\u67e5\u8be2\u7ed3\u679c\u662f\u5426\u6210\u529f")
    public String getSuccess() {
        return this.success;
    }

    public void setSuccess(String success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotaQueryResponse quotaQueryResponse = (QuotaQueryResponse)o;
        return Objects.equals(this.agreementNo, quotaQueryResponse.agreementNo) && Objects.equals(this.errorCode, quotaQueryResponse.errorCode) && Objects.equals(this.failReason, quotaQueryResponse.failReason) && Objects.equals(this.quotaDetails, quotaQueryResponse.quotaDetails) && Objects.equals(this.success, quotaQueryResponse.success);
    }

    public int hashCode() {
        return Objects.hash(this.agreementNo, this.errorCode, this.failReason, this.quotaDetails, this.success);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuotaQueryResponse {\n");
        sb.append("    agreementNo: ").append(this.toIndentedString(this.agreementNo)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    failReason: ").append(this.toIndentedString(this.failReason)).append("\n");
        sb.append("    quotaDetails: ").append(this.toIndentedString(this.quotaDetails)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in QuotaQueryResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `QuotaQueryResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AGREEMENT_NO) != null && !jsonObj.get(SERIALIZED_NAME_AGREEMENT_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `agreement_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AGREEMENT_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `error_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FAIL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_FAIL_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fail_reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAIL_REASON).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_QUOTA_DETAILS) != null) {
            AccountQuotaDetail.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_QUOTA_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUCCESS) != null && !jsonObj.get(SERIALIZED_NAME_SUCCESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `success` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUCCESS).toString()));
        }
    }

    public static QuotaQueryResponse fromJson(String jsonString) throws IOException {
        return (QuotaQueryResponse)JSON.getGson().fromJson(jsonString, QuotaQueryResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AGREEMENT_NO);
        openapiFields.add(SERIALIZED_NAME_ERROR_CODE);
        openapiFields.add(SERIALIZED_NAME_FAIL_REASON);
        openapiFields.add(SERIALIZED_NAME_QUOTA_DETAILS);
        openapiFields.add(SERIALIZED_NAME_SUCCESS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!QuotaQueryResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(QuotaQueryResponse.class));
            return new TypeAdapter<QuotaQueryResponse>(){

                public void write(JsonWriter out, QuotaQueryResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public QuotaQueryResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    QuotaQueryResponse.validateJsonObject(jsonObj);
                    return (QuotaQueryResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

