/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.ItemSkuPropertyInfo;
import com.alipay.v3.model.MaterialCreateInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class SkuCreateInfo {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_INVENTORY = "inventory";
    @SerializedName(value="inventory")
    private Integer inventory;
    public static final String SERIALIZED_NAME_MATERIAL_LIST = "material_list";
    @SerializedName(value="material_list")
    private List<MaterialCreateInfo> materialList = null;
    public static final String SERIALIZED_NAME_ORIGINAL_PRICE = "original_price";
    @SerializedName(value="original_price")
    private Integer originalPrice;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Integer price;
    public static final String SERIALIZED_NAME_PROPERTY_LIST = "property_list";
    @SerializedName(value="property_list")
    private List<ItemSkuPropertyInfo> propertyList = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SkuCreateInfo inventory(Integer inventory) {
        this.inventory = inventory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="\u5e93\u5b58")
    public Integer getInventory() {
        return this.inventory;
    }

    public void setInventory(Integer inventory) {
        this.inventory = inventory;
    }

    public SkuCreateInfo materialList(List<MaterialCreateInfo> materialList) {
        this.materialList = materialList;
        return this;
    }

    public SkuCreateInfo addMaterialListItem(MaterialCreateInfo materialListItem) {
        if (this.materialList == null) {
            this.materialList = new ArrayList<MaterialCreateInfo>();
        }
        this.materialList.add(materialListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SKU\u7d20\u6750\u5217\u8868\uff08\u6700\u591a3\u4e2a\uff09")
    public List<MaterialCreateInfo> getMaterialList() {
        return this.materialList;
    }

    public void setMaterialList(List<MaterialCreateInfo> materialList) {
        this.materialList = materialList;
    }

    public SkuCreateInfo originalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="\u6807\u4ef7\uff0c\u5355\u4f4d\u5206")
    public Integer getOriginalPrice() {
        return this.originalPrice;
    }

    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    public SkuCreateInfo price(Integer price) {
        this.price = price;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="\u552e\u4ef7\uff0c\u5355\u4f4d\u5206")
    public Integer getPrice() {
        return this.price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public SkuCreateInfo propertyList(List<ItemSkuPropertyInfo> propertyList) {
        this.propertyList = propertyList;
        return this;
    }

    public SkuCreateInfo addPropertyListItem(ItemSkuPropertyInfo propertyListItem) {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList<ItemSkuPropertyInfo>();
        }
        this.propertyList.add(propertyListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SKU\u5c5e\u6027\u5217\u8868")
    public List<ItemSkuPropertyInfo> getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(List<ItemSkuPropertyInfo> propertyList) {
        this.propertyList = propertyList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkuCreateInfo skuCreateInfo = (SkuCreateInfo)o;
        return Objects.equals(this.inventory, skuCreateInfo.inventory) && Objects.equals(this.materialList, skuCreateInfo.materialList) && Objects.equals(this.originalPrice, skuCreateInfo.originalPrice) && Objects.equals(this.price, skuCreateInfo.price) && Objects.equals(this.propertyList, skuCreateInfo.propertyList);
    }

    public int hashCode() {
        return Objects.hash(this.inventory, this.materialList, this.originalPrice, this.price, this.propertyList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SkuCreateInfo {\n");
        sb.append("    inventory: ").append(this.toIndentedString(this.inventory)).append("\n");
        sb.append("    materialList: ").append(this.toIndentedString(this.materialList)).append("\n");
        sb.append("    originalPrice: ").append(this.toIndentedString(this.originalPrice)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    propertyList: ").append(this.toIndentedString(this.propertyList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraypropertyList;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SkuCreateInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SkuCreateInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArraymaterialList = jsonObj.getAsJsonArray(SERIALIZED_NAME_MATERIAL_LIST);
        if (jsonArraymaterialList != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MATERIAL_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `material_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MATERIAL_LIST).toString()));
            }
            for (int i = 0; i < jsonArraymaterialList.size(); ++i) {
                MaterialCreateInfo.validateJsonObject(jsonArraymaterialList.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraypropertyList = jsonObj.getAsJsonArray(SERIALIZED_NAME_PROPERTY_LIST)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PROPERTY_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `property_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROPERTY_LIST).toString()));
            }
            for (int i = 0; i < jsonArraypropertyList.size(); ++i) {
                ItemSkuPropertyInfo.validateJsonObject(jsonArraypropertyList.get(i).getAsJsonObject());
            }
        }
    }

    public static SkuCreateInfo fromJson(String jsonString) throws IOException {
        return (SkuCreateInfo)JSON.getGson().fromJson(jsonString, SkuCreateInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INVENTORY);
        openapiFields.add(SERIALIZED_NAME_MATERIAL_LIST);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_PRICE);
        openapiFields.add(SERIALIZED_NAME_PRICE);
        openapiFields.add(SERIALIZED_NAME_PROPERTY_LIST);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SkuCreateInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SkuCreateInfo.class));
            return new TypeAdapter<SkuCreateInfo>(){

                public void write(JsonWriter out, SkuCreateInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SkuCreateInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SkuCreateInfo.validateJsonObject(jsonObj);
                    return (SkuCreateInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

