/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.util;

import com.alipay.v3.ApiException;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class AlipayConfigUtil {
    private String appId;
    private String charset = "utf-8";
    private String privateKey;
    private String alipayPublicKey;
    private String rootCertContent;
    private String rootCertSN;
    private String appCertSN;
    private ConcurrentHashMap<String, String> cachedAlipayPublicKey = new ConcurrentHashMap();
    private String encryptType = "AES";
    private String encryptKey;
    public static final String RSA = "RSA";
    public static final String SHA_256_WITH_RSA = "SHA256WithRSA";
    public static final String ALIPAY_SHA_256_WITH_RSA = "ALIPAY-SHA256withRSA";
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = AlipayConfigUtil.initIV();
    private static final int MAX_ENCRYPT_BLOCK_SIZE = 244;
    private static final int MAX_DECRYPT_BLOCK_SIZE = 256;

    public void sign(String httpMethod, String httpRequestUri, String httpRequestBody, Map<String, String> headerParams) throws ApiException {
        if (Strings.isNullOrEmpty((String)this.privateKey)) {
            throw new ApiException("\u79c1\u94a5[privateKey]\u4e0d\u53ef\u4e3a\u7a7a");
        }
        String appAuthToken = headerParams.get("alipay-app-auth-token");
        String nonce = UUID.randomUUID().toString();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String authString = "app_id=" + this.appId + (Strings.isNullOrEmpty((String)this.appCertSN) ? "" : ",app_cert_sn=" + this.appCertSN) + ",nonce=" + nonce + ",timestamp=" + timestamp;
        String content = authString + "\n" + httpMethod + "\n" + httpRequestUri + "\n" + (Strings.isNullOrEmpty((String)httpRequestBody) ? "" : httpRequestBody) + "\n" + (Strings.isNullOrEmpty((String)appAuthToken) ? "" : appAuthToken + "\n");
        headerParams.put("Authorization", "ALIPAY-SHA256withRSA " + authString + ",sign=" + this.generateSign(content));
        if (!Strings.isNullOrEmpty((String)this.rootCertSN)) {
            headerParams.put("alipay-root-cert-sn", this.rootCertSN);
        }
    }

    public String generateSign(String content) throws ApiException {
        try {
            byte[] encodedKey = this.privateKey.getBytes();
            encodedKey = Base64.decode((byte[])encodedKey);
            PrivateKey priKey = KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SHA_256_WITH_RSA);
            signature.initSign(priKey);
            signature.update(content.getBytes(this.charset));
            byte[] signed = signature.sign();
            return new String(Base64.encode((byte[])signed));
        }
        catch (Exception e) {
            String errorMessage = "\u7b7e\u540d\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u79c1\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002content=" + content + " privateKeySize=" + this.privateKey.length() + " reason=" + e.getMessage();
            throw new ApiException(errorMessage);
        }
    }

    public boolean verify(String content, String sign, String alipayCertSN, String timestamp, String nonce) throws ApiException {
        String alipayPublicKey = this.alipayPublicKey;
        if (!Strings.isNullOrEmpty((String)this.appCertSN)) {
            alipayPublicKey = this.getAlipayPublicKey(alipayCertSN);
        }
        if (Strings.isNullOrEmpty((String)alipayPublicKey)) {
            throw new ApiException("\u516c\u94a5\u4e0d\u53ef\u4e3a\u7a7a");
        }
        content = timestamp + "\n" + nonce + "\n" + (content == null ? "" : content) + "\n";
        return this.generateVerify(content, sign, alipayPublicKey);
    }

    public boolean generateVerify(String content, String sign, String alipayPublicKey) throws ApiException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            byte[] encodedKey = alipayPublicKey.getBytes();
            encodedKey = Base64.decode((byte[])encodedKey);
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SHA_256_WITH_RSA);
            signature.initVerify(publicKey);
            signature.update(content.getBytes(this.charset));
            return signature.verify(Base64.decode((byte[])sign.getBytes()));
        }
        catch (Exception e) {
            String errorMessage = "\u9a8c\u7b7e\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u516c\u94a5\u683c\u5f0f\u6216\u7b7e\u540d\u662f\u5426\u6b63\u786e\u3002content=" + content + " sign=" + sign + " publicKey=" + alipayPublicKey + " reason=" + e.getMessage();
            throw new ApiException(errorMessage);
        }
    }

    private String getAlipayPublicKey(String sn) throws ApiException {
        if (Strings.isNullOrEmpty((String)sn)) {
            return this.cachedAlipayPublicKey.values().iterator().next();
        }
        if (this.cachedAlipayPublicKey.containsKey(sn)) {
            return this.cachedAlipayPublicKey.get(sn);
        }
        throw new ApiException("\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66[" + sn + "]\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6700\u65b0\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66\u5e76\u66ff\u6362\u539f\u8bc1\u4e66\u6587\u4ef6");
    }

    public String encrypt(String plainText, Map<String, String> headerParams) throws ApiException {
        if (Strings.isNullOrEmpty((String)this.encryptKey)) {
            return plainText;
        }
        if (!AES_ALG.equals(this.encryptType)) {
            throw new ApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aencryptType=" + this.encryptType);
        }
        headerParams.put("alipay-encrypt-type", this.encryptType);
        String contentType = headerParams.get("Content-Type");
        if (!"multipart/form-data".equals(contentType)) {
            headerParams.put("Content-Type", "text/plain");
        }
        if (Strings.isNullOrEmpty((String)plainText)) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)new SecretKeySpec(Base64.decode((byte[])this.encryptKey.getBytes()), AES_ALG), iv);
            byte[] encryptBytes = cipher.doFinal(plainText.getBytes(this.charset));
            return new String(Base64.encode((byte[])encryptBytes));
        }
        catch (Exception e) {
            throw new ApiException("AES\u52a0\u5bc6\u5931\u8d25\uff0cplainText=" + plainText + "\uff0ckeySize=" + this.encryptKey.length() + "\u3002" + e.getMessage());
        }
    }

    public String decrypt(String cipherText) throws ApiException {
        if (Strings.isNullOrEmpty((String)this.encryptKey)) {
            return cipherText;
        }
        if (!AES_ALG.equals(this.encryptType)) {
            throw new ApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aencrypeType=" + this.encryptType);
        }
        if (Strings.isNullOrEmpty((String)cipherText)) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(2, (Key)new SecretKeySpec(Base64.decode((byte[])this.encryptKey.getBytes()), AES_ALG), iv);
            byte[] cleanBytes = cipher.doFinal(Base64.decode((byte[])cipherText.getBytes()));
            return new String(cleanBytes, this.charset);
        }
        catch (Exception e) {
            throw new ApiException("AES\u89e3\u5bc6\u5931\u8d25\uff0ccipherText=" + cipherText + "\uff0ckeySize=" + this.encryptKey.length() + "\u3002" + e.getMessage());
        }
    }

    public String doDecrypt(String cipherTextBase64) throws ApiException {
        try {
            byte[] encodedKey = this.privateKey.getBytes();
            encodedKey = Base64.decode((byte[])encodedKey);
            PrivateKey privateKey = KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(2, privateKey);
            byte[] encryptedData = Base64.decode((byte[])cipherTextBase64.getBytes(this.charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptedData, offSet, 256) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 256;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return new String(decryptedData, this.charset);
        }
        catch (Exception e) {
            String errorMessage = "RSA2\u975e\u5bf9\u79f0\u89e3\u5bc6\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u79c1\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002cipherTextBase64=" + cipherTextBase64 + " privateKeySize=" + this.privateKey.length() + " reason=" + e.getMessage();
            throw new ApiException(errorMessage);
        }
    }

    public String doEncrypt(String plainText) throws ApiException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            byte[] encodedKey = this.alipayPublicKey.getBytes();
            encodedKey = Base64.decode((byte[])encodedKey);
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(1, publicKey);
            byte[] data = plainText.getBytes(this.charset);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 244 ? cipher.doFinal(data, offSet, 244) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 244;
            }
            byte[] encryptedData = Base64.encode((byte[])out.toByteArray());
            out.close();
            return new String(encryptedData, this.charset);
        }
        catch (Exception e) {
            String errorMessage = "RSA2\u975e\u5bf9\u79f0\u52a0\u5bc6\u906d\u9047\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u516c\u94a5\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002plainText=" + plainText + " publicKey=" + this.alipayPublicKey + " reason=" + e.getMessage();
            throw new ApiException(errorMessage);
        }
    }

    private static byte[] initIV() {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getAlipayPublicKey() {
        return this.alipayPublicKey;
    }

    public void setAlipayPublicKey(String alipayPublicKey) {
        this.alipayPublicKey = alipayPublicKey;
    }

    public String getRootCertContent() {
        return this.rootCertContent;
    }

    public void setRootCertContent(String rootCertContent) {
        this.rootCertContent = rootCertContent;
    }

    public String getRootCertSN() {
        return this.rootCertSN;
    }

    public void setRootCertSN(String rootCertSN) {
        this.rootCertSN = rootCertSN;
    }

    public String getAppCertSN() {
        return this.appCertSN;
    }

    public void setAppCertSN(String appCertSN) {
        this.appCertSN = appCertSN;
    }

    public ConcurrentHashMap<String, String> getCachedAlipayPublicKey() {
        return this.cachedAlipayPublicKey;
    }

    public void setCachedAlipayPublicKey(ConcurrentHashMap<String, String> cachedAlipayPublicKey) {
        this.cachedAlipayPublicKey = cachedAlipayPublicKey;
    }

    public String getEncryptType() {
        return this.encryptType;
    }

    public void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }
}

