/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.client.utils;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageAccessor;
import com.aliyun.openservices.ons.api.SystemProperties;
import com.aliyun.openservices.ons.api.TopicPartition;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageImpl;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageQueue;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.protocol.SystemAttribute;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class UtilAll {
    private static final Logger log = LoggerFactory.getLogger(UtilAll.class);
    private static final String INSTANCE_REGEX = "MQ_INST_\\w+_\\w+";
    private static final Pattern NAME_SERVER_ENDPOINT_PATTERN = Pattern.compile("^(\\w+://|).*");
    private static final Pattern NAME_SERVER_ENDPOINT_WITH_NAMESPACE_PATTERN = Pattern.compile("^(\\w+://|)MQ_INST_\\w+_\\w+\\..*");

    private UtilAll() {
    }

    public static Message msgConvert(MessageExt rmqMessageExt) {
        String topic = rmqMessageExt.getTopic();
        if (StringUtils.isAnyBlank(topic)) {
            throw new ONSClientException("Rocketmq's message topic has blank unexpectedly.");
        }
        SystemProperties systemProperties = new SystemProperties();
        String tag = rmqMessageExt.getTag();
        String keys = rmqMessageExt.getKeys();
        systemProperties.setTag(tag);
        systemProperties.setKey(keys);
        systemProperties.setMsgId(rmqMessageExt.getMsgId());
        systemProperties.setShardingKey(rmqMessageExt.getMessageGroup());
        systemProperties.setReconsumeTimes(rmqMessageExt.getReconsumeTimes());
        systemProperties.setBornTimestamp(rmqMessageExt.getBornTimestamp());
        systemProperties.setBornHost(rmqMessageExt.getBornHost());
        systemProperties.setStartDeliverTime(rmqMessageExt.getDeliveryTimestamp());
        systemProperties.setPartitionOffset(rmqMessageExt.getQueueOffset());
        Properties userProperties = new Properties();
        userProperties.putAll(rmqMessageExt.getUserProperties());
        return MessageAccessor.message(topic, rmqMessageExt.getBody(), systemProperties, userProperties);
    }

    public static com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message msgConvert(Message message) {
        String bornHost;
        String shardingKey;
        String tag;
        if (null == message) {
            throw new ONSClientException("ONS message is null unexpectedly.");
        }
        String topic = message.getTopic();
        if (StringUtils.isAnyBlank(topic)) {
            throw new ONSClientException("ONS topic has blank, please set it.");
        }
        ConcurrentHashMap<String, String> userAttribute = new ConcurrentHashMap<String, String>();
        Properties userProperties = message.getUserProperties();
        for (String propertyName : userProperties.stringPropertyNames()) {
            userAttribute.put(propertyName, userProperties.getProperty(propertyName));
        }
        byte[] body = message.getBody();
        if (null == body) {
            throw new ONSClientException("ONS message body is empty, please set it.");
        }
        SystemAttribute systemAttribute = new SystemAttribute();
        systemAttribute.setBornTimeMillis(message.getBornTimestamp());
        String key = message.getKey();
        if (null != key) {
            systemAttribute.setKey(key);
        }
        if (null != (tag = message.getTag())) {
            systemAttribute.setTag(tag);
        }
        systemAttribute.setMessageId(message.getMsgID());
        long startDeliverTime = message.getStartDeliverTime();
        if (startDeliverTime > 0L) {
            systemAttribute.setDeliveryTimeMillis(startDeliverTime);
        }
        if (null != (shardingKey = message.getShardingKey())) {
            systemAttribute.setMessageGroup(shardingKey);
        }
        if (null != (bornHost = message.getBornHost())) {
            systemAttribute.setBornHost(bornHost);
        }
        MessageImpl messageImpl = new MessageImpl(message.getTopic(), systemAttribute, userAttribute, body);
        return new com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message(messageImpl);
    }

    public static boolean validateNameServerEndpoint(String endpoint) {
        return StringUtils.isNoneBlank(endpoint) && (NAME_SERVER_ENDPOINT_PATTERN.matcher(endpoint).matches() || NAME_SERVER_ENDPOINT_WITH_NAMESPACE_PATTERN.matcher(endpoint).matches());
    }

    public static TopicPartition convertToPartition(MessageQueue messageQueue) {
        String topic = messageQueue.getTopic();
        String partition = messageQueue.getBrokerName() + "#" + messageQueue.getQueueId();
        return new TopicPartition(topic, partition);
    }

    public static MessageQueue convertToMq(TopicPartition topicPartition) {
        String topic = topicPartition.getTopic();
        String[] tmp = topicPartition.getPartition().split("#");
        if (tmp.length != 2) {
            log.warn("Failed to get message queue from topicPartition={}", (Object)topicPartition);
            throw new ONSClientException("Failed to get message queue");
        }
        String brokerName = tmp[0];
        int queueId = Integer.parseInt(tmp[1]);
        return new MessageQueue(topic, brokerName, queueId);
    }
}

