/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceFlags;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableTraceFlags
extends TraceFlags {
    private static final ImmutableTraceFlags[] INSTANCES = ImmutableTraceFlags.buildInstances();
    private static final byte SAMPLED_BIT = 1;
    static final ImmutableTraceFlags DEFAULT = ImmutableTraceFlags.fromByte((byte)0);
    static final ImmutableTraceFlags SAMPLED = ImmutableTraceFlags.fromByte((byte)1);
    static final int HEX_LENGTH = 2;
    private final String hexRep;
    private final byte byteRep;

    public static ImmutableTraceFlags fromHex(CharSequence src, int srcOffset) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        return ImmutableTraceFlags.fromByte(OtelEncodingUtils.byteFromBase16(src.charAt(srcOffset), src.charAt(srcOffset + 1)));
    }

    public static ImmutableTraceFlags fromByte(byte traceFlagsByte) {
        return INSTANCES[traceFlagsByte & 0xFF];
    }

    private static ImmutableTraceFlags[] buildInstances() {
        ImmutableTraceFlags[] instances = new ImmutableTraceFlags[256];
        for (int i = 0; i < 256; ++i) {
            instances[i] = new ImmutableTraceFlags((byte)i);
        }
        return instances;
    }

    private ImmutableTraceFlags(byte byteRep) {
        char[] result = new char[2];
        OtelEncodingUtils.byteToBase16(byteRep, result, 0);
        this.hexRep = new String(result);
        this.byteRep = byteRep;
    }

    @Override
    public boolean isSampled() {
        return (this.byteRep & 1) != 0;
    }

    @Override
    public String asHex() {
        return this.hexRep;
    }

    @Override
    public byte asByte() {
        return this.byteRep;
    }

    public String toString() {
        return this.asHex();
    }
}

