/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.internal;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.BiConsumer;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.internal.CommonAdapter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.internal.ResourceAdapter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.common.v1.StringKeyValue;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleDataPoint;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleGauge;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleHistogram;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleSum;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleSummary;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.IntDataPoint;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.IntGauge;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.IntSum;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.Metric;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSumData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongGaugeData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.LongSumData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MetricAdapter {
    public static List<ResourceMetrics> toProtoResourceMetrics(Collection<MetricData> metricData) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> resourceAndLibraryMap = MetricAdapter.groupByResourceAndLibrary(metricData);
        ArrayList<ResourceMetrics> resourceMetrics = new ArrayList<ResourceMetrics>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibraryMetrics> instrumentationLibraryMetrics = new ArrayList<InstrumentationLibraryMetrics>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Metric>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibraryMetrics.add(InstrumentationLibraryMetrics.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllMetrics((Iterable<? extends Metric>)entryLibrary.getValue()).build());
            }
            resourceMetrics.add(ResourceMetrics.newBuilder().setResource(ResourceAdapter.toProtoResource(entryResource.getKey())).addAllInstrumentationLibraryMetrics(instrumentationLibraryMetrics).build());
        }
        return resourceMetrics;
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> groupByResourceAndLibrary(Collection<MetricData> metricDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> result = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>>();
        for (MetricData metricData : metricDataList) {
            InstrumentationLibraryInfo libraryInfo;
            ArrayList<Metric> metricList;
            if (metricData.isEmpty()) continue;
            Resource resource = metricData.getResource();
            HashMap<InstrumentationLibraryInfo, ArrayList<Metric>> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, ArrayList<Metric>>)result.get(metricData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, ArrayList<Metric>>();
                result.put(resource, libraryInfoListMap);
            }
            if ((metricList = (ArrayList<Metric>)libraryInfoListMap.get(libraryInfo = metricData.getInstrumentationLibraryInfo())) == null) {
                metricList = new ArrayList<Metric>();
                libraryInfoListMap.put(libraryInfo, metricList);
            }
            metricList.add(MetricAdapter.toProtoMetric(metricData));
        }
        return result;
    }

    static Metric toProtoMetric(MetricData metricData) {
        Metric.Builder builder = Metric.newBuilder().setName(metricData.getName()).setDescription(metricData.getDescription()).setUnit(metricData.getUnit());
        switch (metricData.getType()) {
            case LONG_SUM: {
                LongSumData longSumData = metricData.getLongSumData();
                builder.setIntSum(IntSum.newBuilder().setIsMonotonic(longSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(longSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toIntDataPoints(longSumData.getPoints())).build());
                break;
            }
            case DOUBLE_SUM: {
                DoubleSumData doubleSumData = metricData.getDoubleSumData();
                builder.setDoubleSum(DoubleSum.newBuilder().setIsMonotonic(doubleSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(doubleSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleSumData.getPoints())).build());
                break;
            }
            case SUMMARY: {
                DoubleSummaryData doubleSummaryData = metricData.getDoubleSummaryData();
                builder.setDoubleSummary(DoubleSummary.newBuilder().addAllDataPoints(MetricAdapter.toSummaryDataPoints(doubleSummaryData.getPoints())).build());
                break;
            }
            case LONG_GAUGE: {
                LongGaugeData longGaugeData = metricData.getLongGaugeData();
                builder.setIntGauge(IntGauge.newBuilder().addAllDataPoints(MetricAdapter.toIntDataPoints(longGaugeData.getPoints())).build());
                break;
            }
            case DOUBLE_GAUGE: {
                DoubleGaugeData doubleGaugeData = metricData.getDoubleGaugeData();
                builder.setDoubleGauge(DoubleGauge.newBuilder().addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleGaugeData.getPoints())).build());
                break;
            }
            case HISTOGRAM: {
                DoubleHistogramData doubleHistogramData = metricData.getDoubleHistogramData();
                builder.setDoubleHistogram(DoubleHistogram.newBuilder().setAggregationTemporality(MetricAdapter.mapToTemporality(doubleHistogramData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toDoubleHistogramDataPoints(doubleHistogramData.getPoints())).build());
            }
        }
        return builder.build();
    }

    private static AggregationTemporality mapToTemporality(com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality temporality) {
        switch (temporality) {
            case CUMULATIVE: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
            }
            case DELTA: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
            }
        }
        return AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
    }

    static List<IntDataPoint> toIntDataPoints(Collection<LongPointData> points) {
        ArrayList<IntDataPoint> result = new ArrayList<IntDataPoint>(points.size());
        for (LongPointData longPoint : points) {
            IntDataPoint.Builder builder = IntDataPoint.newBuilder().setStartTimeUnixNano(longPoint.getStartEpochNanos()).setTimeUnixNano(longPoint.getEpochNanos()).setValue(longPoint.getValue());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(longPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static Collection<DoubleDataPoint> toDoubleDataPoints(Collection<DoublePointData> points) {
        ArrayList<DoubleDataPoint> result = new ArrayList<DoubleDataPoint>(points.size());
        for (DoublePointData doublePoint : points) {
            DoubleDataPoint.Builder builder = DoubleDataPoint.newBuilder().setStartTimeUnixNano(doublePoint.getStartEpochNanos()).setTimeUnixNano(doublePoint.getEpochNanos()).setValue(doublePoint.getValue());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(doublePoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static List<DoubleSummaryDataPoint> toSummaryDataPoints(Collection<DoubleSummaryPointData> points) {
        ArrayList<DoubleSummaryDataPoint> result = new ArrayList<DoubleSummaryDataPoint>(points.size());
        for (DoubleSummaryPointData doubleSummaryPoint : points) {
            DoubleSummaryDataPoint.Builder builder = DoubleSummaryDataPoint.newBuilder().setStartTimeUnixNano(doubleSummaryPoint.getStartEpochNanos()).setTimeUnixNano(doubleSummaryPoint.getEpochNanos()).setCount(doubleSummaryPoint.getCount()).setSum(doubleSummaryPoint.getSum());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(doubleSummaryPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            if (!doubleSummaryPoint.getPercentileValues().isEmpty()) {
                for (ValueAtPercentile valueAtPercentile : doubleSummaryPoint.getPercentileValues()) {
                    builder.addQuantileValues(DoubleSummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(valueAtPercentile.getPercentile() / 100.0).setValue(valueAtPercentile.getValue()).build());
                }
            }
            result.add(builder.build());
        }
        return result;
    }

    static Collection<DoubleHistogramDataPoint> toDoubleHistogramDataPoints(Collection<DoubleHistogramPointData> points) {
        ArrayList<DoubleHistogramDataPoint> result = new ArrayList<DoubleHistogramDataPoint>(points.size());
        for (DoubleHistogramPointData doubleHistogramPoint : points) {
            List<StringKeyValue> labels;
            DoubleHistogramDataPoint.Builder builder = DoubleHistogramDataPoint.newBuilder().setStartTimeUnixNano(doubleHistogramPoint.getStartEpochNanos()).setTimeUnixNano(doubleHistogramPoint.getEpochNanos()).setCount(doubleHistogramPoint.getCount()).setSum(doubleHistogramPoint.getSum()).addAllBucketCounts(doubleHistogramPoint.getCounts());
            List<Double> boundaries = doubleHistogramPoint.getBoundaries();
            if (!boundaries.isEmpty()) {
                builder.addAllExplicitBounds(boundaries);
            }
            if (!(labels = MetricAdapter.toProtoLabels(doubleHistogramPoint.getLabels())).isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static List<StringKeyValue> toProtoLabels(Labels labels) {
        if (labels.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList<StringKeyValue> result = new ArrayList<StringKeyValue>(labels.size());
        labels.forEach((BiConsumer<? super String, ? super String>)new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                result.add(StringKeyValue.newBuilder().setKey(key).setValue(value).build());
            }
        });
        return result;
    }

    private MetricAdapter() {
    }
}

