/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace;

import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.FutureCallback;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.Futures;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.aliyun.openservices.ons.shaded.io.grpc.ConnectivityState;
import com.aliyun.openservices.ons.shaded.io.grpc.ManagedChannel;
import com.aliyun.openservices.ons.shaded.io.grpc.Status;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.BoundLongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.GlobalMeterProvider;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.LongCounter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.Meter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.internal.SpanAdapter;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
extends SpanExporter {
    private static final String EXPORTER_NAME = OtlpGrpcSpanExporter.class.getSimpleName();
    private static final Labels EXPORTER_NAME_LABELS = Labels.of("exporter", EXPORTER_NAME);
    private static final Labels EXPORT_SUCCESS_LABELS = Labels.of("exporter", EXPORTER_NAME, "success", "true");
    private static final Labels EXPORT_FAILURE_LABELS = Labels.of("exporter", EXPORTER_NAME, "success", "false");
    private final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(OtlpGrpcSpanExporter.class.getName()));
    private final TraceServiceGrpc.TraceServiceFutureStub traceService;
    private final ManagedChannel managedChannel;
    private final long timeoutNanos;
    private final BoundLongCounter spansSeen;
    private final BoundLongCounter spansExportedSuccess;
    private final BoundLongCounter spansExportedFailure;

    OtlpGrpcSpanExporter(ManagedChannel channel, long timeoutNanos) {
        Meter meter = GlobalMeterProvider.getMeter("com.aliyun.openservices.ons.shaded.io.opentelemetry.exporters.otlp");
        this.spansSeen = meter.longCounterBuilder("spansSeenByExporter").build().bind(EXPORTER_NAME_LABELS);
        LongCounter spansExportedCounter = meter.longCounterBuilder("spansExportedByExporter").build();
        this.spansExportedSuccess = spansExportedCounter.bind(EXPORT_SUCCESS_LABELS);
        this.spansExportedFailure = spansExportedCounter.bind(EXPORT_FAILURE_LABELS);
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        this.traceService = TraceServiceGrpc.newFutureStub(channel);
    }

    @Override
    public CompletableResultCode export(final Collection<SpanData> spans) {
        this.spansSeen.add(spans.size());
        ExportTraceServiceRequest exportTraceServiceRequest = ExportTraceServiceRequest.newBuilder().addAllResourceSpans(SpanAdapter.toProtoResourceSpans(spans)).build();
        final CompletableResultCode result = new CompletableResultCode();
        TraceServiceGrpc.TraceServiceFutureStub exporter = this.timeoutNanos > 0L ? (TraceServiceGrpc.TraceServiceFutureStub)this.traceService.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS) : this.traceService;
        Futures.addCallback(exporter.export(exportTraceServiceRequest), new FutureCallback<ExportTraceServiceResponse>(){

            @Override
            public void onSuccess(@Nullable ExportTraceServiceResponse response) {
                OtlpGrpcSpanExporter.this.spansExportedSuccess.add(spans.size());
                result.succeed();
            }

            @Override
            public void onFailure(Throwable t2) {
                OtlpGrpcSpanExporter.this.spansExportedFailure.add(spans.size());
                Status status = Status.fromThrowable(t2);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.SEVERE, "Failed to export spans. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. Full error message: " + t2.getMessage());
                        break;
                    }
                    case UNAVAILABLE: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.SEVERE, "Failed to export spans. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + t2.getMessage());
                        break;
                    }
                    default: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.WARNING, "Failed to export spans. Error message: " + t2.getMessage());
                    }
                }
                if (OtlpGrpcSpanExporter.this.logger.isLoggable(Level.FINEST)) {
                    OtlpGrpcSpanExporter.this.logger.log(Level.FINEST, "Failed to export spans. Details follow: " + t2);
                }
                result.fail();
            }
        }, MoreExecutors.directExecutor());
        return result;
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    @Override
    public CompletableResultCode shutdown() {
        final CompletableResultCode result = new CompletableResultCode();
        this.managedChannel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, new Runnable(){

            @Override
            public void run() {
                result.succeed();
            }
        });
        this.managedChannel.shutdown();
        this.spansSeen.unbind();
        this.spansExportedSuccess.unbind();
        this.spansExportedFailure.unbind();
        return result;
    }

    long getTimeoutNanos() {
        return this.timeoutNanos;
    }
}

