/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace;

import com.aliyun.openservices.ons.shaded.grpc.netty.NettyChannelBuilder;
import com.aliyun.openservices.ons.shaded.io.grpc.ManagedChannel;
import com.aliyun.openservices.ons.shaded.io.grpc.ManagedChannelBuilder;
import com.aliyun.openservices.ons.shaded.io.grpc.Metadata;
import com.aliyun.openservices.ons.shaded.io.grpc.netty.GrpcSslContexts;
import com.aliyun.openservices.ons.shaded.io.grpc.stub.MetadataUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.Utils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class OtlpGrpcSpanExporterBuilder {
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private ManagedChannel channel;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private URI endpoint = DEFAULT_ENDPOINT;
    @Nullable
    private Metadata metadata;
    @Nullable
    private byte[] trustedCertificatesPem;

    public OtlpGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        Utils.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        URI uri;
        if (endpoint == null) {
            throw new NullPointerException("endpoint");
        }
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint, must be a URL: " + endpoint, e);
        }
        if (uri.getScheme() == null || !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("Invalid endpoint, must start with http:// or https://: " + uri);
        }
        this.endpoint = uri;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder addHeader(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        this.metadata.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
        return this;
    }

    public OtlpGrpcSpanExporter build() {
        if (this.channel == null) {
            ManagedChannelBuilder<?> managedChannelBuilder = ManagedChannelBuilder.forTarget(this.endpoint.getAuthority());
            if (this.endpoint.getScheme().equals("https")) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(MetadataUtils.newAttachHeadersInterceptor(this.metadata));
            }
            if (this.trustedCertificatesPem != null) {
                if (managedChannelBuilder.getClass().getName().equals("com.aliyun.openservices.ons.shaded.io.grpc.netty.NettyChannelBuilder")) {
                    com.aliyun.openservices.ons.shaded.io.grpc.netty.NettyChannelBuilder nettyBuilder = (com.aliyun.openservices.ons.shaded.io.grpc.netty.NettyChannelBuilder)managedChannelBuilder;
                    try {
                        nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager((InputStream)new ByteArrayInputStream(this.trustedCertificatesPem)).build());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                    catch (SSLException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                } else if (managedChannelBuilder.getClass().getName().equals("com.aliyun.openservices.ons.shaded.grpc.netty.NettyChannelBuilder")) {
                    NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
                    try {
                        nettyBuilder.sslContext(com.aliyun.openservices.ons.shaded.grpc.netty.GrpcSslContexts.forClient().trustManager(new ByteArrayInputStream(this.trustedCertificatesPem)).build());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                    catch (SSLException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                } else {
                    throw new IllegalStateException("TLS cerificate configuration only supported with Netty. If you need to configure a certificate, switch to grpc-netty or grpc-netty-shaded.");
                }
            }
            this.channel = managedChannelBuilder.build();
        }
        return new OtlpGrpcSpanExporter(this.channel, this.timeoutNanos);
    }

    OtlpGrpcSpanExporterBuilder() {
    }
}

